package common.data.db;

import java.util.HashMap;
import java.util.Set;

public class SQLiteTableData {
    private SQLiteTable sqLiteTable;
    private String updatewhere = " 1=1 ";

    public SQLiteTableData(SQLiteTable sqLiteTable) {
        this.sqLiteTable = sqLiteTable;
    }

    private HashMap<String, Object> map = new HashMap<>();

    public void set(String fieldname, Object value) {
        if (value instanceof String) {
            set(fieldname, value.toString(), false);
        } else {
            map.put(fieldname, value);
        }
    }

    public void set(String fieldname, String value, boolean Keepspecialcharacters) {
        if (Keepspecialcharacters) {
            value = value.replace("'", "''");
            //value = value.replace("'", "\\'");
            map.put(fieldname, value);
        } else {
            value = value.replaceAll("([';])+|(--)+", "");//去除特殊字符，防止sql注入
            map.put(fieldname, value);
        }
    }

    public void setUpdateWhere(String updatewhere) {
        this.updatewhere = updatewhere.replace("where", "");
    }

    public Object get(String fieldname) {
        return map.get(fieldname);
    }

    public void insert() {
        if (!map.keySet().isEmpty()) {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("insert into " + sqLiteTable.getTablename() + "(");
            Set<String> tableColumnSet = map.keySet();
            {
                boolean isfirst = true;
                for (String columnname : tableColumnSet) {
                    if (isfirst) {
                        sqlBuffer.append(columnname);
                        isfirst = false;
                    } else {
                        sqlBuffer.append(",").append(columnname);
                    }
                }
            }
            sqlBuffer.append(")values(");
            {
                boolean isfirst = true;
                for (String columnname : tableColumnSet) {
                    if (isfirst) {
                        sqlBuffer.append("'").append(get(columnname)).append("'");
                        isfirst = false;
                    } else {
                        sqlBuffer.append(",").append("'").append(get(columnname)).append("'");
                    }
                }
            }
            sqlBuffer.append(");");
            SQLiteMemory.runSqlUpdate(sqlBuffer.toString());
        }
    }

    public void update() {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update " + sqLiteTable.getTablename() + "set ");
        {
            boolean isfirst = true;
            for (String columnname : map.keySet()) {
                if (isfirst) {
                    sqlBuffer.append(columnname).append("='").append(get(columnname)).append("'");
                    isfirst = false;
                } else {
                    sqlBuffer.append(",").append(columnname).append("='").append(get(columnname)).append("'");
                }
            }
        }
        sqlBuffer.append(" where ").append(updatewhere);
        SQLiteMemory.runSqlUpdate(sqlBuffer.toString());
    }
}
