package restcontroller.system.payment;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.annotation.API;
import utility.tools.Encryption;
import utility.wechat.miniprogram.WechatMiniProgram;
import utility.wechat.wechatpay.POJO.CreateOrderResponse;
import utility.wechat.wechatpay.nativepay.NativePay;

import java.util.Calendar;

import common.YosException;

public class wechatpay extends Controller {
    public wechatpay(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 生成微信支付二维码，用户扫码支付场景
     *
     * @return
     */
    @API(title = "扫码支付，获取支付二维码")
    public String createNativeWechatOrder() throws YosException {
        String orderno = content.getString("orderno");
        NativePay nativepay = new NativePay("微信支付端名称");//wechatclient name
        try {
            nativepay.setup();
            String codeurl = nativepay.createPayOrder(orderno);
            nativepay.after();
            if (!codeurl.equals("")) {
                return getSucReturnObject().setData(codeurl).toString();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getErrReturnObject().setErrMsg("调用失败").toString();
    }

    /**
     * 创建微信支付订单
     *
     * @return
     */
    @API(title = "app支付")
    public String createWechatOrder() throws YosException {
        String orderno = content.getString("orderno");
        String custip = content.getString("custip");
        String wechat_code = content.getString("wechat_code");
        String ordertype = content.getString("ordertype");
        String title = content.getString("ordertype");
        String trade_type = content.getString("trade_type");//APP、JSAPI

        WechatMiniProgram wechatMiniProgram = new WechatMiniProgram(systemclient);
        CreateOrderResponse response = wechatMiniProgram.createPayOrder(orderno, trade_type, wechat_code, custip, ordertype, title);

        if ("SUCCESS".equals(response.getReturn_code()) && "SUCCESS".equals(response.getResult_code())) {
            String appid = response.getAppid();//应用ID
            String nonceStr = createNonce_str(appid);//随机码
            String package_str = "prepay_id=" + response.getPrepay_id();
            String timeStamp = String.valueOf(Calendar.getInstance().getTime().getTime() / 1000);
            String signType = "MD5";

            JSONObject object = new JSONObject();
            object.put("appId", appid);
            object.put("nonceStr", nonceStr);
            object.put("package", package_str);
            object.put("timeStamp", timeStamp);
            object.put("signType", signType);
            String A = "appId=" + appid + "&nonceStr=" + nonceStr + "&package=" + package_str + "&signType=" + signType + "&timeStamp=" + timeStamp;
            String stringSignTemp = A + "&key=" + wechatMiniProgram.getMch_key();
            object.put("paySign", new Encryption().Encode_MD5(stringSignTemp).toUpperCase());
            return getSucReturnObject().setData(object).toString();
        } else {
            return getErrReturnObject().setErrMsg(response.getErr_code_des()).toString();
        }
    }


    /**
     * 生成随机字符串
     *
     * @return
     */
    protected String createNonce_str(String str) {
        return new Encryption().Encode_MD5(str + Calendar.getInstance().getTimeInMillis()).substring(0, 30);
    }
}
