package restcontroller.sysmanage.develop.sys_object;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;

import java.util.ArrayList;

public class DataValidate extends Controller {
    public DataValidate(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "垃圾数据校验")
    public String dataValidate() throws YosException {

        ArrayList<String> sys_object = dbConnect.runSqlQuery("select table_name from sys_object").toArrayList("table_name");
        JSONArray errArray = new JSONArray();
        Rows ownertable_table_nameRows = dbConnect.runSqlQuery("select table_name from sys_object where exists(select *from sys_objectcols where sys_object.table_name=sys_objectcols.table_name and sys_objectcols.column_name='ownertable') and exists(select *from  sys_objectcols where sys_object.table_name=sys_objectcols.table_name and sys_objectcols.column_name='ownerid')");
        ArrayList<String> ownertable_table_namelist = ownertable_table_nameRows.toArrayList("table_name");
        Rows linkTable_nameRows = dbConnect.runSqlQuery("select distinct t1.table_name,t1.column_name as linkcolumn_name,t2.table_name as linktable_name from sys_objectcols t1 inner join sys_object t2 on t1.column_name=t2.uniquecolumnname and t1.table_name!=t2.table_name");

        RowsMap linkTable_nameRowsMap = linkTable_nameRows.toRowsMap("table_name");

        ArrayList<String> tablenamelist = new ArrayList<>(ownertable_table_namelist);
        for (String table_name : linkTable_nameRows.toArrayList("table_name")) {
            if (!tablenamelist.contains(table_name)) {
                tablenamelist.add(table_name);
            }
        }


        for (String table_name : tablenamelist) {
            JSONObject errtable_object = new JSONObject();
            errtable_object.put("table_name", table_name);
            errtable_object.put("table_comment", getTableName(table_name));
            errtable_object.put("linktable", new JSONArray());
            errtable_object.put("ownertable", new JSONArray());
            int totalcount = 0;

            if (ownertable_table_namelist.contains(table_name)) {
                ArrayList<String> ownertableList = dbConnect.runSqlQuery("select distinct lower(ownertable)as ownertable from " + table_name + " where ifnull(ownertable,'')!=''").toArrayList("ownertable");
                for (String ownertable : ownertableList) {
                    JSONObject ownertableObject = new JSONObject();

                    if (sys_object.contains(ownertable)) {
                        Rows errdataRows = dbConnect.runSqlQuery("select t1." + getuniquecolumnname(table_name) + " as tableid,t1.ownerid from " + table_name + " t1 left join " + ownertable + " t2 on t1.ownerid=t2." + getuniquecolumnname(ownertable) + " where t1.ownertable='" + ownertable + "' and t2." + getuniquecolumnname(ownertable) + " is null");
                        if (errdataRows.isNotEmpty()) {
                            ownertableObject.put("errdatacount", errdataRows.size());
                            totalcount = totalcount + errdataRows.size();
                        }
                    } else {
                        Rows errdataRows = dbConnect.runSqlQuery("select t1." + getuniquecolumnname(table_name) + " as tableid,t1.ownerid from " + table_name + " t1 where t1.ownertable='" + ownertable + "'");
                        if (errdataRows.isNotEmpty()) {
                            ownertableObject.put("errdatacount", errdataRows.size());
                            totalcount = totalcount + errdataRows.size();
                        }
                    }
                    if (!ownertableObject.isEmpty()) {
                        ownertableObject.put("ownertable", ownertable);
                        ownertableObject.put("uniquecolumnname", getuniquecolumnname(ownertable));
                        ownertableObject.put("ownertable_comment", getTableName(ownertable));
                        errtable_object.getJSONArray("ownertable").add(ownertableObject);
                    }
                }
            }
            if (linkTable_nameRowsMap.containsKey(table_name)) {
                for (Row linkTable_nameRow : linkTable_nameRowsMap.get(table_name)) {

                    JSONObject linktableObject = new JSONObject();
                    String linktable_name = linkTable_nameRow.getString("linktable_name");
                    String linkcolumn_name = linkTable_nameRow.getString("linkcolumn_name");

                    Rows errdataRows = dbConnect.runSqlQuery("select t1." + getuniquecolumnname(table_name) + " from " + table_name + " t1 left join " + linktable_name + " t2 on t1." + linkcolumn_name + "=t2." + linkcolumn_name + " where ifnull(t1." + linkcolumn_name + ",0) !=0 and t2." + linkcolumn_name + " is null");
                    if (errdataRows.isNotEmpty()) {
                        linktableObject.put("errdatacount", errdataRows.size());
                        totalcount = totalcount + errdataRows.size();
                    }
                    if (!linktableObject.isEmpty()) {
                        linktableObject.put("linktable", linktable_name);
                        linktableObject.put("uniquecolumnname", getuniquecolumnname(linktable_name));
                        linktableObject.put("linktable_comment", getTableName(linktable_name));
                        errtable_object.getJSONArray("linktable").add(linktableObject);
                    }
                }
            }
            if (!errtable_object.getJSONArray("linktable").isEmpty() || !errtable_object.getJSONArray("ownertable").isEmpty()) {
                errtable_object.put("errdatacount", totalcount);
                errArray.add(errtable_object);
            }
        }
        return getSucReturnObject().setData(errArray).toString();
    }
}
