package restcontroller.sysmanage.develop.hotupdate;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;
import common.parameter.properties;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.util.HotSwapper;
import org.apache.commons.fileupload.FileItem;

import java.io.File;

@API(title = "管理端-开发-代码热更新管理")
public class hotupdate extends Controller {
    public hotupdate(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "热更新记录查询")
    public String queryUpdateClass() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "查询更新记录", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("porttype", "server");
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 新增一个热部署类文件
     *
     * @return
     */
    //@API(title = "新增一个热部署类文件")
    public String createUpdateClass() throws YosException {
        String classname = content.getString("classname");
        String fnotes = content.getString("fnotes");

        long updateid = createTableID("sys_hotupdate");//获取热更新ID

        //String UPLOAD_DIRECTORY = properties.getYosProperties().getProperty("system.hotupdate.classpath");
        String UPLOAD_DIRECTORY = properties.getYosProperties().getProperty("");
        if (requestFileItemList.size() != 1) {
            return getErrReturnObject().setErrMsg("必须且只能上传一个class文件!").toString();
        }
        for (FileItem item : requestFileItemList) {
            if (!item.isFormField()) {//如果是文件参数则进入执行
                String fileName = new File(item.getName()).getName();
                if (!fileName.endsWith(".class")) {
                    return getErrReturnObject().setErrMsg("上传文件必须是class文件").toString();
                }
                if (!classname.endsWith(fileName.replace(".class", ""))) {
                    return getErrReturnObject().setErrMsg("文件名称和类名不符!").toString();
                }
                String filePath = UPLOAD_DIRECTORY + File.separator + updateid + File.separator + classname.replace(".", "/") + ".class";
                filePath = filePath.replace(fileName, "");

                File classfilepath = new File(filePath);
                if (!classfilepath.exists()) {
                    classfilepath.mkdirs();
                }
                File classfile = new File(filePath + fileName);
                if (classfile.exists()) {
                    classfile.delete();
                }
                try {
                    item.write(new File(filePath + fileName));
                } catch (Exception e) {
                    e.printStackTrace();
                    return getErrReturnObject().setErrMsg("文件上传失败!").toString();
                }
            }
        }
        SQLFactory sqlFactory = new SQLFactory(this, "插入更新记录");
        sqlFactory.addParameter("updateid", createTableID("sys_hotupdate"));
        sqlFactory.addParameter("classname", classname);
        sqlFactory.addParameter("fnotes", fnotes);
        sqlFactory.addParameter("createby", username);
        sqlFactory.addParameter("updatetime", "null");
        sqlFactory.addParameter("porttype", "server");
        sqlFactory.addParameter("status", "待更新");
        dbConnect.runSqlUpdate(sqlFactory);
        return getSucReturnObject().toString();
    }

    @API(title = "删除一个热部署类文件")
    public String deleteUpdateClass() throws YosException {
        long updateid = content.getLong("updateid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_hotupdate where updateid=" + updateid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("不存在的更新记录").toString();
        }
        if (rows.get(0).getString("status").equals("已更新")) {
            return getErrReturnObject().setErrMsg("该记录不可删除").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_hotupdate where updateid=" + updateid);
        return getSucReturnObject().setData(rows).toString();
    }

    public static HotSwapper hs = null;

    /**
     * 热更新
     *
     * @return
     */
    //@API(title = "热更新执行")
    public String updateclass() throws YosException {
        String updateid = content.getString("updateid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_hotupdate where updateid=" + updateid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("不存在的更新记录").toString();
        }
        String status = rows.get(0).getString("status");
        if ("新建".equals(status)) {
            return getErrReturnObject().setErrMsg("请上传class文件").toString();
        }
        if ("已更新".equals(status)) {
            return getErrReturnObject().setErrMsg("更新已处理！").toString();
        }
        String classname = rows.get(0).getString("classname");
        try {
            Class.forName(classname);
            if (hs == null) {
                //-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=8000
                //hs = new HotSwapper(properties.getYosProperties().getProperty("system.hotupdate.port"));
            }
            ClassPool classPool = ClassPool.getDefault();
            //classPool.insertClassPath(properties.getYosProperties().getProperty("system.hotupdate.classpath") + updateid + "/");
            CtClass ctClass = classPool.get(classname);
            hs.reload(classname, ctClass.toBytecode());
            dbConnect.runSqlUpdate("update sys_hotupdate set status='已更新' where  updateid=" + updateid);
        } catch (Exception e) {
            e.printStackTrace();
            return getErrReturnObject().setErrMsg(e.getMessage()).toString();
        }
        return getSucReturnObject().toString();
    }
}
