package restcontroller.sysmanage.develop.datawarn;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;

public class datawarn extends Controller {
    public datawarn(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "数据异常列表查询")
    public String queryWarnList() throws YosException {
        boolean witherrdata = content.getBooleanValue("witherrdata");
        Rows datawarnRows;
        if (witherrdata) {
            datawarnRows = dbConnect.runSqlQuery("select * from sys_datawarn where isused=1 order by sequence");
            for (Row datawarnRow : datawarnRows) {
                try {
                    Rows r = dbConnect.runSqlQuery(datawarnRow.getString("sqlstr"));
                    datawarnRow.put("errdatas", r);
                    datawarnRow.put("status", r.isEmpty() ? "正常" : "异常");
                    datawarnRow.put("errdatacolumns", r.getFieldList());
                } catch (Exception e) {
                    datawarnRow.put("errdatas", new Rows());
                    datawarnRow.put("status", "SQL语句错误");
                }
            }
        } else {
            datawarnRows = dbConnect.runSqlQuery("select * from sys_datawarn order by sequence");
        }
        return getSucReturnObject().setData(datawarnRows).toString();
    }

    @API(title = "数据异常新增修改")
    public String insertormodifyWarn() throws YosException {
        long sys_datawarnid = content.getLongValue("sys_datawarnid");
        String title = content.getString("title");
        String remarks = content.getStringValue("remarks");
        String sqlstr = content.getString("sqlstr", true);
        try {
            dbConnect.runSqlQuery(content.getString("sqlstr", true).replace("\\'", "'"));
        } catch (Exception e) {
            return getErrReturnObject().setErrMsg("无效的sql查询语句").toString();
        }
        boolean isused = content.getBooleanValue("isused");
        int sequence = content.getIntValue("sequence");
        if (sys_datawarnid == 0 || dbConnect.runSqlQuery("select * from sys_datawarn where sys_datawarnid=" + sys_datawarnid).isEmpty()) {
            SimpleInsert simpleInsert = SQLFactory.getSimpleInsert("sys_datawarn");
            simpleInsert.addValueField("sys_datawarnid", createTableID("sys_datawarn"));
            simpleInsert.addValueField("title", title);
            simpleInsert.addValueField("remarks", remarks);
            simpleInsert.addValueField("sqlstr", sqlstr);
            simpleInsert.addValueField("isused", isused);
            simpleInsert.addValueField("sequence", sequence);
            simpleInsert.run(dbConnect);
        } else {
            SimpleUpdate simpleUpdate = SQLFactory.getSimpleUpdate("sys_datawarn");
            simpleUpdate.addValueField("title", title);
            simpleUpdate.addValueField("remarks", remarks);
            simpleUpdate.addValueField("sqlstr", sqlstr);
            simpleUpdate.addValueField("isused", isused);
            simpleUpdate.addValueField("sequence", sequence);
            simpleUpdate.addWhere("sys_datawarnid", sys_datawarnid);
            simpleUpdate.run(dbConnect);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "数据异常删除")
    public String deleteWarn() throws YosException {
        long sys_datawarnid = content.getLong("sys_datawarnid");
        dbConnect.runSqlUpdate("delete from sys_datawarn where sys_datawarnid=" + sys_datawarnid);
        return getSucReturnObject().toString();
    }

}
