package restcontroller.sysmanage.develop.datamag.administrativearea;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.SimpleInsert;
import common.data.SimpleUpdate;

/**
 * 行政区域管理
 */
public class administrativearea extends Controller {

    public administrativearea(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "省份查询")
    public String queryProvinces() throws YosException {
        Rows provinceRows = dbConnect.runSqlQuery("select * from t_province order by provinceid");
        return getSucReturnObject().setData(provinceRows).toString();
    }

    @API(title = "省份新增")
    public String insertOrModifyProvinces() throws YosException {
        long provinceid = content.getLong("provinceid");
        String provincenum = content.getString("provincenum");
        String province = content.getString("province");
        if (provinceid <= 0 || dbConnect.runSqlQuery("select * from t_province where provinceid=" + provinceid).isEmpty()) {
            SimpleInsert simpleInsert = SQLFactory.getSimpleInsert("t_province");
            simpleInsert.addValueField("provinceid", createTableID("t_province"));
            simpleInsert.addValueField("provincenum", provincenum);
            simpleInsert.addValueField("province", province);
            simpleInsert.run(dbConnect);
        } else {
            SimpleUpdate simpleInsert = SQLFactory.getSimpleUpdate("t_province");
            simpleInsert.addValueField("provincenum", provincenum);
            simpleInsert.addValueField("province", province);
            simpleInsert.addWhere("provinceid", provinceid);
            simpleInsert.run(dbConnect);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "省份删除")
    public String deleteProvinces() throws YosException {
        long provinceid = content.getLong("provinceid");
        dbConnect.runSqlUpdate("delete from t_province where provinceid=" + provinceid);
        return getSucReturnObject().toString();
    }


    @API(title = "城市查询")
    public String queryCitys() throws YosException {
        long provinceid = content.getLong("provinceid");
        Rows cityRows = dbConnect.runSqlQuery("select * from t_city where provinceid=" + provinceid + " order by cityid");
        return getSucReturnObject().setData(cityRows).toString();
    }

    @API(title = "城市新增")
    public String insertOrModifyCitys() throws YosException {
        long provinceid = content.getLong("provinceid");
        long cityid = content.getLong("cityid");
        String citynum = content.getString("citynum");
        String city = content.getString("city");

        if (dbConnect.runSqlQuery("select * from t_province where provinceid=" + provinceid).isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到相应的省份信息").toString();
        }
        if (cityid <= 0 || dbConnect.runSqlQuery("select * from t_city where cityid=" + cityid).isEmpty()) {
            SimpleInsert simpleInsert = SQLFactory.getSimpleInsert("t_city");
            simpleInsert.addValueField("cityid", createTableID("t_city"));
            simpleInsert.addValueField("provinceid", provinceid);
            simpleInsert.addValueField("citynum", citynum);
            simpleInsert.addValueField("city", city);
            simpleInsert.run(dbConnect);
        } else {
            SimpleUpdate simpleInsert = SQLFactory.getSimpleUpdate("t_city");
            simpleInsert.addValueField("citynum", citynum);
            simpleInsert.addValueField("city", city);
            simpleInsert.addWhere("provinceid", provinceid);
            simpleInsert.addWhere("cityid", cityid);
            simpleInsert.run(dbConnect);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "城市删除")
    public String deleteCitys() throws YosException {
        long cityid = content.getLong("cityid");
        dbConnect.runSqlUpdate("delete from t_city where cityid=" + cityid);
        return getSucReturnObject().toString();
    }


    @API(title = "区县查询")
    public String queryCounties() throws YosException {
        long cityid = content.getLong("cityid");
        Rows countyRows = dbConnect.runSqlQuery("select * from t_county where cityid=" + cityid + " order by countyid");
        return getSucReturnObject().setData(countyRows).toString();
    }

    @API(title = "区县新增")
    public String insertOrModifyCounties() throws YosException {
        long cityid = content.getLong("cityid");
        long countyid = content.getLong("countyid");
        String countynum = content.getString("countynum");
        String county = content.getString("county");

        if (dbConnect.runSqlQuery("select * from t_city where cityid=" + cityid).isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到相应的城市信息").toString();
        }
        if (countyid <= 0 || dbConnect.runSqlQuery("select * from t_county where countyid=" + countyid).isEmpty()) {
            SimpleInsert simpleInsert = SQLFactory.getSimpleInsert("t_county");
            simpleInsert.addValueField("countyid", createTableID("t_county"));
            simpleInsert.addValueField("cityid", cityid);
            simpleInsert.addValueField("countynum", countynum);
            simpleInsert.addValueField("county", county);
            simpleInsert.run(dbConnect);
        } else {
            SimpleUpdate simpleInsert = SQLFactory.getSimpleUpdate("t_county");
            simpleInsert.addValueField("countynum", countynum);
            simpleInsert.addValueField("county", county);
            simpleInsert.addWhere("cityid", cityid);
            simpleInsert.addWhere("countyid", countyid);
            simpleInsert.run(dbConnect);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "区县删除")
    public String deleteCounties() throws YosException {
        long countyid = content.getLong("countyid");
        dbConnect.runSqlUpdate("delete from t_county where countyid=" + countyid);
        return getSucReturnObject().toString();
    }
}
