package restcontroller.sysmanage.develop.api;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.api.YOSAPI;
import common.data.SQLFactory;
import common.data.SimpleInsert;
import common.data.SimpleUpdate;
import restcontroller.sysmanage.develop.apidoc.apidoc;
import restcontroller.sysmanage.develop.apimanage.ApiMonitor;

public class Api extends Controller {
    public Api(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "YOSapi接口参数更新", intervaltime = 2000)
    @CACHEING_CLEAN(cms = {@cm(clazz = ApiMonitor.class, method = {"queryApiList"})})
    public String updateApiParam() throws YosException {
        long apiid = content.getLong("apiid");
        int apiversion = content.getIntValue("apiversion", 1);
        long intervaltime = content.getLongValue("intervaltime");

        if (dbConnect.runSqlQuery("select *from sys_api where apiid='" + apiid + "' and apiversion='" + apiversion + "'").isEmpty()) {
            SimpleInsert simpleInsert = SQLFactory.getSimpleInsert("sys_api");
            simpleInsert.addValueField("apiid", apiid);
            simpleInsert.addValueField("apiversion", apiversion);
            simpleInsert.addValueField("intervaltime", intervaltime);
            simpleInsert.run(dbConnect);
        } else {
            SimpleUpdate simpleUpdate = SQLFactory.getSimpleUpdate("sys_api");
            simpleUpdate.addValueField("intervaltime", intervaltime);
            simpleUpdate.addWhere("apiid", apiid);
            simpleUpdate.addWhere("apiversion", apiversion);
            simpleUpdate.run(dbConnect);
        }
        YOSAPI.setApiIntervaltime(apiid, apiversion, intervaltime);
        return getSucReturnObject().toString();
    }
}
