package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_usersitelog implements YosObject {
    @Override
    public String table_comment() {
        return "站点授权记录表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_usersitelogid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new BigIntCol("userid", "userid"));
        list.add(new VarcharCol("siteid", "siteid", 50));
        list.add(new DateTimeCol("begdate", "授权日期"));
        list.add(new DateTimeCol("enddate", "失效日期"));
        return list;
    }
}
