package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_userclientconfig implements YosObject {
    @Override
    public String table_comment() {
        return "客户端配置信息查询";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_userclientconfigid", "数据id");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new LongTextCol("config", "客户端配置信息"));
        list.add(new VarcharCol("systemclient", "操作端名称", 50));
        list.add(new BigIntCol("userid", "用户ID"));
        list.add(new VarcharCol("siteid", "站点ID", 50));
        return list;
    }
}
