package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_site implements YosObject {
    @Override
    public String table_comment() {
        return "企业站点表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("siteuid", "站点id");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new SmallIntCol("magsite", "管理站点", 0));
        list.add(new VarcharCol("createby", "创建人", 50));
        list.add(new DateTimeCol("createdate", "创建时间"));
        return list;
    }
}
