package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_datawarn implements YosObject {
    @Override
    public String table_comment() {
        return "数据预警";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new UniqueCol("sys_datawarnid", "数据预警ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new LongTextCol("sqlstr", "sql语句", "sql语句", true, false, "", 3));
        arrayList.add(new VarcharCol("title", "名称", "名称", 50, true, false, false, "", 2));
        arrayList.add(new VarcharCol("remarks", "说明", "说明", 500, true, false, false, "", 1));
        arrayList.add(new SmallIntCol("isused", "是否启用", "是否启用", false, false, false, 0, 4));
        arrayList.add(new IntCol("sequence", "排序"));
        return arrayList;
    }
}
