package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_datafunction implements YosObject {
    @Override
    public String table_comment() {
        return "系统函数注册表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_datafunctionid", "系统函数id");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("functionname", "函数名称", "函数名称", 50, false, true, false, "", 10));
        arrayList.add(new VarcharCol("type", "函数类型", "query、update", 50, false, false, false, "query", 20));
        arrayList.add(new LongTextCol("sqlstr", "sql语句"));
        arrayList.add(new VarcharCol("remarks", "备注说明", 500));
        arrayList.add(new DateTimeCol("createdate", "创建时间"));
        arrayList.add(new SmallIntCol("isused", "是否已被使用", 0));
        arrayList.add(new SmallIntCol("queryforpage", "查询是否支持分页", 0));
        arrayList.add(new JsonCol("params", "参数列表"));
        return arrayList;
    }
}
