package common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.db.DBConnect;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import common.data.db.initialization.DBInitialization;
import common.parameter.properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.reflections.Reflections;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InitServlet extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Logger logger = Logger.getLogger(InitServlet.class);

    @Override
    public void init(ServletConfig config) {
        /*
         * 加载log4j配置文件
         */
        PropertyConfigurator.configure(properties.getLog4jProperties());
        /*
         * 缓存数据库初始化
         */
        SQLiteInit();
        /*
        系统数据库初始化
         */
        DBInitialization.SchemaInit();
         /*
        接口初始化
         */
        YOSAPI.initialize();
        /*
        接口监控初始化
         */
        ApiMonitorInit();
        /*
        过期接口清理
         */
        ApiClean();
        try {
            /*
             * 启动自动任务
             */
            super.init();
            ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
            Class<?> clz = Class.forName("common.InitService");
            Constructor<?> cla = clz.getDeclaredConstructor();
            Object obj = cla.newInstance();
            service.scheduleWithFixedDelay((Runnable) obj, 5, 600, TimeUnit.SECONDS);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void SQLiteInit() {
        try {
            DBConnect dbConnect = new DBConnect();
            Rows sys_cacheobjectRows = dbConnect.runSqlQuery("select table_name from sys_cacheobject");
            RowsMap sys_cacheobjectcolsRowsMap = dbConnect.runSqlQuery("select table_name,column_name,column_type from sys_cacheobjectcols").toRowsMap("table_name");
            for (Row sys_cacheobjectRow : sys_cacheobjectRows) {
                String table_name = sys_cacheobjectRow.getString("table_name");
                Rows sys_cacheobjectcolsRows = sys_cacheobjectcolsRowsMap.get(table_name);
                if (!sys_cacheobjectcolsRows.isEmpty()) {
                    logger.info("创建缓存数据表：" + table_name);
                    SQLiteTable sqLiteTable = SQLiteTable.getTable(table_name);
                    if (sqLiteTable.dosNotExist()) {
                        for (Row sys_cacheobjectcolsRow : sys_cacheobjectcolsRows) {
                            String column_name = sys_cacheobjectcolsRow.getString("column_name").toLowerCase();
                            String column_type = sys_cacheobjectcolsRow.getString("column_type").toLowerCase();
                            switch (column_type) {
                                case "datetime": {
                                    sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.DATETIME);
                                    break;
                                }
                                case "date": {
                                    sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.DATE);
                                    break;
                                }
                                case "bigint": {
                                    sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.BIGINT);
                                    break;
                                }
                                case "int": {
                                    sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.INT);
                                    break;
                                }
                                case "varchar":
                                default: {
                                    sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.VARCHAR);
                                    break;
                                }
                            }
                        }
                        sqLiteTable.create();
                    }
                }
            }
        } catch (YosException e) {
            e.printStackTrace();
        }
    }

    private void ApiMonitorInit() {
        /**
         * 开始获取接口类及方法信息
         */
        ArrayList<String> SQLlist = new ArrayList<>();

        Reflections reflections = new Reflections("restcontroller");
        Set<Class<? extends Controller>> subTypes = reflections.getSubTypesOf(Controller.class);
        for (Class<? extends Controller> clazz : subTypes) {
            String classname = clazz.getName().replace("restcontroller.", "");
            String classtitle = "";//标题
            String classnotes = "";//描述
            boolean isapiclass = false;
            /**
             * 获取类信息
             */
            if (clazz.isAnnotationPresent(API.class)) {
                API classapi = clazz.getAnnotation(API.class);
                classtitle = classapi.title();
                classnotes = classapi.notes();
            }
            /**
             * 获取类的方法信息
             */
            Method[] methods = clazz.getDeclaredMethods();
            for (Method method : methods) {
                if (method.isAnnotationPresent(API.class)) {
                    boolean iscacheing = method.isAnnotationPresent(CACHEING.class);
                    int cacheinglife = iscacheing ? method.getAnnotation(CACHEING.class).life() : 0;
                    boolean iscacheingclean = method.isAnnotationPresent(CACHEING_CLEAN.class);

                    JSONArray cacheingcleanArray = new JSONArray();
                    if (iscacheingclean) {
                        CACHEING_CLEAN cacheing_clean = method.getAnnotation(CACHEING_CLEAN.class);
                        cm[] cms = cacheing_clean.cms();
                        for (cm cm : cms) {
                            String[] mds = cm.method();
                            for (String md : mds) {
                                try {
                                    Method m = cm.clazz().getMethod(md);
                                    if (m.isAnnotationPresent(API.class)) {
                                        API a = m.getAnnotation(API.class);
                                        JSONObject cacheingcleanObject = new JSONObject(true);
                                        cacheingcleanObject.put("classname", cm.clazz().getName().replace("restcontroller.", ""));
                                        cacheingcleanObject.put("method", m.getName());
                                        cacheingcleanObject.put("title", a.title());
                                        cacheingcleanObject.put("notes", a.notes());
                                        cacheingcleanArray.add(cacheingcleanObject);
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        Class[] apiversionclasses = cacheing_clean.apiversions();
                        for (Class apiversionclass : apiversionclasses) {
                            try {
                                YOSAPI yosapi = YOSAPI.getApi(apiversionclass);
                                if (yosapi != null) {
                                    Method m = yosapi.getMethod();
                                    API a = yosapi.getMethod().getAnnotation(API.class);
                                    JSONObject cacheingcleanObject = new JSONObject(true);
                                    cacheingcleanObject.put("classname", yosapi.getClazz().getName().replace("restcontroller.", ""));
                                    cacheingcleanObject.put("method", m.getName());
                                    cacheingcleanObject.put("title", a.title());
                                    cacheingcleanObject.put("notes", a.notes());
                                    cacheingcleanObject.put("id", yosapi.getId());
                                    cacheingcleanObject.put("version", yosapi.getVersion());
                                    cacheingcleanArray.add(cacheingcleanObject);
                                }
                            } catch (YosException e) {
                                e.printStackTrace();
                            }
                        }

                        Class[] apiClasses = cacheing_clean.apiClass();
                        for (Class apiClass : apiClasses) {
                            try {
                                Method[] methods1 = apiClass.getMethods();
                                for (Method method1 : methods1) {
                                    if (method1.isAnnotationPresent(API.class) && method1.isAnnotationPresent(CACHEING.class)) {
                                        YOSAPI yosapi = YOSAPI.getApi(method1.getAnnotation(API.class).apiversion());
                                        if (yosapi != null) {
                                            API a = yosapi.getMethod().getAnnotation(API.class);
                                            JSONObject cacheingcleanObject = new JSONObject(true);
                                            cacheingcleanObject.put("classname", yosapi.getClazz().getName().replace("restcontroller.", ""));
                                            cacheingcleanObject.put("method", method1.getName());
                                            cacheingcleanObject.put("title", a.title());
                                            cacheingcleanObject.put("notes", a.notes());
                                            cacheingcleanObject.put("id", yosapi.getId());
                                            cacheingcleanObject.put("version", yosapi.getVersion());
                                            cacheingcleanArray.add(cacheingcleanObject);
                                        }
                                    }
                                }
                            } catch (YosException e) {
                                e.printStackTrace();
                            }
                        }

                        String[] tablenames = cacheing_clean.tablename();
                        for (String tablename : tablenames) {
                            try {
                                DBConnect dbConnect = new DBConnect();
                                Rows rows = dbConnect.runSqlQuery("select distinct t2.apiid,t2.apiversion from sys_objectapps t1 inner join sys_apiapps t2 on t1.systemappid=t2.systemappid where t1.table_name='" + tablename + "'");
                                for (Row row : rows) {
                                    YOSAPI yosapi = YOSAPI.getApi(row.getLong("apiid"), row.getInteger("apiversion"));
                                    if (yosapi != null) {
                                        Method m = yosapi.getMethod();
                                        API a = yosapi.getMethod().getAnnotation(API.class);
                                        JSONObject cacheingcleanObject = new JSONObject(true);
                                        cacheingcleanObject.put("classname", yosapi.getClazz().getName().replace("restcontroller.", ""));
                                        cacheingcleanObject.put("method", m.getName());
                                        cacheingcleanObject.put("title", a.title());
                                        cacheingcleanObject.put("notes", a.notes());
                                        cacheingcleanObject.put("id", yosapi.getId());
                                        cacheingcleanObject.put("version", yosapi.getVersion());
                                        cacheingcleanArray.add(cacheingcleanObject);
                                    }
                                }
                            } catch (YosException e) {
                                e.printStackTrace();
                            }
                        }

                        String[] systemapps = cacheing_clean.systemapp();
                        for (String systemapp : systemapps) {
                            try {
                                DBConnect dbConnect = new DBConnect();
                                Rows rows = dbConnect.runSqlQuery("select distinct t2.apiid,t2.apiversion from sys_systemapp t1 inner join sys_apiapps t2 on t1.systemappid=t2.systemappid where t1.systemapp='" + systemapp + "'");
                                for (Row row : rows) {
                                    YOSAPI yosapi = YOSAPI.getApi(row.getLong("apiid"), row.getInteger("apiversion"));
                                    if (yosapi != null) {
                                        Method m = yosapi.getMethod();
                                        API a = yosapi.getMethod().getAnnotation(API.class);
                                        JSONObject cacheingcleanObject = new JSONObject(true);
                                        cacheingcleanObject.put("classname", yosapi.getClazz().getName().replace("restcontroller.", ""));
                                        cacheingcleanObject.put("method", m.getName());
                                        cacheingcleanObject.put("title", a.title());
                                        cacheingcleanObject.put("notes", a.notes());
                                        cacheingcleanObject.put("id", yosapi.getId());
                                        cacheingcleanObject.put("version", yosapi.getVersion());
                                        cacheingcleanArray.add(cacheingcleanObject);
                                    }
                                }
                            } catch (YosException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    API methdapi = method.getAnnotation(API.class);
                    Class apiversionClass = methdapi.apiversion();
                    String apiversion = apiversionClass.getName().toLowerCase();
                    int deprecated = methdapi.deprecated() ? 1 : 0;
                    if (apiversion.startsWith("restcontroller.r$id") && apiversion.contains("$v")) {
                        int version = Integer.parseInt(apiversionClass.getSimpleName().replace("v", ""));
                        long apiid = Long.parseLong(apiversion.replace("restcontroller.r$id", "").replace("$v" + version, ""));
                        SQLlist.add("insert into apimethod(classname,method,title,notes,cacheinglife,iscacheing,iscacheingclean,cleandatas,intervaltime,accesstoken,apiid,apiversion,deprecated) values ('" + classname + "','" + method.getName() + "','" + methdapi.title() + "','" + methdapi.notes() + "','" + cacheinglife + "','" + (iscacheing ? 1 : 0) + "','" + (iscacheingclean ? 1 : 0) + "','" + cacheingcleanArray.toJSONString() + "','" + methdapi.intervaltime() + "','" + (methdapi.accesstoken() ? "1" : "0") + "','" + apiid + "','" + version + "'," + deprecated + ");");
                    } else {
                        SQLlist.add("insert into apimethod(classname,method,title,notes,cacheinglife,iscacheing,iscacheingclean,cleandatas,intervaltime,accesstoken,apiid,apiversion,deprecated) values ('" + classname + "','" + method.getName() + "','" + methdapi.title() + "','" + methdapi.notes() + "','" + cacheinglife + "','" + (iscacheing ? 1 : 0) + "','" + (iscacheingclean ? 1 : 0) + "','" + cacheingcleanArray.toJSONString() + "','" + methdapi.intervaltime() + "','" + (methdapi.accesstoken() ? "1" : "0") + "','',''," + deprecated + ");");
                    }
                    isapiclass = true;
                }
            }
            if (isapiclass) {
                SQLlist.add("insert into apiclass(classname,title,notes) values ('" + classname + "','" + classtitle + "','" + classnotes + "' );");
            }
        }
        SQLiteMemory.runSqlUpdate(SQLlist);
    }

    public void ApiClean() {
        try {
            Rows apimethodRows = SQLiteMemory.runSqlQuery("select classname,method,apiid,apiversion from apimethod");
            ArrayList<String> methodpathList = new ArrayList<>();
            for (Row apimethodRow : apimethodRows) {
                methodpathList.add("restcontroller." + apimethodRow.getString("classname") + "." + apimethodRow.getString("method"));
            }
            ArrayList<String> apiidList = apimethodRows.toArrayList("apiid");

            ArrayList<String> sqlist = new ArrayList<>();
            DBConnect dbConnect = new DBConnect();

            Rows sys_listsortschemeRows = dbConnect.runSqlQuery("select * from sys_listsortscheme");
            for (Row sys_listsortschemeRow : sys_listsortschemeRows) {
                long sys_listsortschemeid = sys_listsortschemeRow.getLong("sys_listsortschemeid");
                String methodpath = sys_listsortschemeRow.getString("methodpath");
                String apiid = sys_listsortschemeRow.getString("apiid");
                String apiversion = sys_listsortschemeRow.getString("apiversion");

                if (!methodpathList.contains(methodpath) && !apiidList.contains(apiid)) {
                    sqlist.add("delete from sys_listsortscheme where sys_listsortschemeid=" + sys_listsortschemeid);
                }
            }

            Rows sys_apiappsRows = dbConnect.runSqlQuery("select * from sys_apiapps");
            for (Row sys_apiappsRow : sys_apiappsRows) {
                long sys_apiappsid = sys_apiappsRow.getLong("sys_apiappsid");
                String apiid = sys_apiappsRow.getString("apiid");

                if (!apiidList.contains(apiid)) {
                    sqlist.add("delete from sys_apiapps where sys_apiappsid=" + sys_apiappsid);
                }
            }

            Rows sys_apidocRows = dbConnect.runSqlQuery("select * from sys_apidoc");
            for (Row sys_apidocRow : sys_apidocRows) {
                long sys_apidocid = sys_apidocRow.getLong("sys_apidocid");
                String apiid = sys_apidocRow.getString("apiid");

                if (!apiidList.contains(apiid)) {
                    sqlist.add("delete from sys_apidoc where sys_apidocid=" + sys_apidocid);
                }
            }

            sqlist.add("delete from sys_listsortschememx where not exists (select *from sys_listsortscheme where sys_listsortscheme.sys_listsortschemeid=sys_listsortschememx.sys_listsortschemeid)");
            dbConnect.runSqlUpdate(sqlist);
        } catch (YosException e) {
            e.printStackTrace();
        }
    }
}
