/**
 *
 */
package common;

import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import org.apache.log4j.Logger;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/**
 * @author Administrator
 *
 */
public class InitService implements Runnable {
    private static boolean isfirstrun = true;
    static ScheduledExecutorService service;
    private static final Logger logger = Logger.getLogger(InitService.class);

    @Override
    public void run() {
        if (isfirstrun) {
            /**
             * 创建多线程自动任务，线程数为cpu核心数
             */
            service = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
            logger.info("启动自动任务");
            isfirstrun = false;
            String sql = "select classname,isused,remarks,lastruntime,type,count,time from sys_services";
            DBConnect dbConnect = new DBConnect();
            try {
                Rows rows = dbConnect.runSqlQuery(sql);
                for (Row row : rows) {
                    addService(row);
                }
            } catch (YosException e) {
                e.printStackTrace();
            }
        }
    }

    public static HashMap<String, ScheduledFuture<?>> scheduledFutureMap = new HashMap<>();

    public static void addService(Row row) {
        try {
            String classname = row.getString("classname");
            String remarks = row.getString("remarks");
            String type = row.getString("type");//second,minute,hour,day,month,year
            int count = row.getInteger("count") <= 0 ? 1 : row.getInteger("count");

            String isused = row.getString("isused");//是否启用
            if (scheduledFutureMap.containsKey(classname)) {
                ScheduledFuture<?> oldscheduledFuture = scheduledFutureMap.get(classname);
                oldscheduledFuture.cancel(false);
                logger.info("服务卸载：" + classname + ";" + remarks);
            }

            Class<?> clz = Class.forName("service." + classname);
            Constructor<?> cla = clz.getDeclaredConstructor();
            Object obj = cla.newInstance();
            logger.info("服务加载：" + classname + "," + type + "," + isused + ";" + remarks);

            ScheduledFuture<?> scheduledFuture = null;
            if (type.equalsIgnoreCase("second")) {
                scheduledFuture = service.scheduleWithFixedDelay((Runnable) obj, 10, count, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("minute")) {
                int delay = 60 - Calendar.getInstance().get(Calendar.SECOND);
                scheduledFuture = service.scheduleAtFixedRate((Runnable) obj, delay, count * 60L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("hour")) {
                String time = row.getString("time");
                if (time.equals("")) {
                    time = "00:00";
                }
                String[] times = time.split(":");
                int schedulesecond = Integer.parseInt(times[0]) * 60 + Integer.parseInt(times[1]);
                Calendar calendar = Calendar.getInstance();
                int syssecond = calendar.get(Calendar.MINUTE) * 60 + calendar.get(Calendar.SECOND);//当前系统时间

                int delay = schedulesecond - syssecond;
                delay = delay < 0 ? (delay + 60 * 60) : delay;
                scheduledFuture = service.scheduleAtFixedRate((Runnable) obj, delay, count * 60L * 60L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("day")) {
                String time = row.getString("time");
                if (time.equals("")) {
                    time = "00:00:00";
                }

                String[] times = time.split(":");
                int schedulesecond = Integer.parseInt(times[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2]);
                Calendar calendar = Calendar.getInstance();
                int syssecond = calendar.get(Calendar.HOUR_OF_DAY) * 60 * 60 + calendar.get(Calendar.MINUTE) * 60 + calendar.get(Calendar.SECOND);//当前系统时间

                int delay = schedulesecond - syssecond;
                delay = delay < 0 ? (delay + 60 * 60 * 24) : delay;
                scheduledFuture = service.scheduleAtFixedRate((Runnable) obj, delay, count * 60L * 60L * 24L, TimeUnit.SECONDS);
            }
            if (scheduledFuture != null) {
                scheduledFutureMap.put(classname, scheduledFuture);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
