package beans.parameter;

import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;

import java.util.HashMap;

public class Parameter {
    private static HashMap<String, Row> siteParameter = new HashMap<>();

    /**
     * 获取站点参数
     *
     * @param siteid
     * @param paramname
     * @return
     * @throws YosException
     */
    public static String get(String siteid, String paramname) throws YosException {
        if (!siteParameter.containsKey(siteid)) {
            Rows rows = new DBConnect().runSqlQuery("select * from sys_site_parameter where siteid='" + siteid + "'");
            if (rows.isEmpty()) {
                throw new YosException("找不到站点参数" + paramname);
            } else {
                siteParameter.put(siteid, rows.get(0));
            }
        }
        if (!siteParameter.get(siteid).containsKey(paramname)) {
            throw new YosException("找不到站点参数" + paramname);
        }
        return siteParameter.get(siteid).getString(paramname);
    }

    public static void cleanSiteParameter(String siteid) {
        siteParameter.remove(siteid);
    }

    public static HashMap<String, String> sysParameter = new HashMap<>();

    /**
     * 获取系统参数
     */
    public static String get(String paramname) throws YosException {
        if (!sysParameter.containsKey(paramname)) {
            Rows rows = new DBConnect().runSqlQuery("select paramvalue from sys_parameter where paramname='" + paramname + "'");
            if (rows.isEmpty()) {
                throw new YosException("找不到系统参数" + paramname);
            } else {
                sysParameter.put(paramname, rows.get(0).getString("paramvalue"));
            }
        }
        if (!sysParameter.containsKey(paramname)) {
            throw new YosException("找不到系统参数" + paramname);
        }
        return sysParameter.get(paramname);
    }

    /**
     * 清理系统参数
     *
     * @param paramname
     */
    public static void cleanSysParameter(String paramname) {
        sysParameter.remove(paramname);
    }

}
