package beans.department;

import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.ArrayList;

public class Department extends BaseClass {
    /**
     * 刷新部门全路径、全称、及层级
     */
    public static synchronized void RefreshDepartmentMsg(Controller controller) throws YosException {
        SQLFactory sqlFactory = new SQLFactory(new Department(), "部门层级信息创建");
        sqlFactory.addParameter("siteid", controller.siteid);
        controller.dbConnect.runSqlUpdate(sqlFactory.getSQL());
    }

    /**
     * 部门及成员关系创建
     *
     * @param controller
     */
    public static synchronized void CaculateDepartmentHr(Controller controller) throws YosException {
        SQLFactory sqlFactory = new SQLFactory(new Department(), "部门人员关系查询");
        sqlFactory.addParameter("siteid", controller.siteid);
        Rows rows = controller.dbConnect.runSqlQuery(sqlFactory.getSQL());
        ArrayList<String> sqlist = new ArrayList<>();
        sqlist.add("delete from sys_departmenthrid where siteid='" + controller.siteid + "'");
        long[] sys_departmenthridids = controller.createTableID("sys_departmenthrid", rows.size());
        for (int i = 0; i < rows.size(); i++) {
            Row row = rows.getRow(i);
            SQLFactory addsql = new SQLFactory(new Department(), "部门人员关系创建");
            addsql.addParameter("siteid", controller.siteid);
            addsql.addParameter("sys_departmenthridid", sys_departmenthridids[i]);
            addsql.addParameter("departmentid", row.getLong("departmentid"));
            addsql.addParameter("hrid", row.getLong("hrid"));
            sqlist.add(addsql.getSQL());
        }
        controller.dbConnect.runSqlUpdate(sqlist);
    }

    /**
     * 根据指定的部门id获取下级部门id
     *
     * @param controller
     * @param departmentid
     * @throws YosException
     */
    public static ArrayList<Long> getSubDepartmentIds(Controller controller, long departmentid) throws YosException {
        SQLFactory sqlFactory = new SQLFactory(new Department(), "下级部门id获取");
        sqlFactory.addParameter("siteid", controller.siteid);
        sqlFactory.addParameter("departmentid", departmentid);
        Rows rows = controller.dbConnect.runSqlQuery(sqlFactory.getSQL());
        return rows.toArrayList("departmentid", new ArrayList<>());
    }

    /**
     * 获取指定部门的部门负责人账号id
     *
     * @param controller
     * @param departmentid
     * @return
     * @throws YosException
     */
    public static ArrayList<Long> getLeaderUserids(Controller controller, long departmentid) throws YosException {
        return controller.dbConnect.runSqlQuery("select userid from sys_hr where siteid='" + controller.siteid + "' and departmentid=" + departmentid + " and isleader=1 ").toArrayList("userid", new ArrayList<>());
    }

    public static ArrayList<Long> getLeaderUserids(Controller controller) throws YosException {
        return getLeaderUserids(controller, controller.departmentid);
    }
}
