with recursive department as (
    select departmentid, depno, depname, 1 as level
    from sys_department
    where parentid is null
      and siteid = $siteid$
    union all
    select t2.departmentid,
           CONCAT(ifnull(t1.depno, ''), '/', ifnull(t2.depno, '')),
           CONCAT(ifnull(t1.depname, ''), '/', ifnull(t2.depname, '')),
           t1.level + 1
    from department t1
             inner join sys_department t2 on t1.departmentid = t2.parentid and t2.siteid = $siteid$
)
update sys_department t1
    inner join department t2
on t1.departmentid=t2.departmentid
    set t1.depfullname=t2.depname, t1.depfullno=t2.depno, t1.level=t2.level
where t1.siteid=$siteid$
