/*
 * Decompiled with CFR 0.152.
 */
package utility.mysql;

import beans.parameter.Parameter;
import common.data.db.DBConnectPool;
import common.parameter.properties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class MysqlExport {
    private Statement stmt;
    private String database = this.getDBname();
    private String tablename = "";

    public MysqlExport() {
    }

    public MysqlExport(String tablename) {
        this.tablename = tablename;
    }

    public boolean export() {
        try {
            if (Parameter.get("system_db_backupswitch").equalsIgnoreCase("true") || Parameter.get("system_db_backupswitch").equalsIgnoreCase("1")) {
                DBConnectPool dbConnectPool = new DBConnectPool();
                Connection connection = dbConnectPool.getConnect("default");
                this.stmt = connection.createStatement(1004, 1007);
                String path = Parameter.get("system_db_backuppath");
                File file = new File(path);
                if (!file.exists() && !file.mkdir()) {
                    throw new IOException("\u521b\u5efa\u5907\u4efd\u6587\u4ef6\u8def\u5f84\u5931\u8d25 " + file.getAbsolutePath());
                }
                FileOutputStream outputStream = new FileOutputStream(path + "/" + this.getSqlFilename());
                outputStream.write(this.exportToSql().getBytes());
                outputStream.close();
                dbConnectPool.close("default", connection);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String exportToSql() throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("--");
        sql.append("\n-- Generated by workbgm");
        sql.append("\n-- Date: ").append(new SimpleDateFormat("d-M-Y H:m:s").format(new Date()));
        sql.append("\n--");
        sql.append("\n\n/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;").append("\n/*!40101 SET NAMES utf8 */;").append("\n/*!50503 SET NAMES utf8mb4 */;").append("\n/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;").append("\n/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;");
        List<String> tables = this.getAllTables(this.database, this.stmt);
        for (String table : tables) {
            try {
                table = table.trim();
                sql.append(this.getTableInsertStatement(table));
                sql.append(this.getDataInsertStatement(table));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        sql.append("\n/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;").append("\n/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;").append("\n/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;");
        return sql.toString();
    }

    private String getTableInsertStatement(String table) throws SQLException {
        StringBuilder sql = new StringBuilder();
        boolean addIfNotExists = true;
        if (table != null && !table.isEmpty()) {
            ResultSet rs = this.stmt.executeQuery("SHOW CREATE TABLE `" + table + "`;");
            while (rs.next()) {
                String tablename = rs.getString(1);
                String createtablesql = rs.getString(2);
                sql.append("\n\n--");
                sql.append("\n").append("-- start").append("  table dump : ").append(tablename);
                sql.append("\n--\n\n");
                if (addIfNotExists) {
                    createtablesql = createtablesql.trim().replace("CREATE TABLE", "CREATE TABLE IF NOT EXISTS");
                }
                sql.append(createtablesql).append(";\n\n");
            }
            sql.append("\n\n--");
            sql.append("\n").append("-- end").append("  table dump : ").append(table);
            sql.append("\n--\n\n");
        }
        return sql.toString();
    }

    private String getDataInsertStatement(String table) throws SQLException {
        int i;
        StringBuilder sql = new StringBuilder();
        ResultSet rs = this.stmt.executeQuery("SELECT * FROM `" + table + "`;");
        rs.last();
        int rowCount = rs.getRow();
        if (rowCount <= 0) {
            return sql.toString();
        }
        sql.append("\n--").append("\n-- Inserts of ").append(table).append("\n--\n\n");
        sql.append("\n/*!40000 ALTER TABLE `").append(table).append("` DISABLE KEYS */;\n");
        sql.append("\n--\n").append("-- start").append(" table insert : ").append(table).append("\n--\n");
        sql.append("INSERT INTO `").append(table).append("`(");
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (i = 0; i < columnCount; ++i) {
            sql.append("`").append(metaData.getColumnName(i + 1)).append("`, ");
        }
        sql.deleteCharAt(sql.length() - 1).deleteCharAt(sql.length() - 1).append(") VALUES \n");
        rs.beforeFirst();
        while (rs.next()) {
            sql.append("(");
            for (i = 0; i < columnCount; ++i) {
                int columnType = metaData.getColumnType(i + 1);
                int columnIndex = i + 1;
                if (Objects.isNull(rs.getObject(columnIndex))) {
                    sql.append(rs.getObject(columnIndex)).append(", ");
                    continue;
                }
                if (columnType == 4 || columnType == -6 || columnType == -7) {
                    sql.append(rs.getInt(columnIndex)).append(", ");
                    continue;
                }
                String val = rs.getString(columnIndex);
                val = val.replace("'", "\\'");
                sql.append("'").append(val).append("', ");
            }
            sql.deleteCharAt(sql.length() - 1).deleteCharAt(sql.length() - 1);
            if (rs.isLast()) {
                sql.append(")");
                continue;
            }
            sql.append("),\n");
        }
        sql.append(";");
        sql.append("\n--\n").append("-- end").append(" table insert : ").append(table).append("\n--\n");
        sql.append("\n/*!40000 ALTER TABLE `").append(table).append("` ENABLE KEYS */;\n");
        return sql.toString();
    }

    public String getSqlFilename() {
        if (this.tablename.equals("")) {
            return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "_" + this.database + "_dump.sql";
        }
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "_" + this.database + "." + this.tablename + "_dump.sql";
    }

    private List<String> getAllTables(String database2, Statement stmt) throws SQLException {
        ArrayList<String> table = new ArrayList<String>();
        ResultSet rs = this.tablename.equals("") ? stmt.executeQuery("SHOW TABLE STATUS FROM `" + database2 + "`;") : stmt.executeQuery("SHOW TABLE STATUS FROM `" + database2 + "` where Name='" + this.tablename + "';");
        while (rs.next()) {
            table.add(rs.getString("Name"));
        }
        return table;
    }

    private String getDBname() {
        String url = properties.getYosProperties().getProperty("system.db.url");
        String[] urlsplit = url.split("/");
        return urlsplit[urlsplit.length - 1];
    }
}

