/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.system.attachment;

import beans.datacontrllog.DataContrlLog;
import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import java.util.ArrayList;
import utility.huawei.obs.BucketFile;

@API(title="\u5a92\u4f53\u4e2d\u5fc3\u7ba1\u7406")
public class MediaCenter
extends Controller {
    public MediaCenter(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u5a92\u4f53\u5217\u8868\u67e5\u8be2")
    public String queryAttachment() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (this.content.containsKey("where")) {
            JSONObject whereObject = this.content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append(" t1.document like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("parentid") && !"".equals(whereObject.getString("parentid"))) {
                where.append(" and(");
                where.append(" ifnull(t1.parentid,0) ='").append(whereObject.getString("parentid")).append("'");
                where.append(")");
            }
            if (whereObject.containsKey("attachmentid") && !"".equals(whereObject.getString("attachmentid"))) {
                where.append(" and(");
                where.append(" t1.attachmentid ='").append(whereObject.getString("attachmentid")).append("'");
                where.append(")");
            }
            if (whereObject.containsKey("isonlyfolder") && "1".equals(whereObject.getString("isonlyfolder"))) {
                where.append(" and(");
                where.append(" t1.isfolder ='1'");
                where.append(")");
            }
            if (whereObject.containsKey("isonlycollect") && "1".equals(whereObject.getString("isonlycollect"))) {
                where.append(" and(");
                if (whereObject.containsKey("collecttype") && !"".equals(whereObject.getString("collecttype"))) {
                    where.append(" exists(select*from sys_attachment_collect where siteid=t1.siteid and attachmentid=t1.attachmentid and type='" + whereObject.getString("collecttype") + "' and userid='" + this.userid + "')");
                } else {
                    where.append(" exists(select*from sys_attachment_collect where siteid=t1.siteid and attachmentid=t1.attachmentid and userid='" + this.userid + "')");
                }
                where.append(")");
            }
            if (whereObject.containsKey("postfixs") && !whereObject.getJSONArray("postfixs").isEmpty()) {
                JSONArray postfixsarray = whereObject.getJSONArray("postfixs");
                StringBuffer postfix_in = new StringBuffer();
                for (Object o : postfixsarray) {
                    String postfix = ((String)o).replace(".", "");
                    if (postfix_in.toString().equals("")) {
                        postfix_in.append("'" + postfix + "'");
                        continue;
                    }
                    postfix_in.append(",'" + postfix + "'");
                }
                where.append(" and (postfix in (" + postfix_in + ") or isfolder=1 )");
            }
        }
        SQLFactory sqlFactory = new SQLFactory((Object)this, "\u5a92\u4f53\u5217\u8868\u67e5\u8be2", this.pageSize, this.pageNumber, this.pageSorting);
        sqlFactory.addParameter("siteid", (Object)this.siteid);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = this.dbConnect.runSqlQuery(sqlFactory);
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="\u521b\u5efa\u5a92\u4f53\u6587\u4ef6\u5939")
    public String createFolder() throws YosException {
        String foldername = this.content.getString("foldername");
        long parentid = this.content.getLongValue("parentid");
        long attachmentid = this.createTableID("sys_attachment");
        SQLFactory sqlFactory = new SQLFactory((Object)this, "\u5a92\u4f53\u6587\u4ef6\u5939\u63d2\u5165");
        sqlFactory.addParameter("attachmentid", (Object)attachmentid);
        sqlFactory.addParameter("siteid", (Object)this.siteid);
        sqlFactory.addParameter("createby", (Object)this.username);
        sqlFactory.addParameter("document", (Object)foldername);
        sqlFactory.addParameter("parentid", (Object)(parentid > 0L ? String.valueOf(parentid) : "null"));
        this.dbConnect.runSqlUpdate(sqlFactory);
        return this.getSucReturnObject().setData(this.getAttachmentUrl(attachmentid).get(0)).toString();
    }

    @API(title="\u6279\u91cf\u4fee\u6539\u5a92\u4f53\u57fa\u672c\u4fe1\u606f")
    public String changeAttachment() throws YosException {
        JSONArray files = this.content.getJSONArray("files");
        ArrayList<String> sqllist = new ArrayList<String>();
        ArrayList<Long> attachmentidlist = new ArrayList<Long>();
        for (Object o : files) {
            JSONObject file = (JSONObject)o;
            long attachmentid = file.getLong("attachmentid");
            String document = file.getString("document");
            String parentid = file.getString("parentid");
            SQLFactory sql = new SQLFactory((Object)this, "\u5a92\u4f53\u4fe1\u606f\u8c03\u6574");
            sql.addParameter("siteid", (Object)this.siteid);
            sql.addParameter("attachmentid", (Object)attachmentid);
            sql.addParameter("document", (Object)document);
            sql.addParameter("parentid", (Object)parentid);
            sqllist.add(sql.getSQL());
            attachmentidlist.add(attachmentid);
            Rows rows = this.dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.siteid='" + this.siteid + "' and t1.attachmentid=" + attachmentid);
            for (Row row : rows) {
                SQLFactory logsql = DataContrlLog.createLog(this, row.getString("ownertable"), row.getLong("ownerid"), "\u7f16\u8f91\u9644\u4ef6", "\u9644\u4ef6\u3010" + row.getString("document") + "\u3011 \u540d\u79f0\u8c03\u6574\u4e3a \u3010" + document + "\u3011");
                sqllist.add(logsql.getSQL());
            }
        }
        this.dbConnect.runSqlUpdate(sqllist);
        return this.getSucReturnObject().setData(this.getAttachmentUrl(attachmentidlist)).toString();
    }

    @API(title="\u5a92\u4f53\u5220\u9664")
    public String deleteAttachment() throws YosException {
        long attachmentid = this.content.getLongValue("attachmentid");
        if (this.dbConnect.runSqlQuery("select *from sys_site_parameter where appfolderid='" + attachmentid + "' or salematerialfolderid='" + attachmentid + "'").isNotEmpty()) {
            return this.getErrReturnObject().setErrMsg("\u7cfb\u7edf\u6587\u4ef6\u5939\u4e0d\u53ef\u5220\u9664").toString();
        }
        SQLFactory sqlFactory = new SQLFactory((Object)this, "\u5b50\u5a92\u4f53ID\u67e5\u8be2");
        sqlFactory.addParameter("attachmentid", (Object)attachmentid);
        Rows rows = this.dbConnect.runSqlQuery(sqlFactory.getSQL());
        ArrayList<String> sqlist = new ArrayList<String>();
        for (Row row : rows) {
            String objectname = row.getString("serialnumber");
            String type = row.getString("type");
            switch (Parameter.get("system_attachment_type")) {
                case "huaweiobs": {
                    try {
                        BucketFile bucketFile = new BucketFile(this.siteid);
                        if ("hls".equals(type)) {
                            bucketFile.deleteFolder(objectname);
                        } else {
                            bucketFile.deleteFile(objectname);
                        }
                        bucketFile.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "localhost": {
                    break;
                }
            }
            SQLFactory delete = new SQLFactory((Object)this, "\u5a92\u4f53\u5220\u9664");
            delete.addParameter("siteid", (Object)this.siteid);
            delete.addParameter("attachmentid", (Object)row.getString("attachmentid"));
            sqlist.add(delete.getSQL());
            SQLFactory delete2 = new SQLFactory((Object)this, "\u5a92\u4f53\u6570\u636e\u5173\u8054\u4fe1\u606f\u5220\u9664");
            delete2.addParameter("siteid", (Object)this.siteid);
            delete2.addParameter("attachmentid", (Object)row.getString("attachmentid"));
            sqlist.add(delete2.getSQL());
            Rows attrows = this.dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.siteid='" + this.siteid + "' and t1.attachmentid=" + row.getString("attachmentid"));
            for (Row attrow : attrows) {
                sqlist.add(DataContrlLog.createLog(this, attrow.getString("ownertable"), attrow.getLong("ownerid"), "\u5220\u9664\u9644\u4ef6", "\u5220\u9664\u9644\u4ef6" + attrow.getString("document")).getSQL());
            }
        }
        this.dbConnect.runSqlUpdate(sqlist);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u6279\u91cf\u5a92\u4f53\u5220\u9664")
    public String deleteAttachments() throws YosException {
        JSONArray attachmentids = this.content.getJSONArray("attachmentids");
        ArrayList<String> sqlist = new ArrayList<String>();
        for (Object object : attachmentids) {
            long attachmentid = Long.parseLong(String.valueOf(object));
            if (this.dbConnect.runSqlQuery("select *from sys_site_parameter where appfolderid='" + attachmentid + "' or salematerialfolderid='" + attachmentid + "'").isNotEmpty()) continue;
            SQLFactory sqlFactory = new SQLFactory((Object)this, "\u5b50\u5a92\u4f53ID\u67e5\u8be2");
            sqlFactory.addParameter("attachmentid", (Object)attachmentid);
            Rows rows = this.dbConnect.runSqlQuery(sqlFactory.getSQL());
            for (Row row : rows) {
                String objectname = row.getString("serialnumber");
                String type = row.getString("type");
                switch (Parameter.get("system_attachment_type")) {
                    case "huaweiobs": {
                        try {
                            BucketFile bucketFile = new BucketFile(this.siteid);
                            if ("hls".equals(type)) {
                                bucketFile.deleteFolder(objectname);
                            } else {
                                bucketFile.deleteFile(objectname);
                            }
                            bucketFile.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "localhost": {
                        break;
                    }
                }
                SQLFactory delete = new SQLFactory((Object)this, "\u5a92\u4f53\u5220\u9664");
                delete.addParameter("siteid", (Object)this.siteid);
                delete.addParameter("attachmentid", (Object)row.getString("attachmentid"));
                sqlist.add(delete.getSQL());
                SQLFactory delete2 = new SQLFactory((Object)this, "\u5a92\u4f53\u6570\u636e\u5173\u8054\u4fe1\u606f\u5220\u9664");
                delete2.addParameter("siteid", (Object)this.siteid);
                delete2.addParameter("attachmentid", (Object)row.getString("attachmentid"));
                sqlist.add(delete2.getSQL());
                Rows attrows = this.dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.siteid='" + this.siteid + "' and t1.attachmentid=" + row.getString("attachmentid"));
                for (Row attrow : attrows) {
                    sqlist.add(DataContrlLog.createLog(this, attrow.getString("ownertable"), attrow.getLong("ownerid"), "\u5220\u9664\u9644\u4ef6", "\u5220\u9664\u9644\u4ef6" + attrow.getString("document")).getSQL());
                }
            }
        }
        this.dbConnect.runSqlUpdate(sqlist);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5a92\u4f53\u8d44\u6e90\u6536\u85cf")
    public String collectAttachment() throws YosException {
        String collecttype = this.content.getString("collecttype");
        long attachmentid = this.content.getLongValue("attachmentid");
        SQLFactory sqlFactory = new SQLFactory((Object)this, "\u5a92\u4f53\u6570\u636e\u6536\u85cf");
        sqlFactory.addParameter("sys_attachment_collectid", (Object)this.createTableID("sys_attachment_collect"));
        sqlFactory.addParameter("attachmentid", (Object)attachmentid);
        sqlFactory.addParameter("linksid", (Object)"null");
        sqlFactory.addParameter("userid", (Object)this.userid);
        sqlFactory.addParameter("siteid", (Object)this.siteid);
        sqlFactory.addParameter("type", (Object)collecttype);
        this.dbConnect.runSqlUpdate(sqlFactory);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5a92\u4f53\u8d44\u6e90\u53d6\u6d88\u6536\u85cf")
    public String uncollectAttachment() throws YosException {
        long attachmentid = this.content.getLongValue("attachmentid");
        this.dbConnect.runSqlUpdate("delete from sys_attachment_collect where attachmentid=" + attachmentid);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5a92\u4f53\u6570\u636e\u7ed1\u5b9a\u60c5\u51b5\u67e5\u8be2")
    @CACHEING
    public String queryAttachment_LinkData() throws YosException {
        long attachmentid = this.content.getLongValue("attachmentid");
        Rows linkrows = this.dbConnect.runSqlQuery("select linksid,ownertable,ownerid,usetype,createdate,createby from sys_attachment_links where siteid='" + this.siteid + "' and attachmentid='" + attachmentid + "'");
        RowsMap linkrowsMap = linkrows.toRowsMap("ownertable");
        for (String ownertable : linkrowsMap.keySet()) {
            String uniquecolumnname = this.getuniquecolumnname(ownertable);
            Rows table_linkrows = linkrowsMap.get((Object)ownertable);
            ArrayList owneridlist = table_linkrows.toArrayList("ownerid");
            String appname = "";
            String datafield = "";
            switch (ownertable) {
                case "sys_site": {
                    appname = "\u7ad9\u70b9";
                    datafield = "sitename";
                    break;
                }
                case "sys_users": {
                    appname = "\u7528\u6237";
                    datafield = "name";
                    break;
                }
                case "sat_sharematerial": {
                    appname = "\u63a8\u5e7f\u7d20\u6750";
                    datafield = "title";
                    break;
                }
                case "sat_courseware": {
                    appname = "\u5546\u5b66\u9662";
                    datafield = "title";
                    break;
                }
                case "sat_notice": {
                    appname = "\u901a\u544a";
                    datafield = "title";
                    break;
                }
                case "sa_agents": {
                    appname = "\u5546\u6237";
                    datafield = "agentname";
                    break;
                }
                case "sat_submitedit": {
                    appname = "\u63d0\u62a5";
                    datafield = "concat(agentnum,';',agentname,';',agenttype)";
                    break;
                }
                case "sat_submiteditmodel": {
                    appname = "\u63d0\u62a5\u6a21\u7248";
                    datafield = "title";
                    break;
                }
                default: {
                    appname = this.getTableName(ownertable);
                    datafield = "''";
                }
            }
            SQLFactory sqlFactory = new SQLFactory("sql:select " + uniquecolumnname + "," + datafield + " as datafield from " + ownertable + " where " + uniquecolumnname + " in $" + uniquecolumnname + "$");
            sqlFactory.addParameter_in(uniquecolumnname, owneridlist);
            RowsMap rowsmap = this.dbConnect.runSqlQuery(sqlFactory.getSQL()).toRowsMap(uniquecolumnname);
            for (Row table_linkrow : table_linkrows) {
                JSONObject dataobject = new JSONObject();
                dataobject.put("appname", (Object)appname);
                if (rowsmap.get((Object)table_linkrow.getString("ownerid")).isEmpty()) {
                    dataobject.put("appdata", (Object)"");
                } else {
                    dataobject.put("appdata", (Object)rowsmap.get((Object)table_linkrow.getString("ownerid")).get(0).getString("datafield"));
                }
                table_linkrow.put((Object)"data", (Object)dataobject);
            }
        }
        return this.getSucReturnObject().setData(linkrows).toString();
    }
}

