/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import common.BaseClass;
import common.YosException;
import common.data.Rows;
import common.data.db.DBConnect;
import java.util.ArrayList;
import java.util.Arrays;

public class YTable
extends BaseClass {
    private String table_name;
    private ArrayList<String> column_names = new ArrayList();
    private String column_names_str;

    private YTable(String table_name, String ... column_names) throws YosException {
        this.table_name = table_name;
        this.column_names.add(this.getuniquecolumnname(table_name));
        this.column_names.addAll(Arrays.asList(column_names));
        this.column_names_str = this.arrayToString(this.column_names);
    }

    private YTable(String databasekey, String table_name, String ... column_names) throws YosException {
        this.dbConnect = new DBConnect(databasekey);
        this.table_name = table_name;
        this.column_names.addAll(Arrays.asList(column_names));
        this.column_names_str = this.arrayToString(this.column_names);
    }

    public static YTable getTable(String table_name, String ... column_names) throws YosException {
        return new YTable(table_name, column_names);
    }

    public Rows getRows() throws YosException {
        return this.dbConnect.runSqlQuery("select " + this.column_names_str + " from " + this.table_name);
    }

    public static void main(String[] args) throws YosException {
        YTable table = YTable.getTable("sys_users", "name", "phonenumber", "userid", "accountno");
        System.err.println(table.getRows().toJsonArray());
    }

    private String arrayToString(ArrayList<String> column_names) {
        StringBuffer str = new StringBuffer();
        for (String column_name : column_names) {
            if (!str.toString().equals("")) {
                str.append(",");
            }
            str.append(column_name);
        }
        return str.toString();
    }
}

