/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class InitService
implements Runnable {
    private static boolean isfirstrun = true;
    static ScheduledExecutorService service;
    private static final Logger logger;
    public static HashMap<String, ScheduledFuture<?>> scheduledFutureMap;

    @Override
    public void run() {
        if (isfirstrun) {
            service = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
            logger.info((Object)"\u542f\u52a8\u81ea\u52a8\u4efb\u52a1");
            isfirstrun = false;
            String sql = "select classname,intervaltime,isused,remarks,lastruntime from sys_services";
            DBConnect dbConnect = new DBConnect();
            try {
                Rows rows = dbConnect.runSqlQuery(sql);
                int initialDelay = 5;
                for (Row row : rows) {
                    InitService.addService(row, initialDelay);
                    initialDelay += 5;
                }
            }
            catch (YosException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addService(Row row, int initialDelay) {
        try {
            String classname = row.getString("classname");
            String remarks = row.getString("remarks");
            if (scheduledFutureMap.containsKey(classname)) {
                ScheduledFuture<?> oldscheduledFuture = scheduledFutureMap.get(classname);
                oldscheduledFuture.cancel(false);
                logger.info((Object)("\u670d\u52a1\u5378\u8f7d\uff1a" + classname + ";" + remarks));
            }
            long delay = row.getLong("intervaltime");
            String isused = row.getString("isused");
            logger.info((Object)("\u670d\u52a1\u52a0\u8f7d\uff1a" + classname + "," + delay + "," + isused + ";" + remarks));
            Class<?> clz = Class.forName("service." + classname);
            Constructor<?> cla = clz.getDeclaredConstructor(new Class[0]);
            Object obj = cla.newInstance(new Object[0]);
            ScheduledFuture<?> scheduledFuture = service.scheduleWithFixedDelay((Runnable)obj, initialDelay, delay, TimeUnit.SECONDS);
            scheduledFutureMap.put(classname, scheduledFuture);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        logger = Logger.getLogger(InitService.class);
        scheduledFutureMap = new HashMap();
    }
}

