/*
 * Decompiled with CFR 0.152.
 */
package common;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.ReturnObject;
import common.ReturnObject_Err;
import common.ReturnObject_Suc;
import common.ReturnObject_Warn;
import common.Sorting;
import common.YosException;
import common.api.YOSAPI;
import common.data.ExcelFactory;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.DataPool;
import common.parameter.parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import utility.huawei.obs.BucketFile;
import utility.tools.Encryption;

public class Controller
extends BaseClass {
    public JSONObject content;
    private ReturnObject returnObject;
    public String systemclient = "";
    public int pageNumber = 1;
    public int pageSize = 20;
    public int rowindex = 0;
    public long userid = 0L;
    public long usersiteid = 0L;
    public int usertype = 0;
    public String username = "";
    public String siteid = "";
    public String phonenumber = "";
    public long departmentid = 0L;
    public long hrid = 0L;
    public long sa_agentsid = 0L;
    public long sys_enterpriseid = 0L;
    public boolean isleader = false;
    public String pageSorting;
    public JSONArray pageSortingArray;
    private JSONObject tablefilter = new JSONObject();
    public List<FileItem> requestFileItemList;
    private YOSAPI requestAPI;
    private YOSAPI.YosRequest request;
    private String accesstoken = "";
    private static HashMap<Long, String> headPicMap = new HashMap();
    private static HashMap<Long, ArrayList<Long>> imdialog_usermap = new HashMap();
    public static HashMap<String, Rows> systemModuleIconUrlMap = new HashMap();

    public Controller(JSONObject content) throws YosException {
        this.content = content;
        this.returnObject = new ReturnObject(this);
        if (this.content.containsKey("pageNumber")) {
            this.pageNumber = this.content.getIntValue("pageNumber");
        }
        if (this.content.containsKey("pageSize")) {
            this.pageSize = this.content.getIntValue("pageSize");
        }
        if (this.content.containsKey("rowindex")) {
            this.rowindex = this.content.getIntValue("rowindex");
        }
        if (this.content.containsKey("accesstoken")) {
            this.accesstoken = this.content.getString("accesstoken");
            if (parameter.tokenlist.containsKey(this.accesstoken)) {
                this.usersiteid = parameter.tokenlist.get(this.accesstoken);
            }
        }
        if (this.content.containsKey("where") && this.content.getJSONObject("where").containsKey("tablefilter")) {
            this.tablefilter = this.content.getJSONObject("where").getJSONObject("tablefilter");
        }
        if (parameter.usersiteIdList.containsKey(this.usersiteid)) {
            Row row = parameter.usersiteIdList.get(this.usersiteid);
            this.userid = row.getLong("userid");
            this.siteid = row.getString("siteid");
            this.username = row.getString("name");
            this.phonenumber = row.getString("phonenumber");
            this.systemclient = row.getString("systemclient");
            this.departmentid = row.getLong("departmentid");
            this.usertype = row.getInteger("usertype");
            this.hrid = row.getLong("hrid");
            if (row.containsKey((Object)"sys_enterpriseid")) {
                this.sys_enterpriseid = row.getLong("sys_enterpriseid");
            } else {
                Row enterpriseRow = this.getEnterpriseByUserid(this.userid);
                this.sys_enterpriseid = enterpriseRow.getLong("sys_enterpriseid");
                row.put((Object)"sys_enterpriseid", (Object)this.sys_enterpriseid);
                parameter.usersiteIdList.put(this.usersiteid, row);
            }
            if (row.containsKey((Object)"sa_agentsid")) {
                this.sa_agentsid = row.getLong("sa_agentsid");
            } else {
                Row agentRow = this.getAgentByUserid(this.userid);
                this.sa_agentsid = agentRow.getLong("sa_agentsid");
                row.put((Object)"sa_agentsid", (Object)this.sa_agentsid);
                parameter.usersiteIdList.put(this.usersiteid, row);
            }
            if (row.containsKey((Object)"isleader")) {
                this.isleader = row.getBoolean("isleader");
            } else {
                this.isleader = this.getHr(this.userid).getBoolean("isleader") != false || this.getEnterpriseHr(this.userid).getBoolean("isleader") != false;
                row.put((Object)"isleader", (Object)this.isleader);
                parameter.usersiteIdList.put(this.usersiteid, row);
            }
        }
        if (this.siteid == null || this.siteid.equals("") || content.containsKey("siteid")) {
            this.siteid = (String)content.getOrDefault("siteid", "");
        }
    }

    public String getTableFilter(String table_alias, String fieldname, boolean exact) throws YosException {
        if (this.tablefilter.containsKey(fieldname) && !this.tablefilter.getString(fieldname).equals("")) {
            if (exact) {
                return " and " + table_alias + "." + fieldname + "='" + this.tablefilter.getString(fieldname) + "'";
            }
            return " and " + table_alias + "." + fieldname + " like'%" + this.tablefilter.getString(fieldname) + "%'";
        }
        return "";
    }

    public String getTableFilter(String table_alias, String fieldname, String field_alias, boolean exact) throws YosException {
        if (this.tablefilter.containsKey(field_alias) && !this.tablefilter.getString(field_alias).equals("")) {
            if (exact) {
                return " and " + table_alias + "." + fieldname + "='" + this.tablefilter.getString(field_alias) + "'";
            }
            return " and " + table_alias + "." + fieldname + " like'%" + this.tablefilter.getString(field_alias) + "%'";
        }
        return "";
    }

    public void setYosapi(YOSAPI requestAPI, YOSAPI.YosRequest request) {
        this.requestAPI = requestAPI;
        this.request = request;
    }

    public String getAccesstoken() {
        return this.accesstoken;
    }

    public void setSorting() throws YosException {
        Sorting sorting = new Sorting(this, this.requestAPI);
        this.pageSorting = sorting.getOrderBy();
        this.pageSortingArray = sorting.getSorts();
    }

    public void setrequestFileItemList(List<FileItem> requestFileItemList) {
        this.requestFileItemList = requestFileItemList;
    }

    public ExcelFactory getPostExcelFactory() throws IOException {
        for (FileItem item : this.requestFileItemList) {
            if (item.isFormField()) continue;
            String filename = new String(item.getName().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            filename = filename.substring(0, filename.lastIndexOf("."));
            return new ExcelFactory(filename, item.getInputStream());
        }
        return null;
    }

    public ExcelFactory getPostExcelFactory(String obsObjectname) throws IOException, YosException {
        BucketFile bucketFile = new BucketFile(this.siteid);
        return new ExcelFactory(bucketFile.getObjectInputStream(obsObjectname));
    }

    public ExcelFactory getPostExcelFactory(Long attachmentid) throws IOException, YosException {
        Rows rows = this.dbConnect.runSqlQuery("select serialnumber from sys_attachment where siteid='" + this.siteid + "' and attachmentid=" + attachmentid);
        if (rows.isNotEmpty()) {
            return this.getPostExcelFactory(rows.get(0).getString("serialnumber"));
        }
        return null;
    }

    public InputStream getPostFileInputStream(String obsObjectname) throws YosException {
        BucketFile bucketFile = new BucketFile(this.siteid);
        return bucketFile.getObjectInputStream(obsObjectname);
    }

    public InputStream getPostFileInputStream(Long attachmentid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select serialnumber from sys_attachment where siteid='" + this.siteid + "' and attachmentid=" + attachmentid);
        if (rows.isNotEmpty()) {
            return this.getPostFileInputStream(rows.get(0).getString("serialnumber"));
        }
        return null;
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows);
        return this.uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, Integer[] columnwidths) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, columnwidths);
        return this.uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, HashMap<String, String> titlemap) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, titlemap);
        return this.uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, HashMap<String, String> titlemap, Integer[] columnwidths) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, titlemap, columnwidths);
        return this.uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(ExcelFactory excelFactory) throws YosException {
        if (!excelFactory.isWrite.booleanValue()) {
            try {
                excelFactory.write();
            }
            catch (Exception e) {
                throw new YosException("excel\u5199\u5165\u9519\u8bef");
            }
        }
        return this.uploadFileToObs(excelFactory.getFile());
    }

    public Rows uploadFileToObs(File file) throws YosException {
        String document = file.getName();
        String postfix = "";
        try {
            postfix = document.substring(document.lastIndexOf("."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String serialnumber = this.createMD5FileName() + postfix;
        BucketFile bucketFile = new BucketFile(this.siteid);
        bucketFile.upload(serialnumber, file);
        if (bucketFile.doesObjectExist(serialnumber)) {
            String appfolderid = Parameter.get(this.siteid, "appfolderid");
            long attachmentid = this.createTableID("sys_attachment");
            SQLFactory sqlFactory = new SQLFactory("\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
            sqlFactory.addParameter("parentid", (Object)appfolderid);
            sqlFactory.addParameter("attachmentid", (Object)attachmentid);
            sqlFactory.addParameter("siteid", (Object)this.siteid);
            sqlFactory.addParameter("createby", (Object)this.username);
            sqlFactory.addParameter("type", (Object)"sourcefile");
            sqlFactory.addParameter("postfix", (Object)postfix);
            sqlFactory.addParameter("serialnumber", (Object)serialnumber);
            sqlFactory.addParameter("document", (Object)document);
            sqlFactory.addParameter("url", (Object)bucketFile.getFileUrl(serialnumber));
            sqlFactory.addParameter("mpctaskid", (Object)"null");
            sqlFactory.addParameter("contentlength", (Object)bucketFile.getObjectMetadata(serialnumber).getContentLength());
            this.dbConnect.runSqlUpdate(sqlFactory);
            return this.getAttachmentUrl(attachmentid);
        }
        return new Rows();
    }

    public void createFileLink(String ownertable, Long ownerid, String usetype, Long attachmentid) throws YosException {
        SQLFactory sql = new SQLFactory("\u521b\u5efa\u6570\u636e\u5a92\u4f53\u5173\u8054");
        sql.addParameter("linksid", (Object)this.createTableID("sys_attachment_links"));
        sql.addParameter("siteid", (Object)this.siteid);
        sql.addParameter("attachmentid", (Object)attachmentid);
        sql.addParameter("ownertable", (Object)ownertable);
        sql.addParameter("ownerid", (Object)ownerid);
        sql.addParameter("usetype", (Object)usetype);
        sql.addParameter("createby", (Object)this.username);
        this.dbConnect.runSqlUpdate(sql.getSQL());
    }

    public Row getHr(long userid) throws YosException {
        return this.getHr(userid, this.siteid);
    }

    public Row getDepartment(long userid) throws YosException {
        return this.getDepartment(userid, this.siteid);
    }

    public Row getAgentByUserid(long userid) throws YosException {
        return this.getAgentByUserid(userid, this.siteid);
    }

    public boolean isSaler() throws YosException {
        return this.dbConnect.runSqlQuery("select * from sa_salearea_hr where siteid='" + this.siteid + "' and hrid='" + this.hrid + "'").isNotEmpty();
    }

    public ArrayList<Long> getSaleAreaIds() throws YosException {
        if (this.sys_enterpriseid == 0L) {
            return new ArrayList<Long>();
        }
        Rows rows = this.dbConnect.runSqlQuery("select distinct sa_saleareaid from sys_enterprise_tradefield where siteid='" + this.siteid + "' and sys_enterpriseid=" + this.sys_enterpriseid);
        return rows.toArrayList("sa_saleareaid", new ArrayList());
    }

    public Row getEnterpriseByUserid(long userid) throws YosException {
        return this.getEnterpriseByUserid(userid, this.siteid);
    }

    public Row getEnterpriseHr(long userid) throws YosException {
        return this.getEnterpriseHr(userid, this.siteid);
    }

    public Rows getEnterpriseHrs(long sys_enterpriseid) throws YosException {
        return this.getEnterpriseHrs(sys_enterpriseid, this.siteid);
    }

    public Row getAgentByAgentid(long sa_agentsid) throws YosException {
        return this.getAgentByAgentid(sa_agentsid, this.siteid);
    }

    public ReturnObject_Err getErrReturnObject() {
        return this.returnObject.getErrObject();
    }

    public ReturnObject_Warn getWarnReturnObject() {
        return this.returnObject.getWarnObject();
    }

    public ReturnObject_Suc getSucReturnObject() {
        return this.returnObject.getSucObject();
    }

    public Rows getAttachmentUrl(String ownertable, Long ownerid) throws YosException {
        ArrayList<Long> ownerids = new ArrayList<Long>();
        ownerids.add(ownerid);
        return this.getAttachmentUrl(ownertable, ownerids).get((Object)String.valueOf(ownerid));
    }

    public RowsMap getAttachmentUrl(String ownertable, ArrayList<Long> ownerids) throws YosException {
        SQLFactory docfactory = new SQLFactory("\u9644\u4ef6\u67e5\u8be2");
        docfactory.addParameter("siteid", (Object)this.siteid);
        docfactory.addParameter("ownertable", (Object)ownertable);
        docfactory.addParameter_in("ownerid", ownerids);
        Rows rows = this.dbConnect.runSqlQuery(docfactory.getSQL());
        RowsMap subrowsmap = this.getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put((Object)"subfiles", (Object)subrowsmap.get((Object)row.getString("attachmentid")));
        }
        return rows.toRowsMap("ownerid");
    }

    public void logroleout(long roleid) throws YosException {
        ArrayList useridlist = this.dbConnect.runSqlQuery("select userid from sys_userrole where roleid=" + roleid).toArrayList("userid");
        for (String id : useridlist) {
            if (id.equals(String.valueOf(this.userid))) continue;
            this.loguserout(Long.parseLong(id));
        }
    }

    public Rows getAttachmentUrl(Long attachmentid) throws YosException {
        return this.getAttachmentUrl(new Long[]{attachmentid});
    }

    public Rows getAttachmentUrl(Long[] attachmentid) throws YosException {
        ArrayList<Long> list = new ArrayList<Long>(Arrays.asList(attachmentid));
        return this.getAttachmentUrl(list);
    }

    public Rows getAttachmentUrl(ArrayList<Long> attachmentid) throws YosException {
        SQLFactory docfactory = new SQLFactory("\u9644\u4ef6\u67e5\u8be2_ID");
        docfactory.addParameter("siteid", (Object)this.siteid);
        docfactory.addParameter_in("attachmentid", attachmentid);
        Rows rows = this.dbConnect.runSqlQuery(docfactory.getSQL());
        RowsMap subrowsmap = this.getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put((Object)"subfiles", (Object)subrowsmap.get((Object)row.getString("attachmentid")));
        }
        return rows;
    }

    public Rows getAttachmentUrl(String ownertable, Long ownerid, String usetype) throws YosException {
        SQLFactory attquerysql = new SQLFactory("\u9644\u4ef6\u67e5\u8be2_\u7c7b\u578b");
        attquerysql.addParameter("siteid", (Object)this.siteid);
        attquerysql.addParameter("ownertable", (Object)ownertable);
        attquerysql.addParameter_in("ownerid", (Object)ownerid);
        attquerysql.addParameter("usetype", (Object)usetype);
        Rows rows = this.dbConnect.runSqlQuery(attquerysql.getSQL());
        RowsMap subrowsmap = this.getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put((Object)"subfiles", (Object)subrowsmap.get((Object)row.getString("attachmentid")));
        }
        return rows;
    }

    public RowsMap getAttachmentUrl(String ownertable, ArrayList<Long> ownerids, String usetype) throws YosException {
        SQLFactory docfactory = new SQLFactory("\u9644\u4ef6\u67e5\u8be2_\u7c7b\u578b");
        docfactory.addParameter("siteid", (Object)this.siteid);
        docfactory.addParameter("ownertable", (Object)ownertable);
        docfactory.addParameter_in("ownerid", ownerids);
        docfactory.addParameter("usetype", (Object)usetype);
        Rows rows = this.dbConnect.runSqlQuery(docfactory.getSQL());
        RowsMap subrowsmap = this.getSubAttachmentUrl(rows.toArrayList("attachmentid"));
        for (Row row : rows) {
            row.put((Object)"subfiles", (Object)subrowsmap.get((Object)row.getString("attachmentid")));
        }
        return rows.toRowsMap("ownerid");
    }

    public Rows getSubAttachmentUrl(String attachmentid) throws YosException {
        ArrayList<String> attachmentids = new ArrayList<String>();
        attachmentids.add(attachmentid);
        return this.getSubAttachmentUrl(attachmentids).get((Object)attachmentid);
    }

    public RowsMap getSubAttachmentUrl(ArrayList<String> attachmentids) throws YosException {
        SQLFactory docfactory = new SQLFactory("\u5b50\u9644\u4ef6\u67e5\u8be2");
        docfactory.addParameter("siteid", (Object)this.siteid);
        docfactory.addParameter_in("parentid", attachmentids);
        Rows rows = this.dbConnect.runSqlQuery(docfactory.getSQL());
        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = this.getSubAttachmentUrl(rows.toArrayList("attachmentid"));
            for (Row row : rows) {
                row.put((Object)"subfiles", (Object)subrowsmap.get((Object)row.getString("attachmentid")));
            }
        }
        return rows.toRowsMap("parentid");
    }

    public String getHeadPic(long userid) throws YosException {
        Rows rows;
        if (!headPicMap.containsKey(userid) && !(rows = this.getAttachmentUrl("sys_users", userid, "headportrait")).isEmpty()) {
            headPicMap.put(userid, rows.get(0).getString("url"));
        }
        return headPicMap.getOrDefault(userid, "");
    }

    public RowsMap getAttachmentQty(String ownertable, ArrayList<Long> ownerids) throws YosException {
        return this.getAttachmentQty(ownertable, ownerids, "default");
    }

    public Rows getAttachmentQty(String ownertable, Long ownerid) throws YosException {
        return this.getAttachmentQty(ownertable, ownerid, "default");
    }

    public Rows getAttachmentQty(String ownertable, Long ownerid, String usetype) throws YosException {
        ArrayList<Long> ownerids = new ArrayList<Long>();
        ownerids.add(ownerid);
        return this.getAttachmentQty(ownertable, ownerids, usetype).get((Object)String.valueOf(ownerid));
    }

    public RowsMap getAttachmentQty(String ownertable, ArrayList<Long> ownerids, String usetype) throws YosException {
        SQLFactory docfactory = new SQLFactory("\u9644\u4ef6\u6570\u91cf\u67e5\u8be2");
        docfactory.addParameter("siteid", (Object)this.siteid);
        docfactory.addParameter("ownertable", (Object)ownertable);
        docfactory.addParameter_in("ownerid", ownerids);
        docfactory.addParameter("usetype", (Object)usetype);
        return this.dbConnect.runSqlQuery(docfactory.getSQL()).toRowsMap("ownerid");
    }

    public Rows getDataLog(String tablename, long dataid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_datalog where table_name='" + tablename + "' and dataid=" + dataid + " order by changedate desc");
        for (Row row : rows) {
            row.put((Object)"olddata", (Object)JSONObject.parseObject((String)row.getString("olddata")));
            row.put((Object)"newdata", (Object)JSONObject.parseObject((String)row.getString("newdata")));
        }
        return rows;
    }

    public ArrayList<Long> getImDialogUserIds(long timdialogid) throws YosException {
        return this.getImDialogUserIds(timdialogid, this.siteid);
    }

    public Date getLoginDate() {
        return this.getLoginDate(this.usersiteid);
    }

    public void loguserout() throws YosException {
        ArrayList usersiteids = this.dbConnect.runSqlQuery("select usersiteid from sys_usersite where userid!=" + this.userid).toArrayList("usersiteid");
        for (String id : usersiteids) {
            long usersiteid = Long.parseLong(id);
            if (!parameter.usersiteIdList.containsKey(usersiteid)) continue;
            String token = parameter.usersiteIdList.get(usersiteid).getString("token");
            parameter.tokenlist.remove(token);
        }
        this.dbConnect.runSqlUpdate("update sys_usersite set accesstoken=null,systemclient=null where userid='" + this.userid + "'");
    }

    public String createBillCode(String coderuletype) throws YosException {
        return this.createBillCode(this.siteid, coderuletype);
    }

    public String getSystemModuleIconUrl(Long systemmoduleid, String usetype) throws YosException {
        if (systemmoduleid != 0L) {
            SQLFactory iconquerysql;
            if (systemModuleIconUrlMap.isEmpty()) {
                iconquerysql = new SQLFactory("\u7cfb\u7edf\u6a21\u5757\u56fe\u6807\u67e5\u8be2");
                systemModuleIconUrlMap = this.dbConnect.runSqlQuery(iconquerysql.getSQL()).toRowsMap("ownerid");
            } else if (!systemModuleIconUrlMap.containsKey(String.valueOf(systemmoduleid))) {
                iconquerysql = new SQLFactory("\u7cfb\u7edf\u6a21\u5757\u56fe\u6807\u67e5\u8be2_ID");
                iconquerysql.addParameter("ownerid", (Object)systemmoduleid);
                Rows iconqueryRows = this.dbConnect.runSqlQuery(iconquerysql.getSQL());
                if (!iconqueryRows.isEmpty()) {
                    systemModuleIconUrlMap.put(String.valueOf(systemmoduleid), iconqueryRows);
                }
            }
            if (systemModuleIconUrlMap.containsKey(String.valueOf(systemmoduleid))) {
                for (Row iconrow : systemModuleIconUrlMap.get(String.valueOf(systemmoduleid))) {
                    if (!iconrow.getString("usetype").equals(usetype)) continue;
                    return iconrow.getString("url");
                }
            }
        }
        return "";
    }

    public String getReportToken(long sys_reportid) throws YosException {
        long sys_report_sessionid = this.createTableID("sys_report_session");
        String token = Encryption.Encode_MD5(this.siteid + sys_reportid + sys_report_sessionid + this.username + this.userid);
        SQLFactory sqlFactory = new SQLFactory("\u62a5\u8868\u8bbf\u95ee\u6388\u6743");
        sqlFactory.addParameter("sys_report_sessionid", (Object)sys_report_sessionid);
        sqlFactory.addParameter("siteid", (Object)this.siteid);
        sqlFactory.addParameter("sys_reportid", (Object)sys_reportid);
        sqlFactory.addParameter("userid", (Object)this.userid);
        sqlFactory.addParameter("token", (Object)token);
        sqlFactory.addParameter("dataid", (Object)0);
        sqlFactory.addParameter("systemclient", (Object)this.systemclient);
        this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return token;
    }

    public String getReportToken(long sys_reportid, long dataid) throws YosException {
        long sys_report_sessionid = this.createTableID("sys_report_session");
        String token = Encryption.Encode_MD5(this.siteid + sys_reportid + sys_report_sessionid + this.username + this.userid);
        SQLFactory sqlFactory = new SQLFactory("\u62a5\u8868\u8bbf\u95ee\u6388\u6743");
        sqlFactory.addParameter("sys_report_sessionid", (Object)sys_report_sessionid);
        sqlFactory.addParameter("siteid", (Object)this.siteid);
        sqlFactory.addParameter("sys_reportid", (Object)sys_reportid);
        sqlFactory.addParameter("userid", (Object)this.userid);
        sqlFactory.addParameter("token", (Object)token);
        sqlFactory.addParameter("dataid", (Object)dataid);
        sqlFactory.addParameter("systemclient", (Object)this.systemclient);
        this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return token;
    }

    public void cleanAllDataPool() {
        DataPool.removeByAccesstoken(this.accesstoken);
    }

    public void cleanAllDataPool(long userid) {
        DataPool.removeByUserid(userid);
    }

    public void CACHEING_CLEAN(Long userid) {
        try {
            this.request.addCacheing_cleanUser(userid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

