package utility.huawei.obs;

import beans.parameter.Parameter;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.*;
import common.BaseClass;
import common.YosException;
import common.data.Rows;
import common.parameter.properties;
import utility.tools.Math;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * 华为云桶管理
 */
public class Bucket extends BaseClass {
    protected String bucketname;
    protected String siteid;
    protected ObsClient obsClient;

    public static void main(String[] args) throws YosException {
        Bucket bucket = new Bucket("YOSSYS");
        bucket.createBucketname();
    }

    public Bucket(String siteid) throws YosException {
        this.siteid = siteid.toLowerCase();
        this.obsClient = new ObsClient(Parameter.get("attachment_huawei_obs_ak"), Parameter.get("attachment_huawei_obs_sk"), Parameter.get("attachment_huawei_obs_endpoint"));
        this.bucketname = getBucketname();
        /**
         * 如果当前站点不存在桶则自动创建该桶
         */
        if (!isAllReadyUsed()) {
            create();
        }
    }

    private String getBucketname() {
        try {
            Rows rows = dbConnect.runSqlQuery("select bucketname from sys_site where ifnull(bucketname,'')!='' and siteid='" + siteid + "'");
            if (rows.isNotEmpty()) {
                bucketname = rows.get(0).getString("bucketname").toLowerCase();
            } else {
                bucketname = createBucketname().toLowerCase();
                dbConnect.runSqlUpdate("update sys_site set bucketname='" + bucketname + "' where siteid='" + siteid + "'");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return this.bucketname;
    }

    private String createBucketname() {
        String bn = (siteid + Math.random(5)).toLowerCase();
        if (obsClient.headBucket(bn)) {
            return createBucketname();
        } else {
            return bn;
        }
    }

    public ObsClient getObsClient() {
        return obsClient;
    }

    /**
     * 创建桶
     */
    public boolean create() throws YosException {
        // 创建桶
        try {
            ObsBucket obsBucket = new ObsBucket();
            obsBucket.setBucketName(bucketname);
            // 设置桶访问权限为公共读写
            obsBucket.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ_WRITE);
            // 设置桶区域位置
            obsBucket.setLocation(Parameter.get("attachment_huawei_obs_location"));
            // 创建桶
            obsClient.createBucket(obsBucket);
            setBucketCors();
        } catch (ObsException e) {
            // 创建桶失败
            System.out.println("HTTP Code: " + e.getResponseCode());
            System.out.println("Error Code:" + e.getErrorCode());
            System.out.println("Error Message: " + e.getErrorMessage());
            System.out.println("Request ID:" + e.getErrorRequestId());
            System.out.println("Host ID:" + e.getErrorHostId());
            return false;
        }
        return true;
    }

    /**
     * 设置桶参数
     */
    public void setBucketCors() {
        BucketCors cors = new BucketCors();

        List<BucketCorsRule> rules = new ArrayList<BucketCorsRule>();
        BucketCorsRule rule = new BucketCorsRule();

        ArrayList<String> allowedOrigin = new ArrayList<String>();
        // 指定允许跨域请求的来源
        allowedOrigin.add("*");
        rule.setAllowedOrigin(allowedOrigin);

        ArrayList<String> allowedMethod = new ArrayList<String>();
        // 指定允许的跨域请求方法(GET/PUT/DELETE/POST/HEAD)
        allowedMethod.add("GET");
        allowedMethod.add("HEAD");
        allowedMethod.add("PUT");
        allowedMethod.add("POST");
        allowedMethod.add("DELETE");
        rule.setAllowedMethod(allowedMethod);

        ArrayList<String> allowedHeader = new ArrayList<String>();
        // 控制在OPTIONS预取指令中Access-Control-Request-Headers头中指定的header是否被允许使用
        allowedHeader.add("*");
        rule.setAllowedHeader(allowedHeader);

        //ArrayList<String> exposeHeader = new ArrayList<String>();
        // 指定允许用户从应用程序中访问的header
        //        exposeHeader.add("x-obs-expose-header");
        //        rule.setExposeHeader(exposeHeader);

        // 指定浏览器对特定资源的预取(OPTIONS)请求返回结果的缓存时间,单位为秒
        rule.setMaxAgeSecond(3600);
        rules.add(rule);
        cors.setRules(rules);
        obsClient.setBucketCors(bucketname, cors);
        String policy = "{\n" +
                "    \"Statement\": [\n" +
                "        {\n" +
                "            \"Sid\": \"公共读\",\n" +
                "            \"Effect\": \"Allow\",\n" +
                "            \"Principal\": {\n" +
                "                \"ID\": [\n" +
                "                    \"*\"\n" +
                "                ]\n" +
                "            },\n" +
                "            \"Action\": [\n" +
                "                \"ListBucket\",\n" +
                "                \"HeadBucket\",\n" +
                "                \"GetBucketLocation\",\n" +
                "                \"ListBucketVersions\",\n" +
                "                \"GetObject\",\n" +
                "                \"RestoreObject\",\n" +
                "                \"GetObjectVersion\"\n" +
                "            ],\n" +
                "            \"Resource\": [\n" +
                "                \"" + bucketname + "\",\n" +
                "                \"" + bucketname + "/*\"\n" +
                "            ]\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        obsClient.setBucketPolicy(bucketname, policy);
    }

    /**
     * 是否已存在桶
     *
     * @return
     */
    public boolean isAllReadyUsed() {
        return obsClient.headBucket(bucketname);
    }

    /**
     * 删除桶
     *
     * @return
     */
    public void delete() {
        // 删除桶
        obsClient.deleteBucket(bucketname);
    }

    /**
     * 设置桶配额,单位G
     */
    public void setVolume(long volume) {
        BucketQuota quota = new BucketQuota(1024 * 1024 * 1024 * volume);
        obsClient.setBucketQuota(bucketname, quota);
    }

    /**
     * 获取桶配额,单位字节
     */
    public long getMaxVolume() {
        BucketQuota quota = obsClient.getBucketQuota(bucketname);
        return quota.getBucketQuota();
    }

    /**
     * 获取桶存量
     *
     * @return
     */
    public long getVolume() {
        BucketStorageInfo storageInfo = obsClient.getBucketStorageInfo(bucketname);
        return storageInfo.getSize();
    }

    /**
     * 获取文件数量
     *
     * @return
     */
    public long getFileCount() {
        BucketStorageInfo storageInfo = obsClient.getBucketStorageInfo(bucketname);
        return storageInfo.getObjectNumber();
    }

}
