package restcontroller.sysmanage.develop.paymentrules;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import restcontroller.R;

import java.math.BigDecimal;
import java.util.ArrayList;

public class paymentrules extends Controller {
    public paymentrules(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "更新站点付费信息", apiversion = R.ID10024001.v1.class)
    public String updateSitePayInfo() throws YosException {
        String siteid = content.getString("siteid");
        boolean sys_payswitch = content.getBooleanValue("sys_payswitch");
        int sys_payincidence = content.getIntValue("sys_payincidence");
        int sys_trialperiod = content.getIntValue("sys_trialperiod");
        String sys_payinstructions = content.getStringValue("sys_payinstructions");
        long sys_payremind = content.getLongValue("sys_payremind");
        UpdateSQL updateSQL = SQLFactory.createUpdateSQL(dbConnect, "sys_site_parameter");
        updateSQL.setSiteid(siteid);
        updateSQL.setValue("sys_payswitch", sys_payswitch);   //系统付费开关
        updateSQL.setValue("sys_trialperiod", sys_trialperiod);   //系统试用时间（月份）
        updateSQL.setValue("sys_payincidence", sys_payincidence == 1 ? 1 : 2);    //付费影响范围（付费类型）1，按账号，2按主体
        updateSQL.setValue("sys_payinstructions", sys_payinstructions);    //付费说明
        updateSQL.setValue("sys_payremind", sys_payremind);     //付费到期提醒
        updateSQL.update();
        return getSucReturnObject().toString();
    }


    @API(title = "新增或更新")
    public String insertOrUpdate() throws YosException {
        //1:按账号付费，2：按主体付费
        String siteid = content.getString("siteid");
        long type = content.getLongValue("type");
        long sys_site_paymentrulesid = content.getLongValue("sys_site_paymentrulesid");
        //系统版本ID
        Long sys_site_systempartitionid = content.getLong("sys_site_systempartitionid");
        int usertype = content.getIntValue("usertype");
        JSONArray paymentrules = content.getJSONArray("paymentrules");

        SQLFactory factory = new SQLFactory(this, "版本付费规则_新增");
        if (sys_site_paymentrulesid <= 0) {
            //1:按账号付费
            if (type == 1) {
                Rows rows = dbConnect.runSqlQuery("SELECT sys_site_paymentrulesid FROM sys_site_paymentrules WHERE siteid='" + siteid + "' AND usertype=" + usertype + " AND sys_site_systempartitionid=" + sys_site_systempartitionid + " AND price IS NULL");
                if (rows.isNotEmpty()) {
                    sys_site_paymentrulesid = rows.get(0).getLong("sys_site_paymentrulesid");
                    factory = new SQLFactory(this, "版本付费规则_更新");
                } else {
                    sys_site_paymentrulesid = createTableID("sys_site_paymentrules");
                }
            }
            //2：按主体付费
            if (type == 2) {
                Rows rows = dbConnect.runSqlQuery("SELECT sys_site_paymentrulesid FROM sys_site_paymentrules WHERE siteid='" + siteid + "' AND sys_site_systempartitionid=" + sys_site_systempartitionid + " AND usertype IS NULL");
                if (rows.isNotEmpty()) {
                    sys_site_paymentrulesid = rows.get(0).getLong("sys_site_paymentrulesid");
                    factory = new SQLFactory(this, "版本付费规则_更新");
                } else {
                    sys_site_paymentrulesid = createTableID("sys_site_paymentrules");
                }
            }

        } else {
            factory = new SQLFactory(this, "版本付费规则_更新");
        }

        factory.addParameter("sys_site_paymentrulesid", sys_site_paymentrulesid);
        factory.addParameter("siteid", siteid);
        factory.addParameter("sys_site_systempartitionid", sys_site_systempartitionid);
        //按账号付费
        if (type == 1) {
            factory.addParameter("usertype", usertype);
            factory.addParameter("paymentrules", paymentrules);
            factory.addParameter_SQL("price", "null");
        }
        //按主体付费
        else {
            BigDecimal price = content.getBigDecimal("price");
            factory.addParameter_SQL("usertype", "null");
            factory.addParameter("paymentrules", "[]");
            factory.addParameter("price", price);
        }


        //许可证有效期
        factory.addParameter("licenseperiod", 12);
        dbConnect.runSqlUpdate(factory);

        content.put("sys_site_paymentrulesid", sys_site_paymentrulesid);
        return detail();
    }

    @API(title = "详细")
    public String detail() throws YosException {

        Long sys_site_paymentrulesid = content.getLongValue("sys_site_paymentrulesid");
        String siteid = content.getString("siteid");
        SQLFactory sqlFactory = new SQLFactory(this, "版本付费规则_详细");
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("sys_site_paymentrulesid", sys_site_paymentrulesid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        for (Row row : rows) {
            String paymentrules = row.getString("paymentrules");
            JSONArray array = JSONArray.parseArray(paymentrules);
            row.put("paymentrules", array);
        }
        Row detailRow = rows.isNotEmpty() ? rows.get(0) : new Row();

        return getSucReturnObject().setData(detailRow).toString();
    }

    @API(title = "删除")
    public String delete() throws YosException {
        Long sys_site_paymentrulesid = content.getLongValue("sys_site_paymentrulesid");
        String siteid = content.getString("siteid");
        dbConnect.runSqlUpdate("DELETE FROM sys_site_paymentrules WHERE sys_site_paymentrulesid=" + sys_site_paymentrulesid + " and siteid='" + siteid + "'");

        return getSucReturnObject().toString();
    }

    @API(title = "列表")
    public String list() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.sys_site_systempartitionid like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        //1:按账号付费，2：按主体付费
        Long type = content.getLongValue("type");
        if (type == 1) {
            where.append(" and ( usertype IS NOT NULL )");
        }
        if (type == 2) {
            where.append(" and ( usertype IS NULL )");
        }
        String siteid = content.getString("siteid");

        SQLFactory sqlFactory = new SQLFactory(this, "版本付费规则_列表", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        for (Row row : rows) {
            row.put("paymentrules", JSONArray.parseArray(row.getString("paymentrules")));
        }
        return getSucReturnObject().setData(rows).toString();

    }

    @API(title = "查询到期提醒列表")
    public String queryRemind() throws YosException {
        String siteid = content.getString("siteid");
        Rows rows = dbConnect.runSqlQuery("SELECT * from sys_site_parameter WHERE siteid='" + siteid + "'");
        Boolean sys_payswitch = false;
        Long sys_payremind = 0L;
        if (rows.isNotEmpty()) {
            sys_payswitch = rows.get(0).getBoolean("sys_payswitch");
            sys_payremind = rows.get(0).getLong("sys_payremind");
        }
        if (sys_payremind != 0 && sys_payswitch) {
            //试用期已过期
            if (dbConnect.runSqlQuery("SELECT * from sys_usertrialperiod WHERE userid=" + userid + " and siteid='" + siteid + "' and enddate>=CURRENT_DATE").isEmpty()) {
                //查询付费提醒
                rows = getPayRows(sys_payremind, userid);
            } else {
                //查询是否存在付费记录
                rows = getPayRecordsRows();
                if (rows.isEmpty()) {
                    //查询试用期提醒
                    rows = getPeriodRows(sys_payremind);
                } else {
                    //查询付费提醒
                    rows = getPayRows(sys_payremind, userid);
                }
            }

        } else {
            rows = new Rows();
        }


        return getSucReturnObject().setData(rows).toString();
    }

    public Rows getPayRows(Long sys_payremind, ArrayList<Long> userid) throws YosException {
        String siteid = content.getString("siteid");
        SQLFactory sqlFactory = new SQLFactory(this, "查询提醒到期版本");
        sqlFactory.addParameter_in("userid", userid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("days", sys_payremind);
        String sql = sqlFactory.getSQL();
        return dbConnect.runSqlQuery(sql);
    }

    public Rows getPayRows(Long sys_payremind, Long userid) throws YosException {
        ArrayList<Long> list = new ArrayList<>();
        list.add(userid);
        return getPayRows(sys_payremind, list);
    }

    public Rows getPayRecordsRows() throws YosException {
        String siteid = content.getString("siteid");
        SQLFactory sqlFactory = new SQLFactory(this, "查询付费记录");
        sqlFactory.addParameter("userid", userid);
        sqlFactory.addParameter("siteid", siteid);
        return dbConnect.runSqlQuery(sqlFactory);
    }

    public Rows getPeriodRows(Long sys_payremind) throws YosException {
        String siteid = content.getString("siteid");
        SQLFactory sqlFactory = new SQLFactory(this, "查询试用期到期");
        sqlFactory.addParameter("userid", userid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("days", sys_payremind);
        return dbConnect.runSqlQuery(sqlFactory);
    }


    @API(title = "查询提醒账号")
    public String queryRemindUser() throws YosException {
        String siteid = content.getString("siteid");
        SQLFactory sqlFactory = new SQLFactory(this, "查询提醒账号");
        sqlFactory.addParameter("sys_enterpriseid", sys_enterpriseid);
        sqlFactory.addParameter("siteid", siteid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        ArrayList<Long> ids = rows.toArrayList("messageid", new ArrayList<>());
        //调整为已读
        if (ids.size() > 0) {
            String sql = "UPDATE sys_message SET isread=1,readdate=CURRENT_TIME WHERE messageid in " + ids + " and siteid='" + siteid + "'";
            sql = sql.replace("[", "(").replace("]", ")");
            dbConnect.runSqlUpdate(sql);
        }
        Rows userRows = new Rows();
        for (Row row : rows) {
            Row userRow = new Row();
            userRow.put("userid", row.getLong("userid"));
            userRow.put("name", row.getString("name"));
            userRow.put("sys_site_systempartitionid", row.getString("sys_site_systempartitionid"));
            userRow.put("partitionname", row.getString("partitionname"));
            if (!userRows.contains(userRow)) {
                userRows.add(userRow);
            }
        }
//        Rows rowsParameter = dbConnect.runSqlQuery("SELECT * from sys_site_parameter WHERE siteid='" + siteid + "'");
//
//        Long sys_payremind = 0L;
//        if (rowsParameter.isNotEmpty()) {
//            sys_payremind = rowsParameter.get(0).getLong("sys_payremind");
//        }
//        rows = getPayRows(sys_payremind, userRows.toArrayList("userid", new ArrayList<>()));


        return getSucReturnObject().setData(userRows).toString();
    }

}
