package restcontroller.sysmanage.develop.datawarn;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import common.data.db.DBConnect;
import common.data.db.SQLiteMemory;
import restcontroller.R;

public class datawarn extends Controller {
    public datawarn(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "数据异常列表查询", apiversion = R.ID10012001.v1.class)
    public String queryWarnList() throws YosException {
        boolean witherrdata = content.getBooleanValue("witherrdata");
        Rows datawarnRows;
        if (witherrdata) {
            datawarnRows = dbConnect.runSqlQuery("select * from sys_datawarn where isused=1 order by sequence");
            for (Row datawarnRow : datawarnRows) {
                String type = datawarnRow.getString("type");
                String datakey = datawarnRow.getString("datakey");
                try {
                    Rows r = null;
                    if (datakey.equals("") || datakey.equalsIgnoreCase("default")) {
                        r = dbConnect.runSqlQuery(datawarnRow.getString("sqlstr"));
                    } else if (datakey.equalsIgnoreCase("sqliteCache")) {
                        r = SQLiteMemory.runSqlQuery(datawarnRow.getString("sqlstr"));
                    } else {
                        r = new DBConnect(datakey).runSqlQuery(datawarnRow.getString("sqlstr"));
                    }
                    datawarnRow.put("datas", r);
                    if (type.equals("error")) {
                        datawarnRow.put("status", r.isEmpty() ? "正常" : "异常");
                    } else {
                        datawarnRow.put("status", "正常");
                    }
                    datawarnRow.put("errdatacolumns", r.getFieldList());
                } catch (Exception e) {
                    datawarnRow.put("datas", new Rows());
                    datawarnRow.put("status", "SQL语句错误");
                }
            }
        } else {
            datawarnRows = dbConnect.runSqlQuery("select * from sys_datawarn order by sequence");
        }
        return getSucReturnObject().setData(datawarnRows).toString();
    }

    @API(title = "数据异常新增修改", apiversion = R.ID10012101.v1.class)
    public String insertormodifyWarn() throws YosException {
        long sys_datawarnid = content.getLongValue("sys_datawarnid");
        String title = content.getString("title");
        String remarks = content.getStringValue("remarks");
        String type = content.getStringValue("type");
        String datakey = content.getString("datakey");
        String sqlstr = content.getString("sqlstr", true);
        boolean isused = content.getBooleanValue("isused");
        if (isused) {
            try {
                if (datakey.equals("") || datakey.equalsIgnoreCase("default")) {
                    dbConnect.runSqlQuery(content.getString("sqlstr", true).replace("\\'", "'"));
                } else if (datakey.equalsIgnoreCase("sqliteCache")) {
                    SQLiteMemory.runSqlQuery(content.getString("sqlstr", true).replace("\\'", "'"));
                } else {
                    new DBConnect(datakey).runSqlQuery(content.getString("sqlstr", true).replace("\\'", "'"));
                }
            } catch (Exception e) {
                return getErrReturnObject().setErrMsg("无效的sql查询语句").toString();
            }
        }
        int sequence = content.getIntValue("sequence");
        if (sys_datawarnid == 0 || dbConnect.runSqlQuery("select * from sys_datawarn where sys_datawarnid=" + sys_datawarnid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_datawarn");
            insertSQL.setValue("sys_datawarnid", createTableID("sys_datawarn"));
            insertSQL.setValue("title", title);
            insertSQL.setValue("remarks", remarks);
            insertSQL.setValue("sqlstr", sqlstr);
            insertSQL.setValue("isused", isused);
            insertSQL.setValue("sequence", sequence);
            insertSQL.setValue("type", type);
            insertSQL.setValue("datakey", datakey);
            insertSQL.insert();
        } else {
            UpdateSQL rowUpdate = SQLFactory.createUpdateSQL(this, "sys_datawarn");
            rowUpdate.setValue("title", title);
            rowUpdate.setValue("remarks", remarks);
            rowUpdate.setValue("sqlstr", sqlstr);
            rowUpdate.setValue("isused", isused);
            rowUpdate.setValue("sequence", sequence);
            rowUpdate.setValue("type", type);
            rowUpdate.setValue("datakey", datakey);
            rowUpdate.setWhere("sys_datawarnid", sys_datawarnid);
            rowUpdate.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "数据异常删除", apiversion = R.ID10012201.v1.class)
    public String deleteWarn() throws YosException {
        long sys_datawarnid = content.getLong("sys_datawarnid");
        dbConnect.runSqlUpdate("delete from sys_datawarn where sys_datawarnid=" + sys_datawarnid);
        return getSucReturnObject().toString();
    }
}
