package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_paycoupon_log implements YosObject {
  @Override
  public String table_comment() {
    return "优惠券使用记录";
  }

  @Override
  public UniqueCol uniquecolumn() {
    return new UniqueCol("sys_paycoupon_logid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, false, false, false, "", 0));
    arrayList.add(new BigIntCol("sys_paycouponid", "账号付款优惠券ID", "账号付款优惠券ID", false, false, false, 0));
    arrayList.add(new BigIntCol("sys_payorderid", "账号付费订单ID", "账号付费订单ID", true, false, false, 0));
    arrayList.add(new BigIntCol("sys_payorderitemsid", "账号付费订单明细ID", "账号付费订单明细ID", false, false, false, 0));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 0));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", false, false, "", 0));
    arrayList.add(new SmallIntCol("isvalid", "是否有效的", "是否有效的", false, false, false, 0, 0));
    return arrayList;
  }
}
