package restcontroller.sysmanage.develop.userauth;

import beans.accountpay.AccountPay;
import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.parameter.parameter;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "管理端-开发-权限管理-权限查询")
public class userauth extends Controller {
    public userauth(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "获取当前登陆角色授权信息", apiversion = R.ID10016901.v1.class)
    @CACHEING
    public String query_userauth() throws YosException {
        if (dbConnect.runSqlQuery("select * from sys_users where sysadministrator=1 and userid=" + userid).isEmpty()) {
            /**
             * 获取角色系统授权
             */
            SQLFactory systemsql = new SQLFactory(this, "获取角色系统授权");
            systemsql.addParameter("userid", userid);
            systemsql.addParameter("siteid", siteid);
            systemsql.addParameter("systemclient", systemclient);
            Rows systemRows = dbConnect.runSqlQuery(systemsql);
            for (Row row : systemRows) {
                row.put("iconurl", getSystemIconUrl(row.getLong("systemid"), "icon"));
                row.put("iconurl_mainnav", getSystemIconUrl(row.getLong("systemid"), "mainnavicon"));
            }
            /**
             * 获取角色模块授权
             */
            SQLFactory modulesql = new SQLFactory(this, "获取角色模块授权");
            modulesql.addParameter("userid", userid);
            modulesql.addParameter("siteid", siteid);
            modulesql.addParameter("systemclient", systemclient);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);
            for (Row row : moduleRows) {
                row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
                row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));
            }
            RowsMap moduleRowsMap = moduleRows.toRowsMap("systemid");

            /**
             * 获取角色应用授权
             */
            SQLFactory appsql = new SQLFactory(this, "获取角色应用授权");
            appsql.addParameter("userid", userid);
            appsql.addParameter("siteid", siteid);
            appsql.addParameter("systemclient", systemclient);
            Rows appRows = dbConnect.runSqlQuery(appsql);
            RowsMap appRowsMap = appRows.toRowsMap("systemmoduleid");

            /**
             * 获取角色功能授权
             */
            SQLFactory optionsql = new SQLFactory(this, "获取角色功能授权");
            optionsql.addParameter("userid", userid);
            optionsql.addParameter("siteid", siteid);
            Rows OptionRows = dbConnect.runSqlQuery(optionsql);
            RowsMap optionRowsMap = OptionRows.toRowsMap("systemappid");
            /**
             * 获取角色限制栏位
             */
            SQLFactory hiddenfieldsql = new SQLFactory(this, "获取角色限制栏位");
            hiddenfieldsql.addParameter("userid", userid);
            hiddenfieldsql.addParameter("siteid", siteid);
            RowsMap hiddenfieldRowsMap = dbConnect.runSqlQuery(hiddenfieldsql).toRowsMap("systemappid");

            /**
             * 获取应用网格配置
             */
            SQLFactory gridsql = new SQLFactory(this, "获取角色应用网格配置");
            gridsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows gridrows = dbConnect.runSqlQuery(gridsql);
            RowsMap gridRowsMap = gridrows.toRowsMap("systemappid");

            /**
             * 获取应用表格配置
             */
            SQLFactory tablesql = new SQLFactory(this, "获取角色应用表格配置");
            tablesql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows tablerows = dbConnect.runSqlQuery(tablesql);
            RowsMap tableRowsMap = tablerows.toRowsMap("systemappid");

            SQLFactory tablecolsql = new SQLFactory(this, "获取角色应用表格栏位配置");
            tablecolsql.addParameter_in("tableid", tablerows.toArrayList("tableid"));
            Rows alltablecolRows = dbConnect.runSqlQuery(tablecolsql);
            RowsMap sitetablecolRowsMap = dbConnect.runSqlQuery("select tablecolid,title,width,hidden from sys_systemapp_tablecols_site where siteid='" + siteid + "'").toRowsMap("tablecolid");
            ArrayList<Row> hiddenRow = new ArrayList<>();
            for (Row tablecolRow : alltablecolRows) {
                if (sitetablecolRowsMap.containsKey(tablecolRow.getString("tablecolid"))) {
                    Rows sitecolsRows = sitetablecolRowsMap.get(tablecolRow.getString("tablecolid"));
                    if (!sitecolsRows.get(0).getString("title").equals("")) {
                        tablecolRow.put("title", sitecolsRows.get(0).getString("title"));
                    }
                    if (sitecolsRows.get(0).getInteger("width") > 0) {
                        tablecolRow.put("width", sitecolsRows.get(0).getInteger("width"));
                    }
                    if (sitecolsRows.get(0).getInteger("hidden") == 1) {
                        tablecolRow.put("hidden", 1);
                    }
                }
                if (tablecolRow.getBoolean("hidden")) {
                    hiddenRow.add(tablecolRow);
                }
            }
            for (Row row : hiddenRow) {
                alltablecolRows.remove(row);
            }
            RowsMap tablecolRowsMap = alltablecolRows.toRowsMap("tableid");

            /**
             * 获取应用小组件配置
             */
            SQLFactory wedgitsql = new SQLFactory(this, "获取角色应用小组件配置");
            wedgitsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            RowsMap wedgitRowsMap = dbConnect.runSqlQuery(wedgitsql).toRowsMap("systemappid");


            for (Row systemRow : systemRows) {
                Rows modulerows = moduleRowsMap.get(systemRow.getString("systemid"));
                for (Row moduleRow : modulerows) {
                    Rows approws = appRowsMap.get(moduleRow.getString("systemmoduleid"));
                    for (Row appRow : approws) {
                        String systemappid = appRow.getString("systemappid");

                        Rows optionRows = optionRowsMap.get(systemappid);
                        optionRows.removeColumn(new String[]{"systemappid"});

                        Rows hiddenfieldRows = hiddenfieldRowsMap.get(systemappid);
                        hiddenfieldRows.removeColumn(new String[]{"systemappid"});

                        Rows wedgitsRows = wedgitRowsMap.get(systemappid);
                        wedgitsRows.removeColumn(new String[]{"systemappid"});

                        JSONObject gridObject = new JSONObject();
                        Rows gridRows = gridRowsMap.get(systemappid);
                        for (Row gridRow : gridRows) {
                            gridObject.put(gridRow.getString("grid"), gridRow);
                        }
                        gridRows.removeColumn(new String[]{"systemappid", "grid", "gridid"});

                        JSONObject tableObject = new JSONObject();
                        Rows tableRows = tableRowsMap.get(systemappid);
                        for (Row tableRow : tableRows) {
                            Rows tablecolRows = tablecolRowsMap.get(tableRow.getString("tableid"));
                            tablecolRows.removeColumn(new String[]{"tableid", "tablecolid"});
                            tableRow.put("tablecols", tablecolRows);
                            tableObject.put(tableRow.getString("table"), tableRow);
                        }
                        tableRows.removeColumn(new String[]{"systemappid", "table", "tableid"});

                        JSONObject metaObject = new JSONObject();
                        metaObject.put("title", appRow.getString("systemappname"));
                        metaObject.put("auth", optionRows);
                        metaObject.put("hiddenfields", hiddenfieldRows);
                        metaObject.put("wedgits", wedgitsRows);
                        metaObject.put("grids", gridObject);
                        metaObject.put("tables", tableObject);

                        appRow.put("path", appRow.getString("apppath"));
                        appRow.put("path_index", appRow.getString("apppath_index"));
                        appRow.put("name", appRow.getString("systemapp"));
                        appRow.put("meta", metaObject);
                        appRow.put("component", "");
                        appRow.put("isneedpay", AccountPay.isNeedPay(this, systemappid));
                    }
                    moduleRow.put("apps", approws);
                }
                systemRow.put("modules", modulerows);
            }
            appRows.removeColumn(new String[]{"systemappname", "systemapp", "apppath", "apppath_index"});
            parameter.userauth_systemids.put(userid, systemRows);
            parameter.userauth_systemmoduleids.put(userid, moduleRows);
            parameter.userauth_systemappids.put(userid, appRows);
            parameter.userauth_optionids.put(userid, OptionRows);
            return getSucReturnObject().setData(systemRows).toString();
        } else {
            /*
            系统管理员权限获取，无需授权，返回所有功能权限
             */
            /**
             * 获取角色系统授权
             */
            SQLFactory systemsql = new SQLFactory(this, "获取系统管理员角色系统授权");
            systemsql.addParameter("systemclient", systemclient);
            Rows systemRows = dbConnect.runSqlQuery(systemsql);
            for (Row row : systemRows) {
                row.put("iconurl", getSystemIconUrl(row.getLong("systemid"), "icon"));
                row.put("iconurl_mainnav", getSystemIconUrl(row.getLong("systemid"), "mainnavicon"));
            }
            /**
             * 获取角色模块授权
             */
            SQLFactory modulesql = new SQLFactory(this, "获取系统管理员角色模块授权");
            modulesql.addParameter("systemclient", systemclient);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);
            for (Row row : moduleRows) {
                row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
                row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));
            }
            RowsMap moduleRowsMap = moduleRows.toRowsMap("systemid");

            /**
             * 获取角色应用授权
             */
            SQLFactory appsql = new SQLFactory(this, "获取系统管理员角色应用授权");
            appsql.addParameter("systemclient", systemclient);
            Rows appRows = dbConnect.runSqlQuery(appsql);
            RowsMap appRowsMap = appRows.toRowsMap("systemmoduleid");

            /**
             * 获取角色功能授权
             */
            SQLFactory optionsql = new SQLFactory(this, "获取系统管理员角色功能授权");
            optionsql.addParameter("siteid", siteid);
            Rows OptionRows = dbConnect.runSqlQuery(optionsql);
            RowsMap optionRowsMap = OptionRows.toRowsMap("systemappid");

            /**
             * 获取应用网格配置
             */
            SQLFactory gridsql = new SQLFactory(this, "获取角色应用网格配置");
            gridsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows gridrows = dbConnect.runSqlQuery(gridsql);
            RowsMap gridRowsMap = gridrows.toRowsMap("systemappid");

            /**
             * 获取应用表格配置
             */
            SQLFactory tablesql = new SQLFactory(this, "获取角色应用表格配置");
            tablesql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows tablerows = dbConnect.runSqlQuery(tablesql);
            RowsMap tableRowsMap = tablerows.toRowsMap("systemappid");

            SQLFactory tablecolsql = new SQLFactory(this, "获取角色应用表格栏位配置");
            tablecolsql.addParameter_in("tableid", tablerows.toArrayList("tableid"));
            Rows alltablecolRows = dbConnect.runSqlQuery(tablecolsql);

            RowsMap sitetablecolRowsMap = dbConnect.runSqlQuery("select tablecolid,title,width,hidden from sys_systemapp_tablecols_site where siteid='" + siteid + "'").toRowsMap("tablecolid");
            ArrayList<Row> hiddenRow = new ArrayList<>();
            for (Row tablecolRow : alltablecolRows) {
                if (sitetablecolRowsMap.containsKey(tablecolRow.getString("tablecolid"))) {
                    Rows sitecolsRows = sitetablecolRowsMap.get(tablecolRow.getString("tablecolid"));
                    if (!sitecolsRows.get(0).getString("title").equals("")) {
                        tablecolRow.put("title", sitecolsRows.get(0).getString("title"));
                    }
                    if (sitecolsRows.get(0).getInteger("width") > 0) {
                        tablecolRow.put("width", sitecolsRows.get(0).getInteger("width"));
                    }
                    if (sitecolsRows.get(0).getInteger("hidden") == 1) {
                        tablecolRow.put("hidden", 1);
                    }
                }
                if (tablecolRow.getBoolean("hidden")) {
                    hiddenRow.add(tablecolRow);
                }
            }
            for (Row row : hiddenRow) {
                alltablecolRows.remove(row);
            }
            RowsMap tablecolRowsMap = alltablecolRows.toRowsMap("tableid");

            /**
             * 获取应用小组件配置
             */
            SQLFactory wedgitsql = new SQLFactory(this, "获取角色应用小组件配置");
            wedgitsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            RowsMap wedgitRowsMap = dbConnect.runSqlQuery(wedgitsql).toRowsMap("systemappid");


            for (Row systemRow : systemRows) {
                Rows modulerows = moduleRowsMap.get(systemRow.getString("systemid"));
                for (Row moduleRow : modulerows) {
                    Rows approws = appRowsMap.get(moduleRow.getString("systemmoduleid"));
                    for (Row appRow : approws) {
                        String systemappid = appRow.getString("systemappid");

                        Rows optionRows = optionRowsMap.get(systemappid);
                        optionRows.removeColumn(new String[]{"systemappid"});

                        Rows wedgitsRows = wedgitRowsMap.get(systemappid);
                        wedgitsRows.removeColumn(new String[]{"systemappid"});

                        JSONObject gridObject = new JSONObject();
                        Rows gridRows = gridRowsMap.get(systemappid);
                        for (Row gridRow : gridRows) {
                            gridObject.put(gridRow.getString("grid"), gridRow);
                        }
                        gridRows.removeColumn(new String[]{"systemappid", "grid", "gridid"});

                        JSONObject tableObject = new JSONObject();
                        Rows tableRows = tableRowsMap.get(systemappid);
                        for (Row tableRow : tableRows) {
                            Rows tablecolRows = tablecolRowsMap.get(tableRow.getString("tableid"));
                            tablecolRows.removeColumn(new String[]{"tableid", "tablecolid"});
                            tableRow.put("tablecols", tablecolRows);
                            tableObject.put(tableRow.getString("table"), tableRow);
                        }
                        tableRows.removeColumn(new String[]{"systemappid", "table", "tableid"});

                        JSONObject metaObject = new JSONObject();
                        metaObject.put("title", appRow.getString("systemappname"));
                        metaObject.put("auth", optionRows);
                        metaObject.put("hiddenfields", new JSONArray());
                        metaObject.put("wedgits", wedgitsRows);
                        metaObject.put("grids", gridObject);
                        metaObject.put("tables", tableObject);

                        appRow.put("path", appRow.getString("apppath"));
                        appRow.put("path_index", appRow.getString("apppath_index"));
                        appRow.put("name", appRow.getString("systemapp"));
                        appRow.put("meta", metaObject);
                        appRow.put("component", "");

                        appRow.put("isneedpay", false);
                    }
                    moduleRow.put("apps", approws);
                }
                systemRow.put("modules", modulerows);
            }
            appRows.removeColumn(new String[]{"systemappname", "systemapp", "apppath", "apppath_index"});
            parameter.userauth_systemids.put(userid, systemRows);
            parameter.userauth_systemmoduleids.put(userid, moduleRows);
            parameter.userauth_systemappids.put(userid, appRows);
            parameter.userauth_optionids.put(userid, OptionRows);
            return getSucReturnObject().setData(systemRows).toString();
        }
    }

}
