package restcontroller.sysmanage.develop.hotupdate;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import restcontroller.R;
import utility.tools.Encryption;
import utility.tools.WebRequest;

import java.util.Set;

public class database_contrast extends Controller {

    /*
    数据库对比时排除不需要对比的字段
     */
    private static String[] default_exclude_fields = new String[]{"createdate", "createuserid", "createby", "changeuserid", "changeby", "changedate", "rowindex"};

    /**
     * 构造函数
     *
     * @param content
     */
    public database_contrast(JSONObject content) throws YosException {
        super(content);
    }

    public JSONArray queryDBContrast() throws YosException {
        JSONArray dataArray = new JSONArray();
        Rows sys_objects = dbConnect.runSqlQuery("select table_name,table_comment,contrast_sequence from sys_object where contrast=1 order by contrast_sequence");

        for (Row sys_object : sys_objects) {
            JSONObject dataObject = new JSONObject(true);
            String table_name = sys_object.getString("table_name");
            String table_comment = sys_object.getString("table_comment");
            int sequence = sys_object.getInteger("contrast_sequence");
            RowsMap columnsMap = getTableColumns(table_name);
            String uniquecolumnname = getuniquecolumnname("table_name");

            String sql;
            if (table_name.equalsIgnoreCase("sys_systemapp_options")) {
                sql = "select t1.*,t2.systemapp,t2.systemappname from sys_systemapp_options t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid order by optionid";
            } else if (table_name.equalsIgnoreCase("sys_systemapp_tables")) {
                sql = "select t1.*,t2.systemapp,t2.systemappname from sys_systemapp_tables t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid order by tableid";
            } else if (table_name.equalsIgnoreCase("sys_systemapp_tablecols")) {
                sql = "select t1.*,t2.table,t3.systemapp,t3.systemappname from sys_systemapp_tablecols t1 inner join sys_systemapp_tables t2 on t1.tableid=t2.tableid inner join sys_systemapp t3 on t2.systemappid=t3.systemappid order by tablecolid";
            } else if (table_name.equalsIgnoreCase("sys_systemapp_hiddenfield")) {
                sql = "select t1.*,t2.systemapp,t2.systemappname from sys_systemapp_hiddenfield t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid order by hiddenfieldid";
            } else if (table_name.equalsIgnoreCase("sys_systemapp_wedgits")) {
                sql = "select t1.*,t2.systemapp,t2.systemappname from sys_systemapp_wedgits t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid";
            } else if (columnsMap.containsKey(uniquecolumnname)) {
                sql = "select * from " + table_name + " order by " + uniquecolumnname;
            } else if (columnsMap.containsKey("createdate")) {
                sql = "select * from " + table_name + " order by createdate";
            } else if (columnsMap.containsKey("changedate")) {
                sql = "select * from " + table_name + " order by changedate";
            } else {
                sql = "select * from " + table_name;
            }

            Rows rows = dbConnect.runSqlQuery(sql);
            rows.removeColumn(default_exclude_fields);
            if (table_name.equalsIgnoreCase("sys_remind_config")) {
                for (Row row : rows) {
                    try {
                        row.put("wechatservice_content", JSONObject.parseObject(Encryption.Decode_Base64(row.getString("wechatservice_content").replace(" ", "\n"))));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            dataObject.put("table_name", table_name);
            dataObject.put("table_comment", table_comment);
            dataObject.put("sequence", sequence);
            dataObject.put("data", rows);
            dataArray.add(dataObject);
        }
        return dataArray;
    }

    @API(title = "数据库差异对比", apiversion = R.ID10012301.v1.class)
    public String DBContrast() throws YosException {
        String system_db_contrast_url = Parameter.get("system_db_contrast_url");
        String system_db_contrast_token = Parameter.get("system_db_contrast_token");
        if (system_db_contrast_url.equals("") || system_db_contrast_token.equals("")) {
            return getErrReturnObject().setErrMsg("数据库差异对比参数设置无效").toString();
        }
        JSONObject requestObject = new JSONObject();
        requestObject.put("contrast_token", system_db_contrast_token);
        WebRequest webRequest = new WebRequest();
        String result = webRequest.doPost(requestObject.toString(), system_db_contrast_url + "/dbcontrast");
        JSONArray resultArray = JSONArray.parseArray(result);

        JSONArray dbContrastArray = new JSONArray();

        //获取当前系统所有的表字段信息，用于判断表字段是否存在
        RowsMap table_columnsMap = dbConnect.runSqlQuery("select table_name,column_name from sys_objectcols").toRowsMap("table_name");

        for (Object o : resultArray) {
            JSONObject resultObject = (JSONObject) o;
            String table_name = resultObject.getString("table_name");
            String table_comment = resultObject.getString("table_comment");

            JSONObject dbContrastObject = new JSONObject();
            dbContrastObject.put("table_name", table_name);
            dbContrastObject.put("table_comment", table_comment);

            //判断当前表是否存在
            if (table_columnsMap.containsKey(table_name)) {
                JSONArray dbContrastdataArray = new JSONArray();

                JSONArray onlinedataArray = resultObject.getJSONArray("data");

                switch (table_name) {
                    case "sys_object": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"uniquecolumnmaxid", "contrast_sequence", "contrast", "sequence", "status", "issystem"};
                        String[] keyfields = new String[]{"table_name"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_objectcols": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sequence", "status"};
                        String[] keyfields = new String[]{"table_name", "column_name"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_cacheobject": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sys_cacheobjectid"};
                        String[] keyfields = new String[]{"table_name"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_cacheobjectcols": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sys_cacheobjectid", "sys_cacheobjectcolsid"};
                        String[] keyfields = new String[]{"table_name", "column_name"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_parameter": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sys_parameterid", "sequence", "paramvalue"};
                        String[] keyfields = new String[]{"paramname"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_datafunction": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sys_datafunctionid", "createdate", "isused"};
                        String[] keyfields = new String[]{"functionname"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_remind_config": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sys_remind_configid", "changeuserid"};
                        String[] keyfields = new String[]{"remindname"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_services": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"serviceid", "lastruntime", "successed", "timelong"};
                        String[] keyfields = new String[]{"classname"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_adspace": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sys_adspaceid"};
                        String[] keyfields = new String[]{"location", "systemclient"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_coderule": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sys_coderuleid"};
                        String[] keyfields = new String[]{"coderuletype"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_optiontype": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"optiontypeid"};
                        String[] keyfields = new String[]{"typename"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_systemtag": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sys_systemtagid"};
                        String[] keyfields = new String[]{"ownertable"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_system": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"sequence", "iconurl"};
                        String[] keyfields = new String[]{"systemid"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_systemclient": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"iconurl"};
                        String[] keyfields = new String[]{"systemclientid"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_systemmodule": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"iconurl", "iconurl_mainnav", "sequence"};
                        String[] keyfields = new String[]{"systemmoduleid"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_systemapp": {
                        Rows localData = dbConnect.runSqlQuery("select * from " + table_name);

                        String[] exclude_fields = new String[]{"iconurl", "sequence", "siteids", "systemappid"};
                        String[] keyfields = new String[]{"systemmoduleid", "systemapp"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_systemapp_options": {
                        Rows localData = dbConnect.runSqlQuery("select t1.*,t2.systemapp,t2.systemappname from sys_systemapp_options t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid");

                        String[] exclude_fields = new String[]{"optionid", "siteids", "systemappid"};
                        String[] keyfields = new String[]{"systemapp", "option"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_systemapp_tables": {
                        Rows localData = dbConnect.runSqlQuery("select t1.*,t2.systemapp,t2.systemappname from sys_systemapp_tables t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid");

                        String[] exclude_fields = new String[]{"tableid", "siteids", "systemappid"};
                        String[] keyfields = new String[]{"systemapp", "table"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_systemapp_tablecols": {
                        Rows localData = dbConnect.runSqlQuery("select t1.*,t2.table,t3.systemapp,t3.systemappname from sys_systemapp_tablecols t1 inner join sys_systemapp_tables t2 on t1.tableid=t2.tableid inner join sys_systemapp t3 on t2.systemappid=t3.systemappid");

                        String[] exclude_fields = new String[]{"tableid", "tablecolid"};
                        String[] keyfields = new String[]{"systemapp", "table", "columnname"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_systemapp_hiddenfield": {
                        Rows localData = dbConnect.runSqlQuery("select t1.*,t2.systemapp,t2.systemappname from sys_systemapp_hiddenfield t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid");

                        String[] exclude_fields = new String[]{"hiddenfieldid", "systemappid"};
                        String[] keyfields = new String[]{"systemapp", "field"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    case "sys_systemapp_wedgits": {
                        Rows localData = dbConnect.runSqlQuery("select t1.*,t2.systemapp,t2.systemappname from sys_systemapp_wedgits t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid");

                        String[] exclude_fields = new String[]{"wedgitid", "systemappid"};
                        String[] keyfields = new String[]{"systemapp", "wedgit"};
                        a(localData, onlinedataArray, exclude_fields, keyfields, dbContrastdataArray);
                        break;
                    }
                    default: {
                        break;
                    }
                }
                dbContrastObject.put("data", dbContrastdataArray);
            } else {
                dbContrastObject.put("status", 0);//表示本地没有此表
            }
            dbContrastArray.add(dbContrastObject);
        }
        return getSucReturnObject().setData(dbContrastArray).toString();
    }

    public void a(Rows localData, JSONArray onlinedataArray, String[] exclude_fields, String[] keyfields, JSONArray dbContrastdataArray) throws YosException {
        localData.removeColumn(default_exclude_fields);
        localData.removeColumn(exclude_fields);
        RowsMap localDataRowsMap = localData.toRowsMap(keyfields);
        /*
        循环在线数据，判断本地是否存在，存在则进行数据差异判断。不存在则标注本地数据为空
         */
        for (Object onlinedata : onlinedataArray) {
            JSONObject onlinedataObject = (JSONObject) onlinedata;

            for (String exclude_field : exclude_fields) {
                onlinedataObject.remove(exclude_field);
            }
            String keyfieldvalue = "";
            for (String keyfield : keyfields) {
                keyfieldvalue = keyfieldvalue + onlinedataObject.getString(keyfield);
            }
            JSONObject localdataObject = new JSONObject();

            boolean isdatachange = false;

            JSONObject dbContrastdataObject = new JSONObject();
            //判断本地数据是否存在，如果存在，则进行数据判断
            if (localDataRowsMap.containsKey(keyfieldvalue)) {
                Row localdataRow = localDataRowsMap.get(keyfieldvalue).get(0);
                for (String fieldname : onlinedataObject.keySet()) {
                    if (!localdataRow.getString(fieldname).equals(onlinedataObject.getString(fieldname))) {
                        isdatachange = true;
                    }
                }
                if (isdatachange) {
                    localdataObject = localdataRow.toJsonObject();
                }
            } else {
                isdatachange = true;
            }
            if (isdatachange) {
                dbContrastdataObject.put("localdata", localdataObject);
                dbContrastdataObject.put("onlinedata", onlinedataObject);
                dbContrastdataArray.add(dbContrastdataObject);
            }
            /*
            对已经判断过的数据，予以清理，剩下的就是本地存在的但是在线没有的
             */
            localDataRowsMap.remove(keyfieldvalue);
        }

        for (String key : localDataRowsMap.keySet()) {
            JSONObject dbContrastdataObject = new JSONObject();
            dbContrastdataObject.put("localdata", localDataRowsMap.get(key).get(0));
            dbContrastdataObject.put("onlinedata", new JSONObject());
            dbContrastdataArray.add(dbContrastdataObject);
        }
    }

}
