package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_usertrialperiod implements YosObject {
    @Override
    public String table_comment() {
        return "账号系统试用时间记录表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_usertrialperiodid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new DateCol("begdate", "开始日期"));
        list.add(new DateCol("enddate", "结束日期"));
        list.add(new BigIntCol("userid", "用户id"));
        list.add(new VarcharCol("siteid", "站点ID", "站点ID", 50));
        return list;
    }
}
