package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_site_paymentrules implements YosObject {
    @Override
    public String table_comment() {
        return "站点系统版本付费规则表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_site_paymentrulesid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new IntCol("licenseperiod", "许可证有效期", "许可证有效期", false, false, false, 12, 0));
        arrayList.add(new BigIntCol("sys_site_systempartitionid", "系统版本ID", "系统版本ID", false, false, false, 0));
        arrayList.add(new DecimalCol("price", "定价", "定价，按主体付费时必填", 16, 2, true, false, 0));
        arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 0));
        arrayList.add(new IntCol("usertype", "用户类型", "用户类型，按账号付费时必填", true, false, false, 0));
        arrayList.add(new LongTextCol("paymentrules", "定价规则", "定价规则,按账号付费时必填"));
        return arrayList;
    }
}
