package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_payorderitems implements YosObject {
    @Override
    public String table_comment() {
        return "账号付费订单明细";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_payorderitemsid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new DateCol("enddate", "到期日期", "到期日期", true, false, "", 0));
        arrayList.add(new DateCol("begdate", "生效日期", "生效日期", true, false, "", 0));
        arrayList.add(new BigIntCol("sys_payorderid", "账号付费订单ID", "账号付费订单ID", false, false, false, 0));
        arrayList.add(new DecimalCol("price", "单价", "单价", 16, 2, true, false, 0));
        arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 0));
        arrayList.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID", "合作企业档案ID", false, false, false, 0));
        arrayList.add(new BigIntCol("sa_agentsid", "经销商ID", "经销商ID", false, false, false, 0));
        arrayList.add(new BigIntCol("userid", "用户id", "用户id", false, false, false, 0));
        return arrayList;
    }
}
