/*
 * Decompiled with CFR 0.152.
 */
package service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.ServiceController;
import common.data.Rows;
import common.parameter.parameter;
import common.websocket.WebSocket;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HardwareMonitoring
extends ServiceController {
    public Object o;

    @Override
    public void serviceRun() {
        try {
            Rows rows = this.dbConnect.runSqlQuery("select t1.usersiteid from sys_usersite t1 inner join sys_users t2 on t1.userid=t2.userid where t2.sysadministrator=1");
            Iterator iterator = rows.toArrayList("usersiteid", new ArrayList()).iterator();
            while (iterator.hasNext()) {
                long usersiteid = (Long)iterator.next();
                if (!parameter.websocketClients.containsKey(usersiteid)) continue;
                JSONObject methodobject = new JSONObject();
                methodobject.put("class", (Object)"data");
                methodobject.put("type", (Object)"ram_monitor");
                methodobject.put("data", this.getData());
                for (WebSocket webClientSocket : parameter.websocketClients.get(usersiteid).values()) {
                    webClientSocket.sendSystemMessage(methodobject);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.o = null;
    }

    public Object getData() {
        if (this.o != null) {
            return this.o;
        }
        JSONArray jsonArray = new JSONArray();
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        if (pools != null && !pools.isEmpty()) {
            for (MemoryPoolMXBean pool : pools) {
                String name = pool.getName();
                long used = pool.getUsage().getUsed();
                long committed = pool.getUsage().getCommitted();
                long max = pool.getUsage().getMax();
                JSONObject object = new JSONObject();
                object.put("name", (Object)name);
                object.put("used", (Object)used);
                object.put("committed", (Object)committed);
                object.put("max", (Object)max);
                jsonArray.add((Object)object);
            }
        }
        this.o = jsonArray;
        return this.o;
    }
}

