/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelFactory {
    private String filename;
    private XSSFWorkbook xssfWorkbook;
    public Boolean isWrite = false;
    public static String filetype = "xlsx";

    public ExcelFactory(String filename) {
        this.filename = filename + Calendar.getInstance().getTimeInMillis();
        this.xssfWorkbook = new XSSFWorkbook();
    }

    public ExcelFactory(InputStream inputStream) throws IOException {
        this.filename = String.valueOf(Calendar.getInstance().getTimeInMillis());
        this.xssfWorkbook = new XSSFWorkbook(inputStream);
    }

    public ExcelFactory(String filename, InputStream inputStream) throws IOException {
        this.filename = filename;
        this.xssfWorkbook = new XSSFWorkbook(inputStream);
    }

    public XSSFSheet addSheet(String sheetname) {
        return this.xssfWorkbook.createSheet(sheetname);
    }

    public XSSFSheet addSheet(String sheetname, Rows datarows) {
        return this.addSheet(sheetname, datarows, new HashMap<String, String>(), new Integer[0]);
    }

    public XSSFSheet addSheet(String sheetname, Rows datarows, Integer[] columnwidths) {
        return this.addSheet(sheetname, datarows, new HashMap<String, String>(), columnwidths);
    }

    public XSSFSheet addSheet(String sheetname, Rows datarows, HashMap<String, String> titlemap) {
        return this.addSheet(sheetname, datarows, titlemap, new Integer[0]);
    }

    public XSSFSheet addSheet(String sheetname, Rows datarows, HashMap<String, String> titlemap, Integer[] columnwidths) {
        ArrayList<String> keylist = datarows.getFieldList();
        XSSFSheet sheet = this.xssfWorkbook.createSheet(sheetname);
        for (int i = 0; i < columnwidths.length && i < keylist.size(); ++i) {
            int columnwidth = columnwidths[i];
            if (columnwidth == 0) {
                sheet.autoSizeColumn(i, true);
                continue;
            }
            sheet.setColumnWidth(i, columnwidth * 1700);
        }
        XSSFRow headrow = sheet.createRow(0);
        XSSFCellStyle xssfCellStyle = this.getHeadRowStyle();
        for (int i = 0; i < keylist.size(); ++i) {
            XSSFCell xssFcell = headrow.createCell(i);
            xssFcell.setCellStyle((CellStyle)xssfCellStyle);
            String keyname = keylist.get(i);
            if (titlemap.containsKey(keyname)) {
                keyname = titlemap.get(keyname);
            }
            xssFcell.setCellValue(keyname);
        }
        for (int n = 0; n < datarows.size(); ++n) {
            Row row = datarows.get(n);
            XSSFRow datarow = sheet.createRow(n + 1);
            for (int i = 0; i < keylist.size(); ++i) {
                Class fieldclazztype = datarows.getFieldMeta(keylist.get(i)).getFieldtype();
                if (fieldclazztype == Integer.class) {
                    datarow.createCell(i).setCellValue((double)row.getInteger(keylist.get(i)).intValue());
                    continue;
                }
                if (fieldclazztype == Long.class) {
                    datarow.createCell(i).setCellValue((double)row.getLong(keylist.get(i)));
                    continue;
                }
                if (fieldclazztype == Float.class) {
                    datarow.createCell(i).setCellValue((double)row.getBigDecimal(keylist.get(i)).floatValue());
                    continue;
                }
                if (fieldclazztype == Double.class) {
                    datarow.createCell(i).setCellValue(row.getBigDecimal(keylist.get(i)).doubleValue());
                    continue;
                }
                datarow.createCell(i).setCellValue(row.getString(keylist.get(i)));
            }
        }
        return sheet;
    }

    public XSSFSheet addSheet(String sheetname, JSONArray exportFieldsArray, JSONArray dataArrays) throws YosException {
        XSSFSheet sheet = this.xssfWorkbook.createSheet(sheetname);
        XSSFRow headrow = sheet.createRow(0);
        XSSFCellStyle xssfCellStyle = this.getHeadRowStyle();
        for (int i = 0; i < exportFieldsArray.size(); ++i) {
            JSONObject exportFieldObjet = exportFieldsArray.getJSONObject(i);
            XSSFCell xssFcell = headrow.createCell(i);
            xssFcell.setCellStyle((CellStyle)xssfCellStyle);
            xssFcell.setCellValue(exportFieldObjet.getStringValue("fieldlabel"));
        }
        for (int n = 0; n < dataArrays.size(); ++n) {
            JSONObject row = (JSONObject)dataArrays.get(n);
            XSSFRow datarow = sheet.createRow(n + 1);
            for (int i = 0; i < exportFieldsArray.size(); ++i) {
                JSONObject exportFieldObjet = exportFieldsArray.getJSONObject(i);
                String fieldname = exportFieldObjet.getStringValue("fieldname");
                if (!row.containsKey(fieldname)) continue;
                Object value = row.get(fieldname);
                if (value instanceof Integer) {
                    datarow.createCell(i).setCellValue((double)((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    datarow.createCell(i).setCellValue((double)((Long)value).longValue());
                    continue;
                }
                if (value instanceof Float) {
                    datarow.createCell(i).setCellValue((double)((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    datarow.createCell(i).setCellValue(((Double)value).doubleValue());
                    continue;
                }
                if (value == null) continue;
                datarow.createCell(i).setCellValue(value.toString());
            }
        }
        return sheet;
    }

    public void write() throws IOException, YosException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(Parameter.get("system_excelexport_path") + this.filename + "." + filetype));
        this.xssfWorkbook.write((OutputStream)fileOutputStream);
        fileOutputStream.close();
        this.isWrite = true;
    }

    public String getFilename() {
        return this.filename + "." + filetype;
    }

    public String getFilepath() throws YosException {
        return Parameter.get("system_excelexport_path") + this.filename + "." + filetype;
    }

    public File getFile() throws YosException {
        return new File(Parameter.get("system_excelexport_path") + this.filename + "." + filetype);
    }

    public void deletefile() throws YosException {
        File file = new File(Parameter.get("system_excelexport_path") + this.filename + "." + filetype);
        file.delete();
    }

    public XSSFCellStyle getHeadRowStyle() {
        XSSFCellStyle xssfCellStyle = this.xssfWorkbook.createCellStyle();
        xssfCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        xssfCellStyle.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        xssfCellStyle.setAlignment(HorizontalAlignment.CENTER);
        xssfCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = this.xssfWorkbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        xssfCellStyle.setFont((Font)font);
        return xssfCellStyle;
    }

    public XSSFWorkbook getXssfWorkbook() {
        return this.xssfWorkbook;
    }

    public XSSFSheet getSheet(String sheetname) {
        return this.xssfWorkbook.getSheet(sheetname);
    }

    public XSSFSheet getSheet(int sheetindex) {
        return this.xssfWorkbook.getSheetAt(sheetindex);
    }

    public Rows getSheetRows(String sheetname, Rows rows, int index) {
        return this.getSheetRows(sheetname, rows.getFieldList(), index);
    }

    public Rows getSheetRows(int sheetindex, Rows rows, int index) {
        return this.getSheetRows(sheetindex, rows.getFieldList(), index);
    }

    public Rows getSheetRows(String sheetname, ArrayList<String> fieldlist, int rowindex) {
        int sheetindex = this.xssfWorkbook.getSheetIndex(sheetname);
        return this.getSheetRows(sheetindex, fieldlist, rowindex);
    }

    public Rows getSheetRows(int sheetindex, ArrayList<String> fieldlist, int rowindex) {
        XSSFSheet sheet = this.xssfWorkbook.getSheetAt(sheetindex);
        int rowcount = sheet.getPhysicalNumberOfRows();
        Rows rows = new Rows();
        rows.setFieldList(fieldlist);
        while (rowindex < rowcount) {
            XSSFRow xssfRow = sheet.getRow(rowindex);
            if (xssfRow != null) {
                Row row = new Row();
                int columncount = xssfRow.getLastCellNum();
                for (int n = 0; n < columncount; ++n) {
                    XSSFCell cell = xssfRow.getCell(n);
                    if (fieldlist.size() <= n) continue;
                    String fieldname = fieldlist.get(n);
                    if (cell == null) {
                        row.put(fieldname, "");
                        continue;
                    }
                    try {
                        String celltype;
                        switch (celltype = cell.getCellType().name()) {
                            case "STRING": {
                                row.put(fieldname, cell.getStringCellValue());
                                break;
                            }
                            case "NUMERIC": {
                                row.put(fieldname, cell.getNumericCellValue());
                                break;
                            }
                            default: {
                                cell.setCellType(CellType.STRING);
                                row.put(fieldname, cell.getStringCellValue());
                                break;
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        row.put(fieldname, "");
                    }
                }
                rows.add(row);
            }
            ++rowindex;
        }
        return rows;
    }

    public void close() {
        if (this.xssfWorkbook != null) {
            try {
                this.xssfWorkbook.close();
                this.xssfWorkbook = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws YosException, IOException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select *from sys_users");
        ExcelFactory excelFactory = new ExcelFactory("asdas");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userid", "ID");
        map.put("name", "\u59d3\u540d");
        map.put("password", "\u5bc6\u7801");
        map.put("createby", "\u521b\u5efa\u4eba");
        map.put("createdate", "\u521b\u5efa\u65f6\u95f4");
        map.put("sysadministrator", "\u662f\u5426\u7ba1\u7406\u5458");
        excelFactory.addSheet("nihao", rows, map, new Integer[]{1, 3, 5, 3, 3, 2, 3, 2, 2, 2, 3, 2, 2});
        excelFactory.write();
        excelFactory.close();
    }
}

