package service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.ServiceController;
import common.data.Rows;
import common.parameter.parameter;
import common.websocket.WebSocket;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;
import java.util.List;

public class HardwareMonitoring extends ServiceController {
    @Override
    public void serviceRun() {
        try {
            Rows rows = dbConnect.runSqlQuery("select t1.usersiteid from sys_usersite t1 inner join sys_users t2 on t1.userid=t2.userid where t2.sysadministrator=1");
            for (long usersiteid : rows.toArrayList("usersiteid", new ArrayList<Long>())) {
                if (parameter.websocketClients.containsKey(usersiteid)) {
                    JSONObject methodobject = new JSONObject();
                    methodobject.put("class", "data");//数据
                    methodobject.put("type", "ram_monitor");//数据分类
                    methodobject.put("data", getData());//数据实体
                    for (WebSocket webClientSocket : parameter.websocketClients.get(usersiteid).values()) {
                        webClientSocket.sendSystemMessage(methodobject);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        this.o = null;
    }

    public Object o;

    public Object getData() {
        if (o != null) {
            return o;
        }
        JSONArray jsonArray = new JSONArray();
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        if (pools != null && !pools.isEmpty()) {
            for (MemoryPoolMXBean pool : pools) {
                String name = pool.getName();
                long used = pool.getUsage().getUsed();
                long committed = pool.getUsage().getCommitted();
                long max = pool.getUsage().getMax();

                JSONObject object = new JSONObject();
                object.put("name", name);
                object.put("used", used);
                object.put("committed", committed);
                object.put("max", max);
                jsonArray.add(object);
            }
        }
        this.o = jsonArray;
        return this.o;
    }
}

