package restcontroller.system;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;

import java.util.ArrayList;

@API(title = "行政区域查询")
public class tools extends Controller {
    public tools(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "省份查询", accesstoken = false)
    @CACHEING(life = 3600)
    public String query_arealist() throws YosException {
        Rows provincerows = dbConnect.runSqlQuery("select provinceid,province from  t_province order by provinceid");
        RowsMap cityrowsMap = dbConnect.runSqlQuery("select cityid,city,provinceid from t_city order by cityid").toRowsMap("provinceid");
        RowsMap countyrowsMap = dbConnect.runSqlQuery("select countyid,county,cityid from t_county order by countyid").toRowsMap("cityid");

        JSONObject provinceObject = new JSONObject(true);
        for (Row provincerow : provincerows) {
            JSONObject cityObject = new JSONObject(true);
            for (Row cityrow : cityrowsMap.get(provincerow.getString("provinceid"))) {
                ArrayList<String> countylist = countyrowsMap.get(cityrow.getString("cityid")).toArrayList("county");
                if (countylist.isEmpty()) {
                    countylist.add("市辖区");
                }
                cityObject.put(cityrow.getString("city"), countylist);
            }
            provinceObject.put(provincerow.getString("province"), cityObject);
        }
        return getSucReturnObject().setData(provinceObject).toString();
    }

    @API(title = "前端日志记录", accesstoken = false)
    public String saveWebClientErrLog() throws YosException {
        if ("true".equals(Parameter.get("system_client_logsave"))) {
            String keyname = content.getString("keyname");
            String log = content.getString("log");
            dbConnect.runSqlUpdate("insert into sys_log(logid,type,keyname,msg,createtime) values(" + createTableID("sys_log") + ",'前端','" + keyname + "','" + log + "',now())");
        }
        return getSucReturnObject().toString();
    }
}
