package restcontroller.sysmanage.develop.remindconfig;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

@API(title = "系统提醒设置")
public class remindconfig extends Controller {
    public remindconfig(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统提醒列表查询")
    public String query_remindconfigList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_remind_config");
        for (Row row : rows) {
            row.put("remindmode", row.getJSONArray("remindmode"));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统提醒新增")
    public String insertormodifyremindconfig() throws YosException {
        long sys_remind_configid = content.getLongValue("sys_remind_configid");
        String ownertable = content.getString("ownertable");
        String remindname = content.getString("remindname");
        JSONArray remindmode = content.getJSONArray("remindmode");
        String remindtitle = content.getString("remindtitle");
        String content_str = content.getString("content", true);
        String remarks = content.getString("remarks");

        if (remindname.equals("") || !String.valueOf(remindname.charAt(0)).matches("^[a-z]*")) {
            return getErrReturnObject().setErrMsg("提醒名称必须以英文字母开头").toString();
        }
        if (!remindname.replace("_", "").matches("^[a-z0-9]*")) {
            return getErrReturnObject().setErrMsg("提醒名称为英文字母或英文数字组合").toString();
        }
        if (dbConnect.runSqlQuery("select *from sys_remind_config where remindname='" + remindname + "' and sys_remind_configid!=" + sys_remind_configid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("提醒名称不可重复").toString();
        }

        if (sys_remind_configid <= 0 && dbConnect.runSqlQuery("select *from sys_remind_config where sys_remind_configid=" + sys_remind_configid).isEmpty()) {
            SQLFactory sqlFactory = new SQLFactory(this, "系统提醒新增");
            sqlFactory.addParameter("sys_remind_configid", createTableID("sys_remind_config"));
            sqlFactory.addParameter("ownertable", ownertable);
            sqlFactory.addParameter("remindname", remindname);
            sqlFactory.addParameter("remindmode", remindmode);
            sqlFactory.addParameter("remindtitle", remindtitle);
            sqlFactory.addParameter("content", content_str);
            sqlFactory.addParameter("remarks", remarks);
            sqlFactory.addParameter("changeuserid", userid);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else {
            SQLFactory sqlFactory = new SQLFactory(this, "系统提醒修改");
            sqlFactory.addParameter("sys_remind_configid", sys_remind_configid);
            sqlFactory.addParameter("ownertable", ownertable);
            sqlFactory.addParameter("remindname", remindname);
            sqlFactory.addParameter("remindmode", remindmode);
            sqlFactory.addParameter("remindtitle", remindtitle);
            sqlFactory.addParameter("content", content_str);
            sqlFactory.addParameter("remarks", remarks);
            sqlFactory.addParameter("changeuserid", userid);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        }
        return getSucReturnObject().toString();
    }

    @API(title = "系统提醒删除")
    public String deleteremindconfig() throws YosException {
        long sys_remind_configid = content.getLong("sys_remind_configid");
        if (dbConnect.runSqlQuery("select * from sys_remind_configs where sys_remind_configid=" + sys_remind_configid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("系统提醒已被使用，不可删除！").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_remind_config where sys_remind_configid=" + sys_remind_configid);
        return getSucReturnObject().toString();
    }
}
