package restcontroller.sysmanage.develop.appregistry;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;

public class system extends Controller {
    public system(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "开发端-系统应用注册-系统列表查询")
    public String querySystemList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select systemid,`system`,systemname,isused,sequence from sys_system order by sequence");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "开发端-系统应用注册-系统信息新增修改")
    public String insertormodifySystem() throws YosException {
        if (content.getBooleanValue("isasync")) {
            long systemid = content.getLong("systemid");
            String system = content.getString("system");
            String systemname = content.getString("systemname");
            int isused = content.getIntValue("isused");
            if (dbConnect.runSqlQuery("select * from sys_system where systemid=" + systemid).isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统新增");
                sqlFactory.addParameter("systemid", systemid);
                sqlFactory.addParameter("system", system);
                sqlFactory.addParameter("systemname", systemname);
                sqlFactory.addParameter("sequence", 10);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_system set `system`='" + system + "', systemname='" + systemname + "',isused=" + isused + " where systemid=" + systemid);
            }
        } else {
            long systemid = content.getLongValue("systemid");
            int sequence = content.getIntValue("sequence");
            String systemname = content.getString("systemname");
            int isused = content.getIntValue("isused");
            dbConnect.runSqlUpdate("update sys_system set systemname='" + systemname + "',isused=" + isused + ",sequence=" + sequence + " where systemid=" + systemid);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-系统端口列表查询")
    public String querySystemClientList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select t1.`system`,t1.systemname,t2.systemclientid,t2.systemclient,t2.systemclientname from sys_system t1 inner join sys_systemclient t2 on t1.systemid=t2.systemid");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "开发端-系统应用注册-系统操作端信息新增修改")
    public String insertormodifySystemClient() throws YosException {
        if (content.getBooleanValue("isasync")) {
            long systemid = content.getLong("systemid");
            long systemclientid = content.getLong("systemclientid");
            String systemclient = content.getString("systemclient");
            String systemclientname = content.getString("systemclientname");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_system where systemid=" + systemid).isEmpty()) {
                return getErrReturnObject().setErrMsg("系统不存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_systemclient where systemclientid=" + systemclientid).isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统操作端新增");
                sqlFactory.addParameter("systemid", systemid);
                sqlFactory.addParameter("systemclientid", systemclientid);
                sqlFactory.addParameter("systemclient", systemclient);
                sqlFactory.addParameter("systemclientname", systemclientname);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_systemclient set systemid='" + systemid + "', systemclient='" + systemclient + "',systemclientname='" + systemclientname + "',isused=" + isused + " where systemclientid=" + systemclientid);
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-系统模块信息新增修改")
    public String insertormodifySystemmodule() throws YosException {
        if (content.getBooleanValue("isasync")) {
            long systemclientid = content.getLong("systemclientid");
            long systemmoduleid = content.getLong("systemmoduleid");
            String systemmodule = content.getString("systemmodule");
            String systemmodulename = content.getString("systemmodulename");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_systemclient where systemclientid=" + systemclientid).isEmpty()) {
                return getErrReturnObject().setErrMsg("操作端不存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_systemmodule where systemmoduleid=" + systemmoduleid).isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统模块新增");
                sqlFactory.addParameter("systemclientid", systemclientid);
                sqlFactory.addParameter("systemmoduleid", systemmoduleid);
                sqlFactory.addParameter("systemmodule", systemmodule);
                sqlFactory.addParameter("systemmodulename", systemmodulename);
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_systemmodule set systemclientid='" + systemclientid + "', systemmodule='" + systemmodule + "',systemmodulename='" + systemmodulename + "',isused=" + isused + " where systemmoduleid=" + systemmoduleid);
            }
        }
        return getSucReturnObject().toString();
    }
}
