package restcontroller.sysmanage.develop.apimanage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import common.parameter.parameter;
import org.reflections.Reflections;
import restcontroller.R;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;

@API(title = "管理端-开发-API接口监控")
public class ApiMonitor extends Controller {
    public ApiMonitor(JSONObject content) throws YosException {
        super(content);
    }
    /**
     * 获取注解使用情况
     */
//    @API(title = "接口信息查询")
//    public String getAPIMsg() throws YosException {
//        SQLiteTable apiclassTable = SQLiteTable.getTable("apiclass");
//        if (apiclassTable.dosNotExist()) {
//            apiclassTable.addColumn("classname", SQLiteTable.FieldType.VARCHAR);
//            apiclassTable.addColumn("title", SQLiteTable.FieldType.VARCHAR);
//            apiclassTable.addColumn("notes", SQLiteTable.FieldType.VARCHAR);
//            apiclassTable.create();
//        }
//        SQLiteTable apimethodTable = SQLiteTable.getTable("apimethod");
//        if (apimethodTable.dosNotExist()) {
//            apimethodTable.addColumn("classname", SQLiteTable.FieldType.VARCHAR);
//            apimethodTable.addColumn("method", SQLiteTable.FieldType.VARCHAR);
//            apimethodTable.addColumn("title", SQLiteTable.FieldType.VARCHAR);
//            apimethodTable.addColumn("notes", SQLiteTable.FieldType.VARCHAR);
//            apimethodTable.addColumn("cacheinglife", SQLiteTable.FieldType.INT);
//            apimethodTable.addColumn("iscacheing", SQLiteTable.FieldType.INT);
//            apimethodTable.addColumn("iscacheingclean", SQLiteTable.FieldType.INT);
//            apimethodTable.addColumn("cleandatas", SQLiteTable.FieldType.VARCHAR);
//            apimethodTable.addColumn("intervaltime", SQLiteTable.FieldType.INT);
//            apimethodTable.addColumn("accesstoken", SQLiteTable.FieldType.INT);
//            apimethodTable.create();
//        }
//        if (isfirst) {
//
//
//            /**
//             * 开始获取接口类及方法信息
//             */
//            ArrayList<String> SQLlist = new ArrayList<>();
//
//            Reflections reflections = new Reflections("restcontroller");
//            Set<Class<? extends Controller>> subTypes = reflections.getSubTypesOf(Controller.class);
//            for (Class<? extends Controller> clazz : subTypes) {
//                String classname = clazz.getName().replace("restcontroller.", "");
//                String classtitle = "";//标题
//                String classnotes = "";//描述
//                boolean isapiclass = false;
//
//                /**
//                 * 获取类信息
//                 */
//                if (clazz.isAnnotationPresent(API.class)) {
//                    API classapi = clazz.getAnnotation(API.class);
//                    classtitle = classapi.title();
//                    classnotes = classapi.notes();
//                }
//
//                /**
//                 * 获取类的方法信息
//                 */
//                Method[] methods = clazz.getDeclaredMethods();
//                for (Method method : methods) {
//                    if (method.isAnnotationPresent(API.class)) {
//                        boolean iscacheing = method.isAnnotationPresent(CACHEING.class);
//                        int cacheinglife = iscacheing ? method.getAnnotation(CACHEING.class).life() : 0;
//                        boolean iscacheingclean = method.isAnnotationPresent(CACHEING_CLEAN.class);
//
//                        JSONArray cacheingcleanArray = new JSONArray();
//                        if (iscacheingclean) {
//                            cm[] cms = method.getAnnotation(CACHEING_CLEAN.class).cms();
//                            for (cm cm : cms) {
//                                String[] mds = cm.method();
//                                for (String md : mds) {
//                                    try {
//                                        Method m = cm.clazz().getMethod(md);
//                                        if (m.isAnnotationPresent(API.class)) {
//                                            API a = m.getAnnotation(API.class);
//                                            JSONObject cacheingcleanObject = new JSONObject(true);
//                                            cacheingcleanObject.put("classname", cm.clazz().getName().replace("restcontroller.", ""));
//                                            cacheingcleanObject.put("method", m.getName());
//                                            cacheingcleanObject.put("title", a.title());
//                                            cacheingcleanObject.put("notes", a.notes());
//                                            cacheingcleanArray.add(cacheingcleanObject);
//                                        }
//                                    } catch (Exception e) {
//                                        e.printStackTrace();
//                                    }
//                                }
//                            }
//                        }
//                        API methdapi = method.getAnnotation(API.class);
//                        SQLlist.add("insert into apimethod(classname,method,title,notes,cacheinglife,iscacheing,iscacheingclean,cleandatas,intervaltime,accesstoken) values ('" + classname + "','" + method.getName() + "','" + methdapi.title() + "','" + methdapi.notes() + "','" + cacheinglife + "','" + (iscacheing ? 1 : 0) + "','" + (iscacheingclean ? 1 : 0) + "','" + cacheingcleanArray.toJSONString() + "','" + methdapi.intervaltime() + "','" + (methdapi.accesstoken() ? "1" : "0") + "');");
//                        isapiclass = true;
//                    }
//                }
//                if (isapiclass) {
//                    SQLlist.add("insert into apiclass(classname,title,notes) values ('" + classname + "','" + classtitle + "','" + classnotes + "' );");
//                }
//            }
//            SQLiteMemory.runSqlUpdate(SQLlist);
//            isfirst = false;
//        }
//        Rows classrows = SQLiteMemory.runSqlQuery("select classname,title,notes from apiclass order by classname");
//        for (Row classrow : classrows) {
//            String classname = classrow.getString("classname");
//            Rows methodrows = SQLiteMemory.runSqlQuery("select method,title,notes,cacheinglife,iscacheing,iscacheingclean,cleandatas,intervaltime,accesstoken from apimethod where classname='" + classname + "' order by method");
//
//            for (Row methodrow : methodrows) {
//                String key = "restcontroller." + classname + "." + methodrow.getString("method");
//                JSONObject requestmsg = new JSONObject(true);
//                requestmsg.put("requesttimes", parameter.callmethodTimes.getOrDefault(key, 0L));//请求次数
//                requestmsg.put("readcachetimes", parameter.callmethod_fromcacheTimes.getOrDefault(key, 0L));//缓存读取次数
//                if (parameter.lastcallmethodtime.containsKey(key)) {
//                    requestmsg.put("lastrequesttime", getDateTime_Str(parameter.lastcallmethodtime.get(key)));//最新请求时间
//                } else {
//                    requestmsg.put("lastrequesttime", "");//最新请求时间
//                }
//                requestmsg.put("requesttimelong_last", parameter.callmethodLastTimeLong.getOrDefault(key, 0L));//最新请求时长
//                requestmsg.put("requesttimelong_avg", parameter.callmethodTimeLong.getOrDefault(key, 0L));//请求平均时长
//                methodrow.put("requestmsg", requestmsg);
//                methodrow.put("cleandatas", JSON.parseArray(methodrow.getString("cleandatas")));
//            }
//            classrow.put("methods", methodrows);
//        }
//        return getSucReturnObject().setData(classrows).toString();
//    }

    /**
     * 获取注解使用情况
     */
    @API(title = "接口信息查询")
    @CACHEING(life = 1)
    public String queryApiList() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.classname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.method like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.apiid ='").append(whereObject.getString("condition")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("iscacheing") && !"".equals(whereObject.getString("iscacheing"))) {
                where.append(" and(");
                where.append("t2.iscacheing ='").append(whereObject.getString("iscacheing")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("accesstoken") && !"".equals(whereObject.getString("accesstoken"))) {
                where.append(" and(");
                where.append("t2.accesstoken ='").append(whereObject.getString("accesstoken")).append("' ");
                where.append(")");
            }
        }

        Rows methodrows = null;
        if (content.getBooleanValue("simple")) {
            if (content.getBooleanValue("apiwithid")) {
                methodrows = SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where t2.apiid!='' and " + where + " order by t1.classname,t2.method");
            } else {
                methodrows = SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where" + where + " order by t1.classname,t2.method");
            }
        } else {
            Rows methodrows_count = SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife," +
                    "t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 " +
                    "inner join apimethod t2 on t1.classname=t2.classname where" + where);
            for (Row row : methodrows_count) {
                String key = "restcontroller." + row.getString("classname") + "." + row.getString("method");
                long requesttimes = parameter.callmethodTimes.getOrDefault(key, 0L);
                String lastrequesttime = "";
                if (parameter.lastcallmethodtime.containsKey(key)) {
                    lastrequesttime = getDateTime_Str(parameter.lastcallmethodtime.get(key));
                }
                long requesttimelong_avg = parameter.callmethodTimeLong.getOrDefault(key, 0L);
                SQLiteMemory.runSqlUpdate("update apimethod set requesttimes=" + requesttimes + ",lastrequesttime='" + lastrequesttime + "',requesttimelong_avg=" + requesttimelong_avg + " where  classname='" + row.getString("classname") + "' and method='" + row.getString("method") + "'");
            }
            pageSorting = pageSorting.equals("''") ? "t1.classname,t2.method" : pageSorting;

            methodrows = SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife," +
                    "t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated,t2.requesttimes,t2.lastrequesttime,t2.requesttimelong_avg from apiclass t1 " +
                    "inner join apimethod t2 on t1.classname=t2.classname where" + where + " order by " + pageSorting + " LIMIT " + pageSize + " OFFSET " + pageSize * (pageNumber - 1));
            methodrows.totalPage = new Double(Math.ceil((double) methodrows_count.size() / (double) pageSize)).longValue();//总页数
            methodrows.totalRows = methodrows_count.size();//总行数
            for (Row methodrow : methodrows) {
                String key = "restcontroller." + methodrow.getString("classname") + "." + methodrow.getString("method");
                JSONObject requestmsg = new JSONObject(true);
                requestmsg.put("requesttimes", parameter.callmethodTimes.getOrDefault(key, 0L));//请求次数
                requestmsg.put("readcachetimes", parameter.callmethod_fromcacheTimes.getOrDefault(key, 0L));//缓存读取次数
                if (parameter.lastcallmethodtime.containsKey(key)) {
                    requestmsg.put("lastrequesttime", getDateTime_Str(parameter.lastcallmethodtime.get(key)));//最新请求时间
                    // requestmsg.put("lastrequesttime_Long", parameter.lastcallmethodtime.get(key).getTime() - systemruntime);//最新请求时间
                } else {
                    requestmsg.put("lastrequesttime", "");//最新请求时间
                    //requestmsg.put("lastrequesttime_Long", 0);//最新请求时间
                }
                requestmsg.put("requesttimelong_last", parameter.callmethodLastTimeLong.getOrDefault(key, 0L));//最新请求时长
                requestmsg.put("requesttimelong_avg", parameter.callmethodTimeLong.getOrDefault(key, 0L));//请求平均时长
                methodrow.put("requestmsg", requestmsg);
                methodrow.put("cleandatas", JSON.parseArray(methodrow.getString("cleandatas")));
            }
        }

        Rows approws = dbConnect.runSqlQuery("select t1.apiid,t1.apiversion,t2.systemappname from sys_apiapps t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid");
        RowsMap appidrowsMap = approws.toRowsMap("apiid");

        HashMap<String, String> codermap = getOptionType("coder");
        for (Row row : methodrows) {
            row.put("apps", new JSONArray());
            String apiid = row.getString("apiid");
            String apiversion = row.getString("apiversion");
            if (appidrowsMap.containsKey(apiid)) {
                RowsMap apiversionMap = appidrowsMap.get(apiid).toRowsMap("apiversion");
                if (apiversionMap.containsKey(apiversion)) {
                    row.put("apps", apiversionMap.get(apiversion).toJsonArray("systemappname"));
                }
            }
            if (apiid != null && !apiid.equals("")) {
                row.put("coder", codermap.getOrDefault(apiid.substring(apiid.length() - 2), ""));
            } else {
                row.put("coder", "");
            }
        }
        return getSucReturnObject().setData(methodrows).toString();
    }

    /**
     * 查询接口请求日志
     *
     * @return
     * @throws YosException
     */
    @API(title = "接口请求日志查询")
    public String queryApiRequestLog() throws YosException {
        String classname = content.getString("classname");
        classname = classname.replace("restcontroller.", "");
        String method = content.getString("method");
        SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestlog");
        if (!sqLiteTable.dosNotExist()) {
            Rows rows = SQLiteMemory.runSqlQuery("select requestlogid,createdate,request,usermsg,iscacheing from apirequestlog where classname='" + classname + "' and method='" + method + "' order by createdate desc");
            for (Row row : rows) {
                row.put("request", JSONObject.parseObject(row.getString("request")));
                row.put("usermsg", JSONObject.parseObject(row.getString("usermsg")));
            }
            return getSucReturnObject().setData(rows).toString();
        }
        return getSucReturnObject().setData(new Rows()).toString();
    }

    /**
     * 查询接口请求日志
     *
     * @return
     * @throws YosException
     */
    @API(title = "接口请求SQL日志查询")
    public String queryApiRequestSQLLog() throws YosException {
        String requestlogid = content.getString("requestlogid");
        SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestsqllog");
        if (!sqLiteTable.dosNotExist()) {
            Rows rows = SQLiteMemory.runSqlQuery("select sql,runtime,success,errmsg from apirequestsqllog where requestlogid='" + requestlogid + "' order by createtimeinmillis");
            return getSucReturnObject().setData(rows).toString();
        }
        return getSucReturnObject().setData(new Rows()).toString();
    }
}
