package restcontroller.sysmanage.develop.adspace;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;

@API(title = "广告位管理")
public class adspace extends Controller {
    public adspace(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "广告位查询")
    public String query_adspacelist() throws YosException {
        SQLFactory adspaceSQL = new SQLFactory(this, "广告位查询");
        Rows adspacerows = dbConnect.runSqlQuery(adspaceSQL.getSQL());
        return getSucReturnObject().setData(adspacerows).toString();
    }

    @API(title = "广告位新增修改")
    public String insertormodify_adspace() throws YosException {
        long sys_adspaceid = content.getLongValue("sys_adspaceid");//新增时传0
        String systemclient = content.getString("systemclient");
        String dimensional = content.getString("dimensional");
        int isused = content.getInteger("isused");
        String location = content.getString("location");
        String notes = content.getString("notes");
        if (content.getBooleanValue("isasync")) {
            Rows sys_adspaceRows = dbConnect.runSqlQuery("select *from sys_adspace where systemclient='" + systemclient + "' and location='" + location + "'");
            if (sys_adspaceRows.isEmpty()) {
                sys_adspaceid = createTableID("sys_adspace");
                SQLFactory adspaceinsertSQl = new SQLFactory(this, "广告位插入");
                adspaceinsertSQl.addParameter("sys_adspaceid", sys_adspaceid);
                adspaceinsertSQl.addParameter("systemclient", systemclient);
                adspaceinsertSQl.addParameter("dimensional", dimensional);
                adspaceinsertSQl.addParameter("isused", isused);
                adspaceinsertSQl.addParameter("location", location);
                adspaceinsertSQl.addParameter("notes", notes);
                dbConnect.runSqlUpdate(adspaceinsertSQl.getSQL());
            } else {
                sys_adspaceid = sys_adspaceRows.get(0).getLong("sys_adspaceid");
                SQLFactory adspaceupdateSQl = new SQLFactory(this, "广告位修改");
                adspaceupdateSQl.addParameter("sys_adspaceid", sys_adspaceid);
                adspaceupdateSQl.addParameter("dimensional", dimensional);
                adspaceupdateSQl.addParameter("isused", isused);
                adspaceupdateSQl.addParameter("location", location);
                adspaceupdateSQl.addParameter("notes", notes);
                dbConnect.runSqlUpdate(adspaceupdateSQl.getSQL());
            }
            return getSucReturnObject().toString();
        } else {
            if (sys_adspaceid <= 0 || dbConnect.runSqlQuery("select *from sys_adspace where sys_adspaceid=" + sys_adspaceid).isEmpty()) {
                if (dbConnect.runSqlQuery("select *from sys_adspace where systemclient='" + systemclient + "' and dimensional='" + dimensional + "' and location='" + location + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("同一操作端广告位不可重复").toString();
                }
                SQLFactory adspaceinsertSQl = new SQLFactory(this, "广告位插入");
                adspaceinsertSQl.addParameter("sys_adspaceid", createTableID("sys_adspace"));
                adspaceinsertSQl.addParameter("systemclient", systemclient);
                adspaceinsertSQl.addParameter("dimensional", dimensional);
                adspaceinsertSQl.addParameter("isused", isused);
                adspaceinsertSQl.addParameter("location", location);
                adspaceinsertSQl.addParameter("notes", notes);
                dbConnect.runSqlUpdate(adspaceinsertSQl.getSQL());
            } else {
                if (dbConnect.runSqlQuery("select *from sys_adspace where sys_adspaceid!='" + sys_adspaceid + "' and systemclient='" + systemclient + "' and dimensional='" + dimensional + "' and location='" + location + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("同一操作端广告位不可重复").toString();
                }
                SQLFactory adspaceupdateSQl = new SQLFactory(this, "广告位修改");
                adspaceupdateSQl.addParameter("sys_adspaceid", sys_adspaceid);
                adspaceupdateSQl.addParameter("dimensional", dimensional);
                adspaceupdateSQl.addParameter("isused", isused);
                adspaceupdateSQl.addParameter("location", location);
                adspaceupdateSQl.addParameter("notes", notes);
                dbConnect.runSqlUpdate(adspaceupdateSQl.getSQL());
            }
            return getSucReturnObject().toString();
        }
    }

    @API(title = "广告位删除")
    public String delete_adspace() throws YosException {
        long sys_adspaceid = content.getLong("sys_adspaceid");
        if (dbConnect.runSqlQuery("select * from sys_ad where sys_adspaceid=" + sys_adspaceid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("广告位已被使用，不可删除！").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_adspace where sys_adspaceid=" + sys_adspaceid);
        return getSucReturnObject().toString();
    }
}
