package common.data;

import common.YosException;
import common.data.db.DBConnect;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class SimpleInsert {
    private String tablename;
    /**
     * SQL参数Map
     */
    HashMap<String, Object> parametermap;

    protected SimpleInsert(String tablename) {
        this.tablename = tablename;
    }

    /**
     * 为SQL实例添加文本类型参数值
     *
     * @param key
     * @param value
     */
    public void addValueField(String key, Object value) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap<>();
        }
        this.parametermap.put(key, value);
    }

    /**
     * 为SQL实例添加文本类型参数值
     *
     * @param key
     * @param value
     */
    public void addValueField(String key, StringBuffer value) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap<>();
        }
        this.parametermap.put(key, value.toString());
    }

    /**
     * 为SQL实例添加int类型的参数值，
     *
     * @param key
     * @param value
     */
    public void addValueField(String key, boolean value) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap<>();
        }
        this.parametermap.put(key, value ? 1 : 0);
    }

    /**
     * 为SQL实例添加int类型的参数值，
     *
     * @param key
     */
    public void addDateField(String key) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap<>();
        }
        this.parametermap.put(key, Date.class);
    }

    ArrayList<String> wherelist = new ArrayList<>();

    public void addWhere(String where) {
        wherelist.add(where);
    }

    public String getSQL() throws YosException {
        StringBuffer headsql = new StringBuffer("insert into ").append(tablename).append("(");
        StringBuffer valuesql = new StringBuffer("select ");
        boolean isfirstfield = true;
        for (String fieldname : this.parametermap.keySet()) {
            Object value = this.parametermap.get(fieldname);
            if (value == null || "null".equalsIgnoreCase(value.toString())) {
                headsql.append(isfirstfield ? "" : ",").append(fieldname);
                valuesql.append(isfirstfield ? "" : ",").append("NULL");
            } else {
                headsql.append(isfirstfield ? "" : ",").append(fieldname);
                if (value == Date.class) {
                    valuesql.append(isfirstfield ? "" : ",now()");
                } else {
                    valuesql.append(isfirstfield ? "" : ",").append("'").append(value).append("'");
                }
            }
            isfirstfield = false;
        }
        headsql.append(")\r\n").append(valuesql);
        if (!wherelist.isEmpty()) {
            headsql.append("\r\nwhere ");
            boolean isfirstwhere = true;
            for (String where : wherelist) {
                headsql.append(isfirstwhere ? "(" : " and (").append(where).append(")");
                isfirstwhere = false;
            }
        }
        return headsql.toString();
    }

    public void run(DBConnect dbConnect) throws YosException {
        dbConnect.runSqlUpdate(getSQL());
    }
}
