package utility.sms;

import beans.parameter.Parameter;
import common.data.InsertSQL;
import utility.tools.MessageMonitoringStation;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.data.SQLFactory;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;

public class Sms extends BaseClass {

    /**
     * 短信发送
     *
     * @param phonenumber 手机号
     * @param msg         消息内容
     */
    public void sendout(String phonenumber, String msg) throws YosException {
        sendout("", phonenumber, msg);
    }

    /**
     * 短信发送
     *
     * @param phonenumber 手机号
     * @param smsmodel    消息模版
     * @param parameters  消息模版参数
     */
    public void sendout(String phonenumber, String smsmodel, String[] parameters) throws YosException {
        for (String parameter : parameters) {
            smsmodel = smsmodel.replaceFirst("\\{s}", parameter);
        }
        sendout("", phonenumber, smsmodel);
    }

    /**
     * 短信发送
     *
     * @param siteid      站点
     * @param phonenumber 手机号
     * @param smsmodel    消息模版
     * @param parameters  消息模版参数
     */
    public void sendout(String siteid, String phonenumber, String smsmodel, String[] parameters) throws YosException {
        for (String parameter : parameters) {
            smsmodel = smsmodel.replaceFirst("\\{s}", parameter);
        }
        sendout(siteid, phonenumber, smsmodel);
    }

    /**
     * 短信发送
     *
     * @param phonenumber
     * @param content
     */
    public void sendout(String siteid, String phonenumber, String content) throws YosException {
        if (!Parameter.get("system_sms_switch").equalsIgnoreCase("true")) {
            return;
        }
        HashMap<String, String> map = new HashMap();
        map.put("account", Parameter.get("chuanglan_sms_account"));//API账号
        map.put("password", Parameter.get("chuanglan_sms_password"));//API密码
        map.put("msg", content);//短信内容
        map.put("phone", phonenumber);//手机号
        map.put("report", Parameter.get("chuanglan_sms_report"));//是否需要状态报告
        map.put("extend", "");//自定义扩展码
        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(map);
        String result = sendSmsByPost("https://smssh1.253.com/msg/send/json", jsonObject.toString());
        try {
            JSONObject object = JSONObject.parseObject(result);
            switch (object.getStringValue("code")) {
                case "109": {
                    MessageMonitoringStation.send("创蓝短信（无发送额度）");
                    break;
                }
                case "118": {
                    MessageMonitoringStation.send("创蓝短信（用户没有相应的发送权限）");
                    break;
                }
                case "119": {
                    MessageMonitoringStation.send("创蓝短信（用户已过期）");
                    break;
                }
                case "120": {
                    MessageMonitoringStation.send("创蓝短信（违反防盗用策略(日发送限制)）");
                    break;
                }
                case "134": {
                    MessageMonitoringStation.send("创蓝短信（违反防盗策略, 超过月发送限制）");
                    break;
                }
                default:
                    break;
            }
        } catch (Exception e) {
        }

        InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_smssendlog");
        insertSQL.setValue("siteid", siteid);
        insertSQL.setValue("phonenumber", phonenumber);
        insertSQL.setValue("content", content);
        insertSQL.insert();

        int HOUR_OF_DAY = Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
        if (hour != HOUR_OF_DAY && HOUR_OF_DAY >= 8) {
            try {
                JSONObject object = JSONObject.parseObject(queryBalance());
                int smslimitcount = 100;
                if (object.getIntValue("balance") < smslimitcount) {
                    MessageMonitoringStation.send("创蓝短信（剩余可用条数少于" + smslimitcount + "条）");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            hour = HOUR_OF_DAY;
        }
    }

    private static int hour = 0;

    /**
     * 查询余额
     *
     * @return
     */
    public String queryBalance() throws YosException {
        HashMap<String, String> map1 = new HashMap();
        map1.put("account", Parameter.get("chuanglan_sms_account"));
        map1.put("password", Parameter.get("chuanglan_sms_password"));
        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(map1);
        return sendSmsByPost("http://smssh1.253.com/msg/balance/json", jsonObject.toString());
    }

    public String sendSmsByPost(String url, String postContent) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection) (new URL(url)).openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.connect();
            OutputStream os = httpURLConnection.getOutputStream();
            os.write(postContent.getBytes(StandardCharsets.UTF_8));
            os.flush();
            StringBuilder sb = new StringBuilder();
            int httpRspCode = httpURLConnection.getResponseCode();
            if (httpRspCode == HttpURLConnection.HTTP_OK) {
                BufferedReader br = new BufferedReader(
                        new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                return sb.toString();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
