/*
 * Decompiled with CFR 0.152.
 */
package utility.wechat;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.util.Calendar;
import java.util.HashMap;
import utility.tools.WebRequest;
import utility.wechat.miniprogram.WechatUserID;

public class WechatService {
    private static HashMap<String, String> access_tokenMap = new HashMap();
    private static HashMap<String, Long> access_token_timelimitMap = new HashMap();
    String appid;
    String secret;
    String systemclient;

    public WechatService(String systemclient) throws YosException {
        Rows rows = new DBConnect().runSqlQuery("select appid,secret from sys_wechatapp where systemclient='" + systemclient + "'");
        if (rows.isNotEmpty()) {
            this.appid = rows.get(0).getString("appid");
            this.secret = rows.get(0).getString("secret");
        }
        this.systemclient = systemclient;
    }

    private String getAccessToken() throws YosException {
        long nowtime = Calendar.getInstance().getTimeInMillis();
        if (!access_tokenMap.containsKey(this.systemclient) || access_tokenMap.get(this.systemclient).equals("") || !access_token_timelimitMap.containsKey(this.systemclient) || access_token_timelimitMap.get(this.systemclient) < nowtime) {
            String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.appid + "&secret=" + this.secret;
            String res = new WebRequest().doGet(url);
            JSONObject resobject = JSONObject.parseObject((String)res);
            if (resobject.containsKey("access_token")) {
                access_tokenMap.put(this.systemclient, resobject.getString("access_token"));
                access_token_timelimitMap.put(this.systemclient, nowtime + (long)(1000 * resobject.getIntValue("expires_in")));
            } else {
                access_tokenMap.put(this.systemclient, "");
            }
        }
        return access_tokenMap.get(this.systemclient);
    }

    public JSONArray getTemplate_List() throws YosException {
        String url = "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=" + this.getAccessToken();
        String result = new WebRequest().doGet(url);
        JSONObject object = JSONObject.parseObject((String)result);
        if (object.getStringValue("errcode").equals("40001")) {
            access_token_timelimitMap.remove(this.systemclient);
        }
        if (object.containsKey("template_list")) {
            return object.getJSONArray("template_list");
        }
        return new JSONArray();
    }

    public void send(long userid, String template_id, String client_msg_id, String tourl, HashMap<String, String> datamap, String tominiprogram_appid, String tominiprogram_pagepath) throws YosException {
        Rows rows = new DBConnect().runSqlQuery("select openid from sys_wechatapp_openids where systemclient='" + this.systemclient + "' and userid=" + userid);
        for (Row row : rows) {
            JSONObject object = new JSONObject();
            object.put("touser", (Object)row.getString("openid"));
            object.put("template_id", (Object)template_id);
            if (!tourl.equals("")) {
                object.put("tourl", (Object)tourl);
            }
            if (!tominiprogram_appid.equals("") && !tominiprogram_pagepath.equals("")) {
                JSONObject miniprogramObject = new JSONObject();
                miniprogramObject.put("appid", (Object)tominiprogram_appid);
                miniprogramObject.put("pagepath", (Object)tominiprogram_pagepath);
                object.put("miniprogram", (Object)miniprogramObject);
            }
            object.put("client_msg_id", (Object)client_msg_id);
            JSONObject dataobject = new JSONObject();
            for (String keyword : datamap.keySet()) {
                JSONObject keyObject = new JSONObject();
                keyObject.put("value", (Object)datamap.get(keyword));
                dataobject.put(keyword, (Object)keyObject);
            }
            object.put("data", (Object)dataobject);
            String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + this.getAccessToken();
            new WebRequest().doPost(object.toString(), url);
        }
    }

    public WechatUserID getWechatUserID(String wechat_code) throws YosException {
        WechatUserID wechatUserID = new WechatUserID();
        WebRequest request = new WebRequest();
        String result = request.doGet("https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + this.appid + "&secret=" + this.secret + "&code=" + wechat_code + "&grant_type=authorization_code");
        JSONObject openidobject = JSONObject.parseObject((String)result);
        wechatUserID.setSucc(openidobject.containsKey("openid"));
        if (openidobject.containsKey("openid")) {
            wechatUserID.setOpenid(openidobject.getString("openid"));
            String result2 = request.doGet("https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + this.getAccessToken() + "&openid=" + openidobject.getString("openid") + "&lang=zh_CN");
            JSONObject unionidobject = JSONObject.parseObject((String)result2);
            if (unionidobject.containsKey("unionid")) {
                wechatUserID.setUnionid(unionidobject.getString("unionid"));
            }
        }
        wechatUserID.setResult(result);
        return wechatUserID;
    }
}

