/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.sysmanage.develop.dataimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.ExcelFactory;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import common.data.db.SQLiteTableData;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@API(title="\u6570\u636e\u5bfc\u5165")
public class dataimport
extends Controller {
    public dataimport(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u6570\u636e\u5bfc\u5165\u5217\u8868\u67e5\u8be2")
    public String querydataimport() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (this.content.containsKey("where")) {
            JSONObject whereObject = this.content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.table_name like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.table_comment like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.remarks like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("siteid") && !"".equals(whereObject.getString("siteid"))) {
                where.append(" and(");
                where.append("t1.siteid ='").append(whereObject.getString("siteid")).append("'");
                where.append(")");
            }
        }
        Rows rows = this.dbConnect.runSqlQuery("select t1.sys_dataimportid,t1.siteid,t1.table_name,t2.table_comment,t1.remarks,t1.uniquecolumnname,t1.autouniqueid,t1.importmode,t1.status,t1.changeuserid,t1.type,t1.sequence from sys_dataimport t1 inner join sys_object t2 on t1.table_name=t2.table_name where " + where + " order by t1.sequence");
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="\u6570\u636e\u5bfc\u5165\u8be6\u60c5\u67e5\u8be2")
    public String querydataimportmx() throws YosException {
        long sys_dataimportid = this.content.getLong("sys_dataimportid");
        boolean isautomapping = this.content.getBooleanValue("isautomapping");
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            JSONArray table_columnArray = row.getJSONArray("table_column");
            Rows objectcolRows = this.dbConnect.runSqlQuery("select column_name,column_title,column_type,numeric_precision,numeric_scale,is_nullable,column_default from sys_objectcols where table_name='" + table_name + "' order by sequence");
            for (Row objectcolRow : objectcolRows) {
                objectcolRow.put((Object)"mapping", (Object)"");
                objectcolRow.put((Object)"linkmapping", (Object)new JSONObject());
                objectcolRow.put((Object)"isuniquecolumn", (Object)this.getuniquecolumnname(table_name).equalsIgnoreCase(objectcolRow.getString("column_name")));
                if (isautomapping) {
                    if (!objectcolRow.getBoolean("isuniquecolumn").booleanValue()) {
                        objectcolRow.put((Object)"mapping", (Object)objectcolRow.getString("column_title"));
                    }
                } else {
                    for (Object o : table_columnArray) {
                        JSONObject table_columnObject = (JSONObject)o;
                        if (!objectcolRow.getString("column_name").equalsIgnoreCase(table_columnObject.getString("column_name"))) continue;
                        objectcolRow.put((Object)"mapping", (Object)table_columnObject.getStringValue("mapping"));
                        objectcolRow.put((Object)"linkmapping", (Object)table_columnObject.getJSONObject("linkmapping"));
                        objectcolRow.put((Object)"keyfield", (Object)table_columnObject.getIntValue("keyfield"));
                    }
                }
                objectcolRow.put((Object)"keyfield", (Object)(objectcolRow.getString("column_name").equalsIgnoreCase("siteid") || objectcolRow.getBoolean("keyfield") != false ? 1 : 0));
            }
            Rows sys_objectRows = this.dbConnect.runSqlQuery("select table_comment from sys_object where table_name='" + row.getString("table_name") + "'");
            row.put((Object)"table_column", (Object)objectcolRows.toJsonArray());
            row.put((Object)"table_comment", (Object)sys_objectRows.get(0).getString("table_comment"));
            if (!isautomapping) continue;
            this.dbConnect.runSqlUpdate("update sys_dataimport set table_column='" + objectcolRows.toJsonArray() + "',changeuserid=" + this.userid + " where sys_dataimportid=" + sys_dataimportid);
        }
        Row row = rows.get(0);
        JSONArray pageArray = new JSONArray();
        JSONArray datarows = row.getJSONArray("datarows");
        for (int i = (this.pageNumber - 1) * this.pageSize; i < this.pageNumber * this.pageSize && i < datarows.size(); ++i) {
            pageArray.add(datarows.get(i));
        }
        row.put((Object)"datarows", (Object)pageArray);
        JSONObject datarowspagemsg = new JSONObject();
        datarowspagemsg.put("pageNumber", (Object)this.pageNumber);
        datarowspagemsg.put("pageSize", (Object)this.pageSize);
        datarowspagemsg.put("total", (Object)datarows.size());
        datarowspagemsg.put("pageTotal", (Object)new Double(Math.ceil((double)datarows.size() / (double)this.pageSize)).longValue());
        row.put((Object)"datarowspagemsg", (Object)datarowspagemsg);
        int errpageNumber = this.content.getIntValue("errpageNumber", 1);
        int errpageSize = this.content.getIntValue("errpageSize", 20);
        JSONArray pageArray2 = new JSONArray();
        JSONArray errdatarows = row.getJSONArray("errdatarows");
        for (int i = (errpageNumber - 1) * errpageSize; i < errpageNumber * errpageSize && i < errdatarows.size(); ++i) {
            pageArray2.add(errdatarows.get(i));
        }
        row.put((Object)"errdatarows", (Object)pageArray2);
        JSONObject datarowspagemsg2 = new JSONObject();
        datarowspagemsg2.put("pageNumber", (Object)errpageNumber);
        datarowspagemsg2.put("pageSize", (Object)errpageSize);
        datarowspagemsg2.put("total", (Object)errdatarows.size());
        datarowspagemsg2.put("pageTotal", (Object)new Double(Math.ceil((double)errdatarows.size() / (double)errpageSize)).longValue());
        row.put((Object)"errdatarowspagemsg", (Object)datarowspagemsg2);
        return this.getSucReturnObject().setData(row).toString();
    }

    @API(title="\u6570\u636e\u5bfc\u5165\u65b0\u5efa\u6216\u4fee\u6539")
    public String insertormidifydataimport() throws YosException {
        long sys_dataimportid = this.content.getLong("sys_dataimportid");
        String siteid = this.content.getString("siteid");
        String table_name = this.content.getString("table_name");
        String importmode = this.content.getString("importmode");
        String datakey = "";
        if (importmode.equalsIgnoreCase("dataquery")) {
            datakey = this.content.getString("datakey");
        }
        boolean autouniqueid = this.content.getBooleanValue("autouniqueid");
        if (table_name.equals("")) {
            return this.getErrReturnObject().setErrMsg("\u5bfc\u5165\u8868\u4e0d\u53ef\u4e3a\u7a7a").toString();
        }
        String remarks = this.content.getString("remarks");
        String type = this.content.getString("type");
        if (type.equals("")) {
            return this.getErrReturnObject().setErrMsg("\u5bfc\u5165\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a").toString();
        }
        int sequence = this.content.getIntValue("sequence");
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        if (sys_dataimportid <= 0L || rows.isEmpty()) {
            SQLFactory sqlFactory = new SQLFactory((Object)this, "\u65b0\u5efa\u6570\u636e\u5bfc\u5165");
            sys_dataimportid = this.createTableID("sys_dataimport");
            sqlFactory.addParameter("sys_dataimportid", (Object)sys_dataimportid);
            sqlFactory.addParameter("siteid", (Object)siteid);
            sqlFactory.addParameter("table_name", (Object)table_name);
            sqlFactory.addParameter("uniquecolumnname", (Object)this.getuniquecolumnname(table_name));
            sqlFactory.addParameter("type", (Object)type);
            sqlFactory.addParameter("sequence", (Object)sequence);
            sqlFactory.addParameter("importmode", (Object)importmode);
            sqlFactory.addParameter("datakey", (Object)datakey);
            sqlFactory.addParameter("autouniqueid", (Object)(autouniqueid ? 1 : 0));
            sqlFactory.addParameter("datarows", (Object)new JSONArray());
            sqlFactory.addParameter("data_column", (Object)new JSONArray());
            sqlFactory.addParameter("table_column", (Object)new JSONArray());
            sqlFactory.addParameter("changeuserid", (Object)this.userid);
            sqlFactory.addParameter("remarks", (Object)remarks);
            this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
            this.content.put("sys_dataimportid", (Object)sys_dataimportid);
            return this.querydataimportmx();
        }
        String sqlstr = this.content.getString("sqlstr", true);
        JSONArray data_column = this.content.getJSONArray("data_column");
        if (!sqlstr.equals("") && !sqlstr.equals(rows.get(0).getString("sqlstr"))) {
            if ((sqlstr = sqlstr.replaceAll("(?i)delete", "delete").replaceAll("(?i)update", "update").replaceAll("(?i)insert", "insert")).contains("delete") || sqlstr.contains("update") || sqlstr.contains("insert")) {
                return this.getErrReturnObject().setErrMsg("\u53ea\u5141\u8bb8\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c").toString();
            }
            try {
                String x = sqlstr.replaceAll("(?i)where ", "where 1=2 and ");
                data_column = (JSONArray)JSONArray.toJSON((Object)this.dbConnect.runSqlQuery(x).getFieldList());
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        JSONArray table_column = this.content.getJSONArray("table_column");
        this.dbConnect.runSqlUpdate("update sys_dataimport set sequence='" + sequence + "', datakey='" + datakey + "', sqlstr='" + sqlstr + "',data_column='" + data_column + "',table_column='" + table_column.toString() + "',changeuserid=" + this.userid + ",remarks='" + remarks + "' where sys_dataimportid=" + sys_dataimportid);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u6570\u636e\u6e05\u9664")
    public String dataclean() throws YosException {
        long sys_dataimportid = this.content.getLong("sys_dataimportid");
        this.dbConnect.runSqlUpdate("update sys_dataimport set  datarows='" + new JSONArray() + "',errdatarows='" + new JSONArray() + "' where sys_dataimportid=" + sys_dataimportid);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u6570\u636e\u5bfc\u5165\u6821\u9a8c")
    public String dataimportvalidate() throws YosException {
        long sys_dataimportid = this.content.getLong("sys_dataimportid");
        boolean justcheckerrdata = this.content.getBooleanValue("justcheckerrdata");
        Rows rows = this.dbConnect.runSqlQuery("select siteid,table_name,datarows,errdatarows,data_column,table_column,type,uniquecolumnname,importmode from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        if (!rows.isEmpty()) {
            SQLiteTableData sqLiteTableData;
            Iterator column_default;
            String siteid = rows.get(0).getString("siteid");
            String table_name = rows.get(0).getString("table_name");
            String type = rows.get(0).getString("type");
            String uniquecolumnname = rows.get(0).getString("uniquecolumnname");
            JSONArray datarows = rows.get(0).getJSONArray("datarows");
            JSONArray errdatarows = rows.get(0).getJSONArray("errdatarows");
            datarows.addAll((Collection)errdatarows);
            errdatarows = new JSONArray();
            JSONArray table_column = rows.get(0).getJSONArray("table_column");
            if (datarows.isEmpty()) {
                String importmode = rows.get(0).getString("importmode");
                if (importmode.equalsIgnoreCase("excel")) {
                    return this.getErrReturnObject().setErrMsg("\u8bf7\u5148\u8fdb\u884cExcel\u8bfb\u53d6").toString();
                }
                return this.getErrReturnObject().setErrMsg("\u8bf7\u5148\u8fdb\u884c\u6570\u636e\u8bfb\u53d6").toString();
            }
            HashMap<String, LinkedList> linktablecolumn = new HashMap<String, LinkedList>();
            for (Object o : table_column) {
                JSONObject table_columnObject = (JSONObject)o;
                String mapping = table_columnObject.getStringValue("mapping");
                if (!mapping.equals("\u5173\u8054\u53d6\u503c")) continue;
                JSONObject linkmappingObject = table_columnObject.getJSONObject("linkmapping");
                LinkedList columnlist = linktablecolumn.containsKey(linkmappingObject.getString("table_name")) ? (LinkedList)linktablecolumn.get(linkmappingObject.getString("table_name")) : new LinkedList();
                columnlist.add(linkmappingObject.getString("column_name"));
                JSONArray conditionArray = linkmappingObject.getJSONArray("condition");
                for (Object condition : conditionArray) {
                    columnlist.add(((JSONObject)condition).getString("column_name"));
                }
                linktablecolumn.put(linkmappingObject.getString("table_name"), columnlist);
            }
            HashMap<String, JSONObject> mappingtable_columnmap = new HashMap<String, JSONObject>();
            HashMap<Object, JSONObject> linkmappingtable_columnmap = new HashMap<Object, JSONObject>();
            HashMap<String, Rows> linkDataRowsMap = new HashMap<String, Rows>();
            HashMap<Object, Object> keyfieldValaueMap = new HashMap<Object, Object>();
            for (Object o : table_column) {
                JSONObject table_columnObject = (JSONObject)o;
                Object column_name = table_columnObject.getString("column_name");
                String column_title = table_columnObject.getString("column_title");
                String mapping = table_columnObject.getStringValue("mapping");
                column_default = table_columnObject.getStringValue("column_default");
                boolean keyfield = table_columnObject.getBooleanValue("keyfield");
                boolean is_nullable = table_columnObject.getBooleanValue("is_nullable");
                if (keyfield) {
                    keyfieldValaueMap.put(column_name, "");
                }
                if (!mapping.equals("")) {
                    if (mapping.equals("\u5173\u8054\u53d6\u503c")) {
                        linkmappingtable_columnmap.put(column_name, table_columnObject);
                        JSONObject linkmappingObject = table_columnObject.getJSONObject("linkmapping");
                        String link_table_name = linkmappingObject.getString("table_name");
                        if (linkDataRowsMap.containsKey(link_table_name) || !linktablecolumn.containsKey(link_table_name)) continue;
                        if (this.getTableColumns(link_table_name).containsKey((Object)"siteid")) {
                            linkDataRowsMap.put(link_table_name, this.dbConnect.runSqlQuery("select " + ((LinkedList)linktablecolumn.get(link_table_name)).toString().replace("[", "").replace("]", "") + " from " + link_table_name + " where siteid='" + siteid + "'"));
                            continue;
                        }
                        linkDataRowsMap.put(link_table_name, this.dbConnect.runSqlQuery("select " + ((LinkedList)linktablecolumn.get(link_table_name)).toString().replace("[", "").replace("]", "") + " from " + link_table_name + " where 1=1 "));
                        continue;
                    }
                    mappingtable_columnmap.put(mapping, table_columnObject);
                    continue;
                }
                if (keyfield) {
                    return this.getErrReturnObject().setErrMsg("\u3010" + column_title + "\u3011 \u4e3a\u5173\u952e\u5b57\u6bb5\uff0c\u5fc5\u987b\u8fdb\u884c\u5b57\u6bb5\u6620\u5c04\u8bbe\u7f6e").toString();
                }
                if (is_nullable || !((String)((Object)column_default)).equalsIgnoreCase("") || !type.equalsIgnoreCase("insert") || table_columnObject.getBooleanValue("isuniquecolumn") || ((String)column_name).equalsIgnoreCase("createdate") || ((String)column_name).equalsIgnoreCase("createuserid") || ((String)column_name).equalsIgnoreCase("createby") || ((String)column_name).equalsIgnoreCase("changeuserid") || ((String)column_name).equalsIgnoreCase("changedate") || ((String)column_name).equalsIgnoreCase("changeby")) continue;
                return this.getErrReturnObject().setErrMsg("\u3010" + column_title + "\u3011 \u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\uff0c\u5fc5\u987b\u8fdb\u884c\u5b57\u6bb5\u6620\u5c04\u8bbe\u7f6e").toString();
            }
            for (String tablename : linkDataRowsMap.keySet()) {
                SQLiteTable sqLiteTable = SQLiteTable.getTable((String)(tablename + "_dataimport"));
                if (!sqLiteTable.dosNotExist()) {
                    sqLiteTable.dropTable();
                }
                for (String column_name : (LinkedList)linktablecolumn.get(tablename)) {
                    sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.VARCHAR);
                }
                sqLiteTable.create();
                for (Row linkdatarows : (Rows)linkDataRowsMap.get(tablename)) {
                    sqLiteTableData = sqLiteTable.makeData();
                    for (String column_name : (LinkedList)linktablecolumn.get(tablename)) {
                        sqLiteTableData.set(column_name, (Object)linkdatarows.getString(column_name));
                    }
                    sqLiteTableData.insert();
                }
            }
            SQLiteTable sqLiteTable = SQLiteTable.getTable((String)(table_name + "__dataimport"));
            if (!sqLiteTable.dosNotExist()) {
                sqLiteTable.dropTable();
            }
            sqLiteTable.addColumn(uniquecolumnname, SQLiteTable.FieldType.VARCHAR);
            Iterator fieldlist = new LinkedList<Object>();
            ((LinkedList)((Object)fieldlist)).add(uniquecolumnname);
            for (Object column_name : keyfieldValaueMap.keySet()) {
                sqLiteTable.addColumn((String)column_name, SQLiteTable.FieldType.VARCHAR);
                ((LinkedList)((Object)fieldlist)).add(column_name);
            }
            sqLiteTable.create();
            rows = this.getTableColumns(table_name).containsKey((Object)"siteid") ? this.dbConnect.runSqlQuery("select " + ((AbstractCollection)((Object)fieldlist)).toString().replace("[", "").replace("]", "") + " from " + table_name + " where siteid='" + siteid + "'") : this.dbConnect.runSqlQuery("select " + ((AbstractCollection)((Object)fieldlist)).toString().replace("[", "").replace("]", "") + " from " + table_name + " where 1=1 ");
            for (Row table_datarows : rows) {
                sqLiteTableData = sqLiteTable.makeData();
                column_default = ((AbstractSequentialList)((Object)fieldlist)).iterator();
                while (column_default.hasNext()) {
                    String column_name = (String)column_default.next();
                    sqLiteTableData.set(column_name, (Object)table_datarows.getString(column_name));
                }
                sqLiteTableData.insert();
            }
            boolean hassiteid = this.getTableColumns(table_name).containsKey((Object)"siteid");
            for (Object o : datarows) {
                Object value;
                JSONObject datarow = (JSONObject)o;
                if (!(!justcheckerrdata || datarow.containsKey("errmsg") && !datarow.getJSONObject("errmsg").isEmpty() || datarow.containsKey("linkdata") && datarow.getJSONObject("linkdata").containsKey("errmsg") && !datarow.getJSONObject("linkdata").getJSONObject("errmsg").isEmpty())) continue;
                JSONObject errmsgObject = new JSONObject();
                block56: for (String datarow_column : datarow.keySet()) {
                    if (!mappingtable_columnmap.containsKey(datarow_column)) continue;
                    JSONObject table_columnObject = (JSONObject)mappingtable_columnmap.get(datarow_column);
                    String column_name = table_columnObject.getString("column_name");
                    String column_title = table_columnObject.getString("column_title");
                    boolean is_nullable = table_columnObject.getBooleanValue("is_nullable");
                    String column_type = table_columnObject.getString("column_type").toLowerCase();
                    if (!is_nullable && datarow.getStringValue(datarow_column).equals("") && type.equalsIgnoreCase("insert")) {
                        errmsgObject.put(datarow_column, (Object)"\u5fc5\u586b\u9879");
                        continue;
                    }
                    if (column_name.equalsIgnoreCase("siteid") && !datarow.getStringValue(datarow_column).equals(siteid)) {
                        errmsgObject.put(datarow_column, (Object)"\u7ad9\u70b9\u9519\u8bef");
                        continue;
                    }
                    value = datarow.get(datarow_column);
                    if (keyfieldValaueMap.containsKey(column_name)) {
                        keyfieldValaueMap.put(column_name, String.valueOf(value));
                    }
                    switch (column_type) {
                        case "int": {
                            try {
                                datarow.getIntValue(datarow_column);
                            }
                            catch (Exception e) {
                                errmsgObject.put(datarow_column, (Object)("\u4e0d\u662f\u6709\u6548\u7684" + column_type + "\u7c7b\u578b"));
                            }
                            continue block56;
                        }
                        case "bigint": {
                            try {
                                datarow.getLongValue(datarow_column);
                            }
                            catch (Exception e) {
                                errmsgObject.put(datarow_column, (Object)("\u4e0d\u662f\u6709\u6548\u7684" + column_type + "\u7c7b\u578b"));
                            }
                            continue block56;
                        }
                        case "smallint": {
                            try {
                                datarow.getBooleanValue(datarow_column);
                            }
                            catch (Exception e) {
                                errmsgObject.put(datarow_column, (Object)"\u4e0d\u662f\u6709\u6548\u7684Boolean\u7c7b\u578b");
                            }
                            continue block56;
                        }
                        case "decimal": {
                            try {
                                datarow.getBigDecimal(datarow_column);
                            }
                            catch (Exception e) {
                                errmsgObject.put(datarow_column, (Object)("\u4e0d\u662f\u6709\u6548\u7684" + column_type + "\u7c7b\u578b"));
                            }
                            continue block56;
                        }
                        case "date": 
                        case "datetime": {
                            try {
                                datarow.getDate(datarow_column);
                            }
                            catch (Exception e) {
                                errmsgObject.put(datarow_column, (Object)("\u4e0d\u662f\u6709\u6548\u7684" + column_type + "\u7c7b\u578b"));
                            }
                            continue block56;
                        }
                    }
                }
                boolean islinkdataerr = false;
                if (!linkmappingtable_columnmap.isEmpty()) {
                    JSONObject linkdataObject = new JSONObject();
                    JSONObject linkdataerrmsgObject = new JSONObject();
                    for (String column_name : linkmappingtable_columnmap.keySet()) {
                        JSONObject table_columnObject = (JSONObject)linkmappingtable_columnmap.get(column_name);
                        boolean is_nullable = table_columnObject.getBooleanValue("is_nullable");
                        value = "";
                        JSONObject linkmappingObject = table_columnObject.getJSONObject("linkmapping");
                        if (linkmappingObject.containsKey("table_name") && linkDataRowsMap.containsKey(linkmappingObject.getString("table_name"))) {
                            String link_table_name = linkmappingObject.getString("table_name");
                            String link_column_name = linkmappingObject.getString("column_name");
                            JSONArray link_fieldsArray = linkmappingObject.getJSONArray("condition");
                            String linkdataquerywhere = " 1=1 ";
                            block58: for (Object link_field : link_fieldsArray) {
                                JSONObject link_fieldObject = (JSONObject)link_field;
                                String condition_column_name = link_fieldObject.getString("column_name");
                                String condition_mapping = link_fieldObject.getString("mapping");
                                switch (this.getColumnType(link_table_name, condition_column_name)) {
                                    case "int": 
                                    case "smallint": 
                                    case "bigint": {
                                        long condition_mapping_value = 0L;
                                        if (datarow.containsKey(condition_mapping)) {
                                            condition_mapping_value = datarow.getLongValue(condition_mapping);
                                        }
                                        linkdataquerywhere = linkdataquerywhere + " and " + condition_column_name + "='" + condition_mapping_value + "'";
                                        continue block58;
                                    }
                                    case "decimal": {
                                        float condition_mapping_value = 0.0f;
                                        if (datarow.containsKey(condition_mapping)) {
                                            condition_mapping_value = datarow.getFloatValue(condition_mapping);
                                        }
                                        linkdataquerywhere = linkdataquerywhere + " and " + condition_column_name + "='" + condition_mapping_value + "'";
                                        continue block58;
                                    }
                                }
                                String condition_mapping_value = "";
                                if (datarow.containsKey(condition_mapping)) {
                                    condition_mapping_value = datarow.getString(condition_mapping);
                                }
                                linkdataquerywhere = linkdataquerywhere + " and " + condition_column_name + "='" + condition_mapping_value + "'";
                            }
                            Rows linkdataRows = SQLiteMemory.runSqlQuery((String)("select " + link_column_name + " from " + link_table_name + "_dataimport where " + linkdataquerywhere));
                            if (!is_nullable && linkdataRows.size() == 0) {
                                linkdataerrmsgObject.put(column_name, (Object)"\u627e\u4e0d\u5230\u5173\u8054\u9879");
                                continue;
                            }
                            if (linkdataRows.size() > 1) {
                                linkdataerrmsgObject.put(column_name, (Object)"\u627e\u4e0d\u5230\u552f\u4e00\u7684\u5173\u8054\u9879");
                                continue;
                            }
                            if (linkdataRows.size() == 1) {
                                value = linkdataRows.get(0).getString(link_column_name);
                            }
                        }
                        if (!is_nullable && ((String)value).equals("")) {
                            linkdataerrmsgObject.put(column_name, (Object)"\u5fc5\u586b\u9879");
                        }
                        if (keyfieldValaueMap.containsKey(column_name)) {
                            keyfieldValaueMap.put(column_name, value);
                        }
                        linkdataObject.put(column_name, value);
                    }
                    linkdataObject.put("errmsg", (Object)linkdataerrmsgObject);
                    if (!linkdataerrmsgObject.isEmpty()) {
                        islinkdataerr = true;
                    }
                    datarow.put("linkdata", (Object)linkdataObject);
                }
                if (!keyfieldValaueMap.isEmpty()) {
                    StringBuilder sqlBuffer = hassiteid ? new StringBuilder("select " + uniquecolumnname + " from " + table_name + "__dataimport where siteid='" + siteid + "'") : new StringBuilder("select " + uniquecolumnname + " from " + table_name + "__dataimport where 1=1 ");
                    block59: for (String key : keyfieldValaueMap.keySet()) {
                        String value2 = (String)keyfieldValaueMap.get(key);
                        switch (this.getColumnType(table_name, key)) {
                            case "int": 
                            case "smallint": 
                            case "bigint": {
                                if (value2.equals("")) {
                                    sqlBuffer.append(" and ").append(key).append("='").append(value2).append("'");
                                    continue block59;
                                }
                                sqlBuffer.append(" and ").append(key).append("='").append(new BigDecimal(value2).longValue()).append("'");
                                continue block59;
                            }
                            case "decimal": {
                                if (value2.equals("")) {
                                    sqlBuffer.append(" and ").append(key).append("='").append(value2).append("'");
                                    continue block59;
                                }
                                sqlBuffer.append(" and ").append(key).append("='").append(new BigDecimal(value2).floatValue()).append("'");
                                continue block59;
                            }
                        }
                        sqlBuffer.append(" and ").append(key).append("='").append(value2).append("'");
                    }
                    Rows checkrows = SQLiteMemory.runSqlQuery((String)sqlBuffer.toString());
                    if (type.equalsIgnoreCase("insert")) {
                        if (!checkrows.isEmpty()) {
                            errmsgObject.put("datarow_errmsg", (Object)"\u6570\u636e\u5df2\u5b58\u5728");
                        }
                    } else if (type.equalsIgnoreCase("update")) {
                        if (checkrows.isEmpty()) {
                            errmsgObject.put("datarow_errmsg", (Object)"\u66f4\u65b0\u7684\u6570\u636e\u4e0d\u5b58\u5728");
                        } else if (checkrows.size() != 1) {
                            errmsgObject.put("datarow_errmsg", (Object)"\u66f4\u65b0\u7684\u6570\u636e\u4e0d\u552f\u4e00");
                        }
                    }
                } else if (type.equalsIgnoreCase("update")) {
                    errmsgObject.put("datarow_errmsg", (Object)"\u6ca1\u6709\u8bbe\u7f6ekey\u5b57\u6bb5");
                }
                datarow.put("errmsg", (Object)errmsgObject);
                if (errmsgObject.isEmpty() && !islinkdataerr) continue;
                errdatarows.add((Object)datarow);
            }
            for (Object o : errdatarows) {
                datarows.remove(o);
            }
            this.dbConnect.runSqlUpdate("update sys_dataimport set datarows='" + datarows + "',errdatarows='" + errdatarows + "' where sys_dataimportid=" + sys_dataimportid);
            for (String tablename : linkDataRowsMap.keySet()) {
                SQLiteTable sqLiteTable2 = SQLiteTable.getTable((String)(tablename + "_dataimport"));
                if (sqLiteTable2.dosNotExist()) continue;
                sqLiteTable2.dropTable();
            }
            SQLiteTable sqLiteTable3 = SQLiteTable.getTable((String)(table_name + "__dataimport"));
            if (!sqLiteTable3.dosNotExist()) {
                sqLiteTable3.dropTable();
            }
        }
        return this.getSucReturnObject().toString();
    }

    @API(title="\u6570\u636e\u5bfc\u5165")
    public String importdata() throws YosException {
        long sys_dataimportid = this.content.getLong("sys_dataimportid");
        boolean excepterrdata = this.content.getBooleanValue("excepterrdata");
        Rows rows = this.dbConnect.runSqlQuery("select siteid,table_name,datarows,errdatarows,table_column,type from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        if (!rows.isEmpty()) {
            String siteid = rows.get(0).getString("siteid");
            String table_name = rows.get(0).getString("table_name");
            String type = rows.get(0).getString("type");
            JSONArray datarows = rows.get(0).getJSONArray("datarows");
            JSONArray errdatarows = rows.get(0).getJSONArray("errdatarows");
            if (!excepterrdata && !errdatarows.isEmpty()) {
                return this.getErrReturnObject().setErrMsg("\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u5bfc\u5165\u4e0d\u6210\u529f\uff01").toString();
            }
            JSONArray table_columns = rows.get(0).getJSONArray("table_column");
            ArrayList<String> column_nameList = new ArrayList<String>();
            for (Object table_column : table_columns) {
                JSONObject table_columnObject = (JSONObject)table_column;
                column_nameList.add(table_columnObject.getString("column_name"));
            }
            if (type.equalsIgnoreCase("insert")) {
                StringBuffer sqlBuffer = new StringBuffer();
                SQLFactory insertSQL = new SQLFactory("sql:insert into " + table_name + " $table_columns$");
                insertSQL.addParameter_SQL_in("table_columns", column_nameList);
                sqlBuffer.append(insertSQL.getSQL() + "\n");
                sqlBuffer.append("values \n");
                long[] ids = this.createTableID(table_name, datarows.size() + 10);
                int idindex = 0;
                for (Object o : datarows) {
                    JSONObject datarow = (JSONObject)o;
                    SQLFactory valueSQl = new SQLFactory("sql:$columns_values$");
                    ArrayList<String> valueList = new ArrayList<String>();
                    for (Object table_column : table_columns) {
                        String value = "null";
                        JSONObject table_columnObject = (JSONObject)table_column;
                        boolean isuniquecolumn = table_columnObject.getBooleanValue("isuniquecolumn");
                        String mapping = table_columnObject.getString("mapping");
                        String column_name = table_columnObject.getString("column_name");
                        String column_default = table_columnObject.getString("column_default");
                        if (mapping.equals("\u5173\u8054\u53d6\u503c")) {
                            JSONObject linkdataObject = datarow.getJSONObject("linkdata");
                            value = (String)linkdataObject.getOrDefault(column_name, "null");
                            if (value.equals("")) {
                                value = "null";
                            }
                        } else if (!mapping.equals("")) {
                            value = datarow.getStringValue(mapping);
                            if (value.equals("")) {
                                value = "null";
                            }
                        } else if (isuniquecolumn) {
                            value = String.valueOf(ids[idindex++]);
                        } else if (column_name.equalsIgnoreCase("siteid")) {
                            value = siteid;
                        } else if (column_name.equalsIgnoreCase("createdate")) {
                            value = this.getDateTime_Str();
                        } else if (column_name.equalsIgnoreCase("createby")) {
                            value = this.username;
                        } else if (column_name.equalsIgnoreCase("createuserid")) {
                            value = String.valueOf(this.userid);
                        } else if (column_name.equalsIgnoreCase("changedate")) {
                            value = this.getDateTime_Str();
                        } else if (column_name.equalsIgnoreCase("changeby")) {
                            value = this.username;
                        } else if (column_name.equalsIgnoreCase("changeuserid")) {
                            value = String.valueOf(this.userid);
                        } else if (!column_default.equals("")) {
                            value = table_columnObject.getString("column_default");
                        }
                        valueList.add(value);
                    }
                    valueSQl.addParameter_in("columns_values", valueList);
                    sqlBuffer.append(valueSQl.getSQL()).append(",\n");
                }
                sqlBuffer = sqlBuffer.replace(sqlBuffer.length() - 2, sqlBuffer.length(), "");
                this.dbConnect.runSqlUpdate(sqlBuffer.toString());
            } else if (type.equalsIgnoreCase("update")) {
                String uniquecolumnname = this.getuniquecolumnname(table_name);
                boolean hassiteid = this.getTableColumns(table_name).containsKey((Object)"siteid");
                ArrayList<String> SQLlist = new ArrayList<String>();
                for (Object datarow : datarows) {
                    StringBuffer wheresqlBuffer;
                    StringBuffer updatesqlBuffer;
                    if (hassiteid) {
                        updatesqlBuffer = new StringBuffer("update " + table_name + " set siteid='" + siteid + "'");
                        wheresqlBuffer = new StringBuffer("where siteid='" + siteid + "'");
                    } else {
                        updatesqlBuffer = new StringBuffer("update " + table_name + " set " + uniquecolumnname + "=" + uniquecolumnname);
                        wheresqlBuffer = new StringBuffer("where 1=1 ");
                    }
                    JSONObject datarowObject = (JSONObject)datarow;
                    for (Object table_column : table_columns) {
                        String value = "null";
                        boolean ismodify = false;
                        JSONObject table_columnObject = (JSONObject)table_column;
                        String mapping = table_columnObject.getString("mapping");
                        String column_name = table_columnObject.getString("column_name");
                        boolean iskeyfield = table_columnObject.getBooleanValue("keyfield");
                        if (mapping.equals("\u5173\u8054\u53d6\u503c")) {
                            JSONObject linkdataObject = datarowObject.getJSONObject("linkdata");
                            value = (String)linkdataObject.getOrDefault(column_name, "null");
                            ismodify = true;
                        } else if (!mapping.equals("")) {
                            value = datarowObject.getStringValue(mapping);
                            ismodify = true;
                        } else if (column_name.equalsIgnoreCase("changedate")) {
                            value = this.getDateTime_Str();
                            ismodify = true;
                        } else if (column_name.equalsIgnoreCase("changeby")) {
                            value = this.username;
                            ismodify = true;
                        } else if (column_name.equalsIgnoreCase("changeuserid")) {
                            value = String.valueOf(this.userid);
                            ismodify = true;
                        }
                        if (iskeyfield) {
                            wheresqlBuffer.append(" and ").append(column_name).append("='").append(value).append("'");
                            continue;
                        }
                        if (!ismodify) continue;
                        if (value.equalsIgnoreCase("null") || value.equals("")) {
                            updatesqlBuffer.append(",").append(column_name).append("=null");
                            continue;
                        }
                        updatesqlBuffer.append(",").append(column_name).append("='").append(value).append("'");
                    }
                    SQLlist.add(updatesqlBuffer.append(wheresqlBuffer).toString());
                }
                this.dbConnect.runSqlUpdate(SQLlist);
            }
        }
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5bfc\u5165\u5220\u9664")
    public String deletedataimport() throws YosException {
        long sys_dataimportid = this.content.getLong("sys_dataimportid");
        this.dbConnect.runSqlUpdate("delete from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5bfc\u5165\u590d\u5236")
    public String duplicatedataimport() throws YosException {
        long sys_dataimportid_old = this.content.getLong("sys_dataimportid");
        long sys_dataimportid = this.createTableID("sys_dataimport");
        String siteid = this.content.getString("siteid");
        String remarks = this.content.getString("remarks");
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_dataimport where sys_dataimportid=" + sys_dataimportid_old);
        if (rows.isEmpty()) {
            return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230\u5f53\u524d\u5bfc\u5165\u6a21\u677f").toString();
        }
        String table_name = rows.get(0).getString("table_name");
        String type = rows.get(0).getString("type");
        String importmode = rows.get(0).getString("importmode");
        String datakey = rows.get(0).getString("datakey");
        long sequence = rows.get(0).getLong("sequence");
        int autouniqueid = rows.get(0).getInteger("autouniqueid");
        JSONArray table_column = rows.get(0).getJSONArray("table_column");
        JSONArray data_column = rows.get(0).getJSONArray("data_column");
        SQLFactory sqlFactory = new SQLFactory((Object)this, "\u65b0\u5efa\u6570\u636e\u5bfc\u5165");
        sqlFactory.addParameter("sys_dataimportid", (Object)sys_dataimportid);
        sqlFactory.addParameter("siteid", (Object)siteid);
        sqlFactory.addParameter("table_name", (Object)table_name);
        sqlFactory.addParameter("uniquecolumnname", (Object)this.getuniquecolumnname(table_name));
        sqlFactory.addParameter("type", (Object)type);
        sqlFactory.addParameter("autouniqueid", (Object)autouniqueid);
        sqlFactory.addParameter("importmode", (Object)importmode);
        sqlFactory.addParameter("sequence", (Object)sequence);
        sqlFactory.addParameter("datakey", (Object)datakey);
        sqlFactory.addParameter("datarows", (Object)new JSONArray());
        sqlFactory.addParameter("data_column", (Object)data_column);
        sqlFactory.addParameter("table_column", (Object)table_column);
        sqlFactory.addParameter("changeuserid", (Object)this.userid);
        sqlFactory.addParameter("remarks", (Object)remarks);
        this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
        this.content.put("sys_dataimportid", (Object)sys_dataimportid);
        return this.querydataimportmx();
    }

    @API(title="\u6570\u636e\u4e0a\u4f20")
    public String uploaddata() throws YosException {
        long sys_dataimportid = this.content.getLong("sys_dataimportid");
        Rows sys_dataimportRow = this.dbConnect.runSqlQuery("select table_name,datarows,data_column,table_column,siteid,importmode,datakey,sqlstr from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        if (sys_dataimportRow.isEmpty()) {
            return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230id\u4e3a" + sys_dataimportid + "\u7684\u5bfc\u5165\u6a21\u677f").toString();
        }
        String table_name = sys_dataimportRow.get(0).getString("table_name");
        String table_comment = this.getTableName(table_name);
        String siteid = sys_dataimportRow.get(0).getString("siteid");
        String importmode = sys_dataimportRow.get(0).getString("importmode");
        try {
            ExcelFactory excelFactory;
            ArrayList<String> fieldlist = new ArrayList<String>();
            if (importmode.equalsIgnoreCase("excel")) {
                excelFactory = this.getPostExcelFactory();
            } else {
                excelFactory = new ExcelFactory(table_name + "\u5bfc\u5165");
                String datakey = sys_dataimportRow.get(0).getString("datakey");
                String sqlstr = sys_dataimportRow.get(0).getString("sqlstr");
                DBConnect dbConnect = new DBConnect(datakey);
                Rows rows = dbConnect.runSqlQuery(sqlstr);
                excelFactory.addSheet(table_name, rows);
            }
            excelFactory.write();
            if (!siteid.equals("")) {
                this.siteid = siteid;
                Rows attRows = this.uploadExcelToObs(excelFactory);
                for (Row row : attRows) {
                    long attachmentid = row.getLong("attachmentid");
                    this.createFileLink("sys_dataimport", sys_dataimportid, "default", attachmentid);
                }
            }
            int sheetindex = -1;
            XSSFWorkbook xssfWorkbook = excelFactory.getXssfWorkbook();
            for (int i = 0; i < xssfWorkbook.getNumberOfSheets(); ++i) {
                if (!xssfWorkbook.getSheetName(i).equalsIgnoreCase(table_name) && !xssfWorkbook.getSheetName(i).equalsIgnoreCase(table_comment)) continue;
                sheetindex = i;
                break;
            }
            if (sheetindex < 0) {
                return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684sheet\u6570\u636e\u96c6\uff0csheet\u540d\u79f0\u53ef\u4ee5\u4e3a\u3010" + table_name + "\u3011\u6216\u3010" + table_comment + "\u3011").toString();
            }
            XSSFRow head = excelFactory.getSheet(sheetindex).getRow(0);
            int columncount = head.getLastCellNum();
            for (int n = 0; n < columncount; ++n) {
                XSSFCell cell = head.getCell(n);
                fieldlist.add(cell.getStringCellValue());
            }
            Rows datarows = excelFactory.getSheetRows(sheetindex, fieldlist, 1);
            for (Row datarow : datarows) {
                JSONObject errmsg = new JSONObject();
                errmsg.put("datarow_errmsg", (Object)"");
                datarow.put((Object)"errmsg", (Object)errmsg);
            }
            JSONArray table_columnArray = sys_dataimportRow.get(0).getJSONArray("table_column");
            for (Object o : table_columnArray) {
                JSONObject table_columnObject = (JSONObject)o;
                String column_title = table_columnObject.getString("column_title");
                if (!fieldlist.contains(column_title)) continue;
                table_columnObject.put("mapping", (Object)column_title);
            }
            this.dbConnect.runSqlUpdate("update sys_dataimport set datarows='" + datarows.toJsonArray() + "',errdatarows='" + new JSONArray() + "' ,data_column='" + JSONArray.toJSON(fieldlist) + "',table_column='" + table_columnArray + "',changeuserid=" + this.userid + " where sys_dataimportid=" + sys_dataimportid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.getSucReturnObject().toString();
    }
}

