/*
 * Decompiled with CFR 0.152.
 */
package common.websocket;

import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.api.YOSAPI;
import common.parameter.parameter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import utility.tools.Encryption;

@ServerEndpoint(value="/webSocket/{accesstoken}")
public class WebSocket
extends BaseClass {
    private Session session;
    private long usersiteid;
    private String accesstoken;
    private Date createdate;
    private String systemclient;

    @OnOpen
    public void onOpen(@PathParam(value="accesstoken") String accesstoken, Session session) {
        this.session = session;
        this.accesstoken = accesstoken;
        this.createdate = this.getDateTime();
        if (parameter.tokenlist.containsKey(accesstoken)) {
            this.usersiteid = parameter.tokenlist.get(accesstoken);
            if (parameter.usersiteIdList.containsKey(this.usersiteid)) {
                this.systemclient = parameter.usersiteIdList.get(this.usersiteid).getString("systemclient");
            }
        } else {
            JSONObject methodobject = new JSONObject();
            methodobject.put("type", (Object)"err");
            methodobject.put("msg", (Object)"\u8bf7\u767b\u9646");
            this.sendSystemMessage(methodobject);
            return;
        }
        if (parameter.websocketClients.containsKey(this.usersiteid)) {
            parameter.websocketClients.get(this.usersiteid).put(accesstoken, this);
        } else {
            ConcurrentHashMap<String, WebSocket> map = new ConcurrentHashMap<String, WebSocket>();
            map.put(accesstoken, this);
            parameter.websocketClients.put(this.usersiteid, map);
        }
        parameter.loginDate.put(this.usersiteid, this.createdate);
    }

    @OnClose
    public void onClose() {
        if (parameter.websocketClients.containsKey(this.usersiteid)) {
            parameter.websocketClients.get(this.usersiteid).remove(this.accesstoken);
            if (parameter.websocketClients.get(this.usersiteid).isEmpty()) {
                parameter.websocketClients.remove(this.usersiteid);
            }
        }
    }

    @OnMessage
    public void onMessage(String RequestContent) throws YosException {
        if (RequestContent == null || RequestContent.equals("")) {
            return;
        }
        if ("isalive".equalsIgnoreCase(RequestContent)) {
            this.session.getAsyncRemote().sendText("alive");
            return;
        }
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject((String)RequestContent);
        }
        catch (Exception e) {
            return;
        }
        try {
            long apiid = requestcontent.getLongValue("id");
            int apiversion = requestcontent.getIntValue("version");
            YOSAPI yosapi = apiid <= 0L ? YOSAPI.getApi("restcontroller." + requestcontent.getString("classname"), requestcontent.getString("method")) : YOSAPI.getApi(apiid, apiversion);
            YOSAPI.YosRequest yosRequest = new YOSAPI.YosRequest();
            yosRequest.setRequestKey(Encryption.Encode_MD5(RequestContent));
            yosRequest.setAccesstoken(this.accesstoken);
            yosRequest.setContent(requestcontent.getJSONObject("content"));
            yosapi.action(yosRequest);
        }
        catch (YosException e) {
            e.printStackTrace();
        }
    }

    private void saveCallMethodMsg(String key, boolean fromdb, long time) {
        long callmethod_fromcacheTimes;
        long callmethodTimes = parameter.callmethodTimes.containsKey(key) ? parameter.callmethodTimes.get(key) : 0L;
        parameter.callmethodTimes.put(key, callmethodTimes + 1L);
        parameter.lastcallmethodtime.put(key, Calendar.getInstance().getTime());
        long l = callmethod_fromcacheTimes = parameter.callmethod_fromcacheTimes.containsKey(key) ? parameter.callmethod_fromcacheTimes.get(key) : 0L;
        if (!fromdb) {
            parameter.callmethod_fromcacheTimes.put(key, callmethod_fromcacheTimes + 1L);
        } else {
            parameter.callmethodLastTimeLong.put(key, time);
            long totaltimes = callmethodTimes - callmethod_fromcacheTimes;
            long callmethodTimeLong = parameter.callmethodTimeLong.containsKey(key) ? parameter.callmethodTimeLong.get(key) : 0L;
            parameter.callmethodTimeLong.put(key, (callmethodTimeLong * totaltimes + time) / (totaltimes + 1L));
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        error.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDialogMessage(JSONObject message2) {
        Class<WebSocket> clazz = WebSocket.class;
        synchronized (WebSocket.class) {
            JSONObject object = new JSONObject();
            object.put("msgtype", (Object)"imdialog");
            object.put("message", (Object)message2);
            this.session.getAsyncRemote().sendText(object.toJSONString());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSystemMessage(JSONObject message2) {
        Class<WebSocket> clazz = WebSocket.class;
        synchronized (WebSocket.class) {
            JSONObject object = new JSONObject();
            object.put("msgtype", (Object)"system");
            object.put("message", (Object)message2);
            this.session.getAsyncRemote().sendText(object.toJSONString());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public long getUsersiteid() {
        return this.usersiteid;
    }

    public String getAccesstoken() {
        return this.accesstoken;
    }

    public String getSystemclient() {
        return this.systemclient;
    }
}

