/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class InitService
implements Runnable {
    private static boolean isfirstrun = true;
    static ScheduledExecutorService service;
    private static final Logger logger;
    public static HashMap<String, ScheduledFuture<?>> scheduledFutureMap;

    @Override
    public void run() {
        if (isfirstrun) {
            service = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
            logger.info((Object)"\u542f\u52a8\u81ea\u52a8\u4efb\u52a1");
            isfirstrun = false;
            String sql = "select classname,isused,remarks,lastruntime,type,count,time from sys_services";
            DBConnect dbConnect = new DBConnect();
            try {
                Rows rows = dbConnect.runSqlQuery(sql);
                for (Row row : rows) {
                    InitService.addService(row);
                }
            }
            catch (YosException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addService(Row row) {
        try {
            String classname = row.getString("classname");
            String remarks = row.getString("remarks");
            String type = row.getString("type");
            int count = row.getInteger("count");
            String isused = row.getString("isused");
            if (scheduledFutureMap.containsKey(classname)) {
                ScheduledFuture<?> oldscheduledFuture = scheduledFutureMap.get(classname);
                oldscheduledFuture.cancel(false);
                logger.info((Object)("\u670d\u52a1\u5378\u8f7d\uff1a" + classname + ";" + remarks));
            }
            Class<?> clz = Class.forName("service." + classname);
            Constructor<?> cla = clz.getDeclaredConstructor(new Class[0]);
            Object obj = cla.newInstance(new Object[0]);
            logger.info((Object)("\u670d\u52a1\u52a0\u8f7d\uff1a" + classname + "," + type + "," + isused + ";" + remarks));
            ScheduledFuture<?> scheduledFuture = null;
            if (type.equalsIgnoreCase("second")) {
                scheduledFuture = service.scheduleWithFixedDelay((Runnable)obj, 10L, count, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("minute")) {
                int delay = 60 - Calendar.getInstance().get(13);
                scheduledFuture = service.scheduleAtFixedRate((Runnable)obj, delay, (long)count * 60L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("hour")) {
                Calendar calendar;
                int syssecond;
                String[] times;
                int schedulesecond;
                int delay;
                String time = row.getString("time");
                if (time.equals("")) {
                    time = "00:00";
                }
                delay = (delay = (schedulesecond = Integer.parseInt((times = time.split(":"))[0]) * 60 + Integer.parseInt(times[1])) - (syssecond = (calendar = Calendar.getInstance()).get(12) * 60 + calendar.get(13))) < 0 ? delay + 3600 : delay;
                scheduledFuture = service.scheduleAtFixedRate((Runnable)obj, delay, (long)count * 60L * 60L, TimeUnit.SECONDS);
            } else if (type.equalsIgnoreCase("day")) {
                Calendar calendar;
                int syssecond;
                String[] times;
                int schedulesecond;
                int delay;
                String time = row.getString("time");
                if (time.equals("")) {
                    time = "00:00:00";
                }
                delay = (delay = (schedulesecond = Integer.parseInt((times = time.split(":"))[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2])) - (syssecond = (calendar = Calendar.getInstance()).get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13))) < 0 ? delay + 86400 : delay;
                scheduledFuture = service.scheduleAtFixedRate((Runnable)obj, delay, (long)count * 60L * 60L * 24L, TimeUnit.SECONDS);
            }
            if (scheduledFuture != null) {
                scheduledFutureMap.put(classname, scheduledFuture);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        logger = Logger.getLogger(InitService.class);
        scheduledFutureMap = new HashMap();
    }
}

