package restcontroller.sysmanage.site;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;

import java.util.ArrayList;
import java.util.Set;

@API(title = "管理端-站点管理")
public class site extends Controller {
    public site(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "站点列表查询")
    @CACHEING
    public String query_siteList() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "站点列表查询", pageSize, pageNumber, pageSorting);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "站点详情查询")
    @CACHEING
    public String query_siteMain() throws YosException {
        long siteuid = content.getLongValue("siteuid");
        SQLFactory sqlFactory = new SQLFactory(this, "站点详情查询");
        sqlFactory.addParameter("siteuid", siteuid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "站点新增、修改")
    @CACHEING_CLEAN(cms = {@cm(clazz = site.class, method = {"query_siteList", "query_siteMain"})})
    public String insertormodify_site() throws YosException {
        long siteuid = content.getLongValue("siteuid");
        String siteid = content.getString("siteid", "sys_site");
        String sitename = content.getString("sitename", "sys_site");
        String enterprisename = content.getString("enterprisename", "sys_site");
        String bucketname = content.getString("bucketname", "sys_site");
        ArrayList<String> sqlist = new ArrayList<>();
        if (siteuid <= 0 || dbConnect.runSqlQuery("select siteuid from sys_site where siteuid=" + siteuid).isEmpty()) {
            siteuid = createTableID("sys_site");
            SQLFactory sqlFactory = new SQLFactory(this, "站点新增");
            sqlFactory.addParameter("siteuid", siteuid);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("sitename", sitename);
            sqlFactory.addParameter("enterprisename", enterprisename);
            sqlFactory.addParameter("bucketname", bucketname);
            sqlist.add(sqlFactory.getSQL());

            long salematerialfolderid = createTableID("sys_attachment");
            SQLFactory salematerialfoldersqlFactory = new SQLFactory(this, "媒体文件夹插入");
            salematerialfoldersqlFactory.addParameter("attachmentid", salematerialfolderid);
            salematerialfoldersqlFactory.addParameter("siteid", siteid);
            salematerialfoldersqlFactory.addParameter("document", "营销物料");
            sqlist.add(salematerialfoldersqlFactory.getSQL());

            long appfolderid = createTableID("sys_attachment");
            SQLFactory appfoldersqlFactory = new SQLFactory(this, "媒体文件夹插入");
            appfoldersqlFactory.addParameter("attachmentid", appfolderid);
            appfoldersqlFactory.addParameter("siteid", siteid);
            appfoldersqlFactory.addParameter("document", "应用附件");
            sqlist.add(appfoldersqlFactory.getSQL());

            SQLFactory sqlFactory2 = new SQLFactory(this, "创建站点参数");
            sqlFactory2.addParameter("siteid", siteid);
            sqlFactory2.addParameter("sys_site_parameterid", createTableID("sys_site_parameter"));
            sqlFactory2.addParameter("salematerialfolderid", salematerialfolderid);
            sqlFactory2.addParameter("appfolderid", appfolderid);
            sqlist.add(sqlFactory2.getSQL());

            SQLFactory depsqlFactory = new SQLFactory(this, "部门新增");
            depsqlFactory.addParameter("siteid", siteid);
            depsqlFactory.addParameter("departmentid", createTableID("sys_department"));
            depsqlFactory.addParameter("depname", sitename);
            sqlist.add(depsqlFactory.getSQL());

            SQLFactory sqlAddFactory = new SQLFactory(this, "通告版块新增");
            sqlAddFactory.addParameter("sat_notice_classid", createTableID("sat_notice_class"));
            sqlAddFactory.addParameter("siteid", siteid);
            sqlAddFactory.addParameter("createby", username);
            sqlAddFactory.addParameter("changeby", username);
            sqlAddFactory.addParameter("classname", "默认板块");
            sqlist.add(sqlAddFactory.getSQL());
            /*
            新增站点，自动授权给所有的系统管理员账号
             */
            Rows sysadministratorrows = dbConnect.runSqlQuery("select userid from sys_users where sysadministrator=1");
            for (Row row : sysadministratorrows) {
                SQLFactory sqlFactory3 = new SQLFactory(this, "账号站点添加");
                sqlFactory3.addParameter("usersiteid", createTableID("sys_usersite"));
                sqlFactory3.addParameter("userid", row.getLong("userid"));
                sqlFactory3.addParameter("siteid", siteid);
                sqlFactory3.addParameter("createby", "admin");
                sqlist.add(sqlFactory3.getSQL());
            }
            content.put("siteuid", siteuid);
        } else {
            SQLFactory sqlFactory = new SQLFactory(this, "站点修改");
            sqlFactory.addParameter("siteuid", siteuid);
            sqlFactory.addParameter("sitename", sitename);
            sqlFactory.addParameter("enterprisename", enterprisename);
            sqlFactory.addParameter("bucketname", bucketname);
            sqlist.add(sqlFactory.getSQL());
        }

        SQLFactory sys_enterpriseinsert = new SQLFactory(this, "企业新增");
        sys_enterpriseinsert.addParameter("sys_enterpriseid", createTableID("sys_enterprise"));
        sys_enterpriseinsert.addParameter("siteid", siteid);
        sys_enterpriseinsert.addParameter("enterprisename", sitename);
        sys_enterpriseinsert.addParameter("userid", userid);
        sys_enterpriseinsert.addParameter("username", username);
        sqlist.add(sys_enterpriseinsert.getSQL());

        dbConnect.runSqlUpdate(sqlist);
        return query_siteMain();
    }

    @API(title = "站点删除")
    @CACHEING_CLEAN(cms = {@cm(clazz = site.class, method = {"query_siteList", "query_siteMain"})})
    public String delete_site() throws YosException {
        long siteuid = content.getLongValue("siteuid");
        boolean dataclean = content.getBooleanValue("dataclean");//站点数据清空

        Rows rows = dbConnect.runSqlQuery("select *from sys_site where siteid='YOSSYS and siteuid=" + siteuid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("站点不存在！").toString();
        }
        if (rows.get(0).getString("siteid").equalsIgnoreCase("YOSSYS")) {
            return getErrReturnObject().setErrMsg("该站点不可删除！").toString();
        }
        ArrayList<String> sqlist = new ArrayList<>();
        sqlist.add("delete from sys_site_parameter where siteid in (select siteid from sys_site where siteuid=" + siteuid + ")");
        sqlist.add("delete from sys_site where siteuid=" + siteuid);
        if (dataclean) {
            Rows deleteSQLRows = dbConnect.runSqlQuery("select concat('delete from ',table_name,' where siteid=''" + rows.get(0).getString("siteid") + "''') as sqlstr from sys_objectcols where column_name='siteid'");
            for (Row deleteSQLRow : deleteSQLRows) {
                sqlist.add(deleteSQLRow.getString("sqlstr"));
            }
        }
        dbConnect.runSqlUpdate(sqlist);
        Parameter.cleanSiteParameter(siteid);
        return getSucReturnObject().toString();
    }


    @API(title = "站点参数信息查询")
    @CACHEING
    public String querySite_Parameter() throws YosException {
        String siteid = content.getString("siteid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_site_parameter where siteid='" + siteid + "'");
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到站点参数").toString();
        } else {
            {
                JSONArray orderdefaultaccountArray = rows.get(0).getJSONArray("orderdefaultaccount");

                Set<String> ordertypeSet = getOptionType("ordertype").keySet();
                for (String ordertype : ordertypeSet) {
                    boolean has = false;
                    for (Object o : orderdefaultaccountArray) {
                        JSONObject orderdefaultaccountObject = (JSONObject) o;
                        if (orderdefaultaccountObject.getString("ordertype").equalsIgnoreCase(ordertype)) {
                            has = true;
                            break;
                        }
                    }
                    if (!has) {
                        JSONObject orderdefaultaccountObject = new JSONObject();
                        orderdefaultaccountObject.put("ordertype", ordertype);
                        orderdefaultaccountArray.add(orderdefaultaccountObject);
                    }
                }

                rows.get(0).put("orderdefaultaccount", orderdefaultaccountArray);
            }
            {
                JSONArray orderdefaultrepeatArray = rows.get(0).getJSONArray("orderdefaultrepeat");

                Set<String> ordertypeSet = getOptionType("ordertype").keySet();
                for (String ordertype : ordertypeSet) {
                    boolean has = false;
                    for (Object o : orderdefaultrepeatArray) {
                        JSONObject orderdefaultrepeatObject = (JSONObject) o;
                        if (orderdefaultrepeatObject.getString("ordertype").equalsIgnoreCase(ordertype)) {
                            has = true;
                            break;
                        }
                    }
                    if (!has) {
                        JSONObject orderdefaultrepeatObject = new JSONObject();
                        orderdefaultrepeatObject.put("ordertype", ordertype);
                        orderdefaultrepeatArray.add(orderdefaultrepeatObject);
                    }
                }

                rows.get(0).put("orderdefaultrepeat", orderdefaultrepeatArray);
            }


            Rows sys_enterpriseRows = dbConnect.runSqlQuery("select sys_enterpriseid from sys_enterprise where siteid='" + siteid + "' and ismain=1");
            if (sys_enterpriseRows.isNotEmpty()) {
                rows.get(0).put("sys_enterpriseid", sys_enterpriseRows.get(0).getLong("sys_enterpriseid"));
            }
        }
        return getSucReturnObject().setData(rows.get(0)).toString();
    }

    @API(title = "站点参数信息更新")
    @CACHEING_CLEAN(cms = {@cm(clazz = site.class, method = {"querySite_Parameter"})})
    public String updateSite_Parameter() throws YosException {
        String siteid = content.getString("siteid");
        RowsMap tableColumnsMap = getTableColumns("sys_site_parameter");
        tableColumnsMap.remove("changeuserid");
        tableColumnsMap.remove("changeby");
        tableColumnsMap.remove("changedate");
        tableColumnsMap.remove("siteid");

        StringBuffer updateSQl = new StringBuffer();
        updateSQl.append("update sys_site_parameter set changeuserid=" + userid + ",changeby='" + username + "',changedate=now()");
        boolean isupdate = false;
        for (String key : content.keySet()) {
            if (tableColumnsMap.containsKey(key)) {
                isupdate = true;
                String column_type = tableColumnsMap.get(key).get(0).getString("column_type").toLowerCase();
                switch (column_type) {
                    case "decimal": {
                        updateSQl.append("," + key + "='" + content.getBigDecimal(key).floatValue() + "'");
                        break;
                    }
                    case "int": {
                        updateSQl.append("," + key + "=" + content.getIntValue(key));
                        break;
                    }
                    case "bigint": {
                        updateSQl.append("," + key + "=" + content.getLongValue(key));
                        break;
                    }
                    case "smallint": {
                        updateSQl.append("," + key + "=" + content.getIntValue(key));
                        break;
                    }
                    default: {
                        updateSQl.append("," + key + "='" + content.getString(key) + "'");
                        break;
                    }
                }
            }
        }
        updateSQl.append(" where siteid='" + siteid + "'");
        if (isupdate) {
            dbConnect.runSqlUpdate(updateSQl.toString());
        }
        Parameter.cleanSiteParameter(siteid);
        return querySite_Parameter();
    }

    @API(title = "站点账号默认密码设置")
    public String updateSite_defaultpassword() throws YosException {
        String siteid = content.getString("siteid");
        String password_default = content.getString("password_default");//新账号默认密码
        dbConnect.runSqlUpdate("update sys_site_parameter set changeuserid='" + userid + "' , password_default='" + password_default + "' where siteid='" + siteid + "'");
        Parameter.cleanSiteParameter(siteid);
        return getSucReturnObject().toString();
    }
}
