package restcontroller.sysmanage.develop.sys_object;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;

import java.util.ArrayList;

@API(title = "缓存数据库管理")
public class sys_cacheobject extends Controller {
    public sys_cacheobject(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "缓存表信息查询")
    public String queryCacheObjectList() throws YosException {
        Rows tableRows = dbConnect.runSqlQuery("select * from sys_cacheobject");
        for (Row row : tableRows) {
            String table_name = row.getString("table_name");
            SQLiteTable sqLiteTable = SQLiteTable.getTable(table_name);
            if (!sqLiteTable.dosNotExist()) {
                row.put("table_rows", SQLiteMemory.runSqlQuery("select count(*) as table_rows from " + table_name).get(0).getString("table_rows"));
            } else {
                row.put("table_rows", "-1");
            }
        }
        return getSucReturnObject().setData(tableRows).toString();
    }

    @API(title = "缓存表字段信息查询")
    public String queryCacheObjectColList() throws YosException {
        String table_name = content.getString("table_name");
        Rows tableRows = dbConnect.runSqlQuery("select * from sys_cacheobjectcols where table_name='" + table_name + "'");
        return getSucReturnObject().setData(tableRows).toString();
    }

    @API(title = "新增修改缓存表")
    public String insertormodify_CacheObject() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        String table_comment = content.getString("table_comment");
        if (table_name.equals("") || !String.valueOf(table_name.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("表名必须以小写英文字母开头").toString();
        }
        if (!table_name.replace("_", "").matches("^[a-z0-9]*")) {
            return getErrReturnObject().setErrMsg("表名必须为小写英文字母或英文数字组合").toString();
        }
        if ("".equals(table_comment)) {
            return getErrReturnObject().setErrMsg("数据表描述不可为空").toString();
        }
        if (dbConnect.runSqlQuery("select * from sys_cacheobject where table_name='" + table_name + "'").isEmpty()) {
            SQLFactory insertTable = new SQLFactory(this, "缓存表新增");
            insertTable.addParameter("sys_cacheobjectid", createTableID("sys_cacheobject"));
            insertTable.addParameter("table_name", table_name);
            insertTable.addParameter("table_comment", table_comment);
            dbConnect.runSqlUpdate(insertTable.getSQL());
        } else {
            dbConnect.runSqlUpdate("update sys_cacheobject set table_comment='" + table_comment + "' where table_name='" + table_name + "'");
        }
        return getSucReturnObject().toString();
    }

    @API(title = "删除缓存表")
    public String delete_CacheObject() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        dbConnect.runSqlUpdate("delete from sys_cacheobject where table_name='" + table_name + "'");
        return getSucReturnObject().toString();
    }

    /**
     * 新增修改表字段
     *
     * @return
     */
    @API(title = "新增修改缓存表字段")
    public String insertormodify_CacheObjectCol() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        String column_name = content.getString("column_name").toLowerCase();
        if (column_name.equals("") || !String.valueOf(column_name.charAt(0)).matches("^[a-z]*")) {
            return getErrReturnObject().setErrMsg("字段名称必须以英文字母开头").toString();
        }
        if (!column_name.replace("_", "").matches("^[a-z0-9]*")) {
            return getErrReturnObject().setErrMsg("字段名称为英文字母或英文数字组合").toString();
        }
        String column_type = content.getString("column_type");
        String column_comment = content.getString("column_comment");
        Rows sys_objectRows = dbConnect.runSqlQuery("select *from sys_cacheobject where table_name='" + table_name + "'");
        if (sys_objectRows.isEmpty()) {
            return getErrReturnObject().setErrMsg(table_name + "表不存在！").toString();
        }
        ArrayList<String> sqllist = new ArrayList<>();
        if (dbConnect.runSqlQuery("select * from sys_cacheobjectcols where table_name='" + table_name + "' and column_name='" + column_name + "'").isEmpty()) {
            SQLFactory insertCol = new SQLFactory(this, "缓存字段新增");
            insertCol.addParameter("sys_cacheobjectcolsid", createTableID("sys_cacheobjectcols"));
            insertCol.addParameter("table_name", table_name);
            insertCol.addParameter("column_name", column_name);
            insertCol.addParameter("column_type", column_type);
            insertCol.addParameter("column_comment", column_comment);
            sqllist.add(insertCol.getSQL());
        } else {
            sqllist.add("update sys_cacheobjectcols set column_type='" + column_type + "',column_comment='" + column_comment + "' where table_name='" + table_name + "' and column_name='" + column_name + "'");
        }
        dbConnect.runSqlUpdate(sqllist);
        return getSucReturnObject().toString();
    }

    /**
     * 删除字段
     *
     * @return
     */
    @API(title = "删除缓存字段")
    public String delete_CacheObjectCol() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        String column_name = content.getString("column_name").toLowerCase();
        Rows sys_objectRows = dbConnect.runSqlQuery("select *from sys_cacheobject where table_name='" + table_name + "'");
        if (sys_objectRows.isEmpty()) {
            return getErrReturnObject().setErrMsg(table_name + "表不存在！").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_cacheobjectcols where table_name='" + table_name + "' and column_name='" + column_name + "'");
        return getSucReturnObject().toString();
    }
}
