package restcontroller.sysmanage.develop.report;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;
import utility.tools.WebRequest;

import java.util.Calendar;

public class report extends Controller {
    public report(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "报表列表查询")
    public String queryReportList() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "报表查询");
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "新增报表")
    public String insertReport() throws YosException {
        String jimu_report_id = String.valueOf(Calendar.getInstance().getTimeInMillis());
        SQLFactory sqlFactory = new SQLFactory(this, "报表新增");
        long sys_reportid = createTableID("sys_report");
        sqlFactory.addParameter("sys_reportid", sys_reportid);
        sqlFactory.addParameter("siteid", content.getStringValue("siteid"));
        sqlFactory.addParameter("jimu_report_id", jimu_report_id);
        sqlFactory.addParameter("systemappid", content.getLongValue("systemappid"));
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().setData("/yosreport/jmreport/index/" + jimu_report_id + "?token=" + getReportToken(sys_reportid)).toString();
    }

    @API(title = "修改报表")
    public String updateReport() throws YosException {
        long sys_reportid = content.getLongValue("sys_reportid");
        String siteid = content.getStringValue("siteid");
        long systemappid = content.getLongValue("systemappid");
        boolean isused = content.getBooleanValue("isused");
        dbConnect.runSqlUpdate("update sys_report set siteid='" + siteid + "',systemappid='" + systemappid + "',isused='" + (isused ? 1 : 0) + "' where sys_reportid=" + sys_reportid);
        return getSucReturnObject().toString();
    }

    @API(title = "删除报表")
    public String deleteReport() throws YosException {
        dbConnect.runSqlUpdate("delete from sys_report where sys_reportid=" + content.getLongValue("sys_reportid"));
        return getSucReturnObject().toString();
    }

    @API(title = "请求报表编辑页面")
    public String editReport() throws YosException {
        long sys_reportid = content.getLongValue("sys_reportid");
        Rows rows = dbConnect.runSqlQuery("select *from sys_report where sys_reportid=" + sys_reportid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到报表信息").toString();
        }
        String jimu_report_id = rows.get(0).getString("jimu_report_id");
        return getSucReturnObject().setData("/yosreport/jmreport/index/" + jimu_report_id + "?token=" + getReportToken(sys_reportid)).toString();
    }

    @API(title = "报表复制")
    public String copyReport() throws YosException {
        long sys_reportid = content.getLongValue("sys_reportid");
        Rows rows = dbConnect.runSqlQuery("select *from sys_report where sys_reportid=" + sys_reportid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到报表信息").toString();
        }
        String jimu_report_id = rows.get(0).getString("jimu_report_id");
        String siteid_copy = rows.get(0).getString("siteid");
        String systemappid_copy = rows.get(0).getString("systemappid");
        String url = request.getHttpServletRequest().getRequestURL().toString();
        url = url.replace("/yos/rest/index", "/yosreport/jmreport/reportCopy?id=" + jimu_report_id + "&token=" + getReportToken(sys_reportid));
        String copyresult = new WebRequest().doGet(url);
        try {
            JSONObject copyResultObject = JSONObject.parseObject(copyresult);
            if (copyResultObject.getBooleanValue("success")) {
                Rows copyReportRows = dbConnect.runSqlQuery("select t1.id from jimureport.jimu_report t1 left join sys_report t2 on t1.id=t2.jimu_report_id where t2.jimu_report_id is null order by t1.create_time desc");
                if (copyReportRows.isNotEmpty()) {
                    SQLFactory sqlFactory = new SQLFactory(this, "报表新增");
                    long sys_reportid_new = createTableID("sys_report");
                    sqlFactory.addParameter("sys_reportid", sys_reportid_new);
                    sqlFactory.addParameter("siteid", siteid_copy);
                    sqlFactory.addParameter("jimu_report_id", copyReportRows.get(0).getString("id"));
                    sqlFactory.addParameter("systemappid", systemappid_copy);
                    dbConnect.runSqlUpdate(sqlFactory.getSQL());
                    return getSucReturnObject().setData("/yosreport/jmreport/index/" + copyReportRows.get(0).getString("id") + "?token=" + getReportToken(sys_reportid_new)).toString();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getErrReturnObject().toString();
    }
}
