package restcontroller.sysmanage.develop.remindconfig;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import utility.wechat.WechatService;

import java.util.ArrayList;

@API(title = "系统提醒设置")
public class remindconfig extends Controller {
    public remindconfig(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统提醒列表查询")
    public String query_remindconfigList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_remind_config");
        for (Row row : rows) {
            row.put("remindmode", row.getJSONArray("remindmode"));
            JSONObject wechatservice_content = row.getJSONObject("wechatservice_content");
            if (wechatservice_content.isEmpty()) {
                wechatservice_content.put("data", new JSONObject());
                wechatservice_content.put("templates", new JSONObject());
            }
            row.put("wechatservice_content", wechatservice_content);
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统提醒新增修改")
    public String insertormodifyremindconfig() throws YosException {
        long sys_remind_configid = content.getLongValue("sys_remind_configid");
        String ownertable = content.getString("ownertable");
        String remindname = content.getString("remindname");
        JSONArray remindmode = content.getJSONArray("remindmode");
        String remindtitle = content.getString("remindtitle");
        String content_str = content.getString("content", true);
        String remarks = content.getString("remarks");

        String wechatservice_systemclient = content.getString("wechatservice_systemclient");
        JSONObject wechatservice_content = new JSONObject();
        if (content.containsKey("wechatservice_content")) {
            try {
                wechatservice_content = content.getJSONObject("wechatservice_content");
                if (wechatservice_content.containsKey("templates")) {
                    wechatservice_content.getJSONObject("templates").remove("content");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (content.getBooleanValue("isasync")) {
            Rows sys_remind_configRows = dbConnect.runSqlQuery("select * from sys_remind_config where remindname='" + remindname + "'");
            if (sys_remind_configRows.isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统提醒新增");
                sqlFactory.addParameter("sys_remind_configid", createTableID("sys_remind_config"));
                sqlFactory.addParameter("ownertable", ownertable);
                sqlFactory.addParameter("remindname", remindname);
                sqlFactory.addParameter("remindmode", remindmode);
                sqlFactory.addParameter("remindtitle", remindtitle);
                sqlFactory.addParameter("content", content_str);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("changeuserid", userid);
                sqlFactory.addParameter("wechatservice_systemclient", wechatservice_systemclient);
                sqlFactory.addParameter("wechatservice_content", wechatservice_content);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                sys_remind_configid = sys_remind_configRows.get(0).getLong("sys_remind_configid");
                ArrayList<String> sqlist = new ArrayList<>();
                SQLFactory sqlFactory = new SQLFactory(this, "系统提醒修改");
                sqlFactory.addParameter("sys_remind_configid", sys_remind_configid);
                sqlFactory.addParameter("ownertable", ownertable);
                sqlFactory.addParameter("remindname", remindname);
                sqlFactory.addParameter("remindmode", remindmode);
                sqlFactory.addParameter("remindtitle", remindtitle);
                sqlFactory.addParameter("content", content_str);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("changeuserid", userid);
                sqlFactory.addParameter("wechatservice_systemclient", wechatservice_systemclient);
                sqlFactory.addParameter("wechatservice_content", wechatservice_content);
                sqlist.add(sqlFactory.getSQL());

                if (content.getBooleanValue("sitesync")) {
                    sqlist.add("update sys_remind_configs set remindtitle='" + remindtitle + "',content='" + content_str + "',wechatservice_systemclient='" + wechatservice_systemclient + "',wechatservice_content='" + wechatservice_content + "',changeuserid=" + userid + " where sys_remind_configid=" + sys_remind_configid);
                    ArrayList<String> siteList = dbConnect.runSqlQuery("select siteid from sys_site where siteid !='YOSSYS' and siteid not in (select siteid from sys_remind_configs where sys_remind_configid=" + sys_remind_configid + ")").toArrayList("siteid");
                    for (String s : siteList) {
                        SQLFactory sqlFactory2 = new SQLFactory(this, "站点系统提醒新增");
                        sqlFactory2.addParameter("sys_remind_configsid", createTableID("sys_remind_configs"));
                        sqlFactory2.addParameter("sys_remind_configid", sys_remind_configid);
                        sqlFactory2.addParameter("remindtitle", remindtitle);
                        sqlFactory2.addParameter("siteid", s);
                        sqlFactory2.addParameter("remindmode", remindmode);
                        sqlFactory2.addParameter("content", content_str);
                        sqlFactory2.addParameter("isrole", 0);
                        sqlFactory2.addParameter("roleids", "[]");
                        sqlFactory2.addParameter("isuser", 0);
                        sqlFactory2.addParameter("userids", "[]");
                        sqlFactory2.addParameter("issql", 0);
                        sqlFactory2.addParameter("sqlstr", "");
                        sqlFactory2.addParameter("changeuserid", userid);
                        sqlFactory2.addParameter("wechatservice_systemclient", wechatservice_systemclient);
                        sqlFactory2.addParameter("wechatservice_content", wechatservice_content);
                        sqlist.add(sqlFactory2.getSQL());
                    }
                }
                dbConnect.runSqlUpdate(sqlist);
            }
        } else {

            if (remindname.equals("") || !String.valueOf(remindname.charAt(0)).matches("^[a-z]*")) {
                return getErrReturnObject().setErrMsg("提醒名称必须以英文字母开头").toString();
            }
            if (!remindname.replace("_", "").matches("^[a-z0-9]*")) {
                return getErrReturnObject().setErrMsg("提醒名称为英文字母或英文数字组合").toString();
            }
            if (dbConnect.runSqlQuery("select *from sys_remind_config where remindname='" + remindname + "' and sys_remind_configid!=" + sys_remind_configid).isNotEmpty()) {
                return getErrReturnObject().setErrMsg("提醒名称不可重复").toString();
            }
            if (sys_remind_configid <= 0 && dbConnect.runSqlQuery("select *from sys_remind_config where sys_remind_configid=" + sys_remind_configid).isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统提醒新增");
                sqlFactory.addParameter("sys_remind_configid", createTableID("sys_remind_config"));
                sqlFactory.addParameter("ownertable", ownertable);
                sqlFactory.addParameter("remindname", remindname);
                sqlFactory.addParameter("remindmode", remindmode);
                sqlFactory.addParameter("remindtitle", remindtitle);
                sqlFactory.addParameter("content", content_str);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("changeuserid", userid);
                sqlFactory.addParameter("wechatservice_systemclient", wechatservice_systemclient);
                sqlFactory.addParameter("wechatservice_content", wechatservice_content);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                ArrayList<String> sqlist = new ArrayList<>();
                SQLFactory sqlFactory = new SQLFactory(this, "系统提醒修改");
                sqlFactory.addParameter("sys_remind_configid", sys_remind_configid);
                sqlFactory.addParameter("ownertable", ownertable);
                sqlFactory.addParameter("remindname", remindname);
                sqlFactory.addParameter("remindmode", remindmode);
                sqlFactory.addParameter("remindtitle", remindtitle);
                sqlFactory.addParameter("content", content_str);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("changeuserid", userid);
                sqlFactory.addParameter("wechatservice_systemclient", wechatservice_systemclient);
                sqlFactory.addParameter("wechatservice_content", wechatservice_content);
                sqlist.add(sqlFactory.getSQL());

                if (content.getBooleanValue("sitesync")) {
                    sqlist.add("update sys_remind_configs set remindtitle='" + remindtitle + "',content='" + content_str + "',wechatservice_systemclient='" + wechatservice_systemclient + "',wechatservice_content='" + wechatservice_content + "',changeuserid=" + userid + " where sys_remind_configid=" + sys_remind_configid);
                    ArrayList<String> siteList = dbConnect.runSqlQuery("select siteid from sys_site where siteid !='YOSSYS' and siteid not in (select siteid from sys_remind_configs where sys_remind_configid=" + sys_remind_configid + ")").toArrayList("siteid");
                    for (String s : siteList) {
                        SQLFactory sqlFactory2 = new SQLFactory(this, "站点系统提醒新增");
                        sqlFactory2.addParameter("sys_remind_configsid", createTableID("sys_remind_configs"));
                        sqlFactory2.addParameter("sys_remind_configid", sys_remind_configid);
                        sqlFactory2.addParameter("remindtitle", remindtitle);
                        sqlFactory2.addParameter("siteid", s);
                        sqlFactory2.addParameter("remindmode", remindmode);
                        sqlFactory2.addParameter("content", content_str);
                        sqlFactory2.addParameter("isrole", 0);
                        sqlFactory2.addParameter("roleids", "[]");
                        sqlFactory2.addParameter("isuser", 0);
                        sqlFactory2.addParameter("userids", "[]");
                        sqlFactory2.addParameter("issql", 0);
                        sqlFactory2.addParameter("sqlstr", "");
                        sqlFactory2.addParameter("changeuserid", userid);
                        sqlFactory2.addParameter("wechatservice_systemclient", wechatservice_systemclient);
                        sqlFactory2.addParameter("wechatservice_content", wechatservice_content);
                        sqlist.add(sqlFactory2.getSQL());
                    }
                }
                dbConnect.runSqlUpdate(sqlist);
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "系统提醒删除")
    public String deleteremindconfig() throws YosException {
        long sys_remind_configid = content.getLong("sys_remind_configid");
        if (dbConnect.runSqlQuery("select * from sys_remind_configs where sys_remind_configid=" + sys_remind_configid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("系统提醒已被使用，不可删除！").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_remind_config where sys_remind_configid=" + sys_remind_configid);
        return getSucReturnObject().toString();
    }

    /**
     * 查询公众号消息模版
     *
     * @return
     */
    @API(title = "微信消息模版查询")
    public String queryWechatServiceTemplate() throws YosException {
        String wechatservice_systemclient = content.getString("wechatservice_systemclient");
        WechatService wechatService = new WechatService(wechatservice_systemclient);
        JSONArray array = wechatService.getTemplate_List();
        for (Object o : array) {
            JSONObject object = (JSONObject) o;
            object.remove("primary_industry");
            object.remove("deputy_industry");
            object.put("example", object.getString("example").replace("\r\n", ""));

            JSONArray paramArray = new JSONArray();

            String c = object.getString("content");
            while (c.contains("{{") && c.contains("}}")) {
                String param = c.substring(c.indexOf("{{") + 2, c.indexOf(".DATA}}")).replace(".DATA", "");
                JSONObject paramObject = new JSONObject();
                paramObject.put("key", param);
                paramObject.put("value", "");
                paramArray.add(paramObject);
                c = c.replaceFirst("\\{\\{", "").replaceFirst(".DATA}}", "");
            }
            object.put("param", paramArray);
            object.remove("content");
        }
        return getSucReturnObject().setData(array).toString();
    }
}
