package restcontroller.sysmanage.develop.optiontype.custom;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.ArrayList;

import common.YosException;

@API(title = "管理端-开发-选项分类-自定义选项")
public class customoptiontype extends Controller {
    public customoptiontype(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 选项分类查询
     *
     * @return
     */
    @API(title = "选项分类查询")
    @CACHEING
    public String query_optiontypeList() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.typename like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.remarks like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        SQLFactory typelistSQL = new SQLFactory(this, "选项分类查询", pageSize, pageNumber, pageSorting);
        typelistSQL.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(typelistSQL.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 选项分类新增、修改
     *
     * @return
     */
    @API(title = "选项分类新增、修改")
    @CACHEING_CLEAN(cms = {@cm(clazz = customoptiontype.class, method = {"query_optiontypeList"})})
    public String insertormodify_optiontype() throws YosException {
        long optiontypeid = content.getLongValue("optiontypeid");//分类ID，必填
        String typename = content.getString("typename");
        boolean issubvaluemag = content.getBooleanValue("issubvaluemag");
        typename = typename.toLowerCase();
        if (typename.equals("") || !String.valueOf(typename.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("分类名称必须以英文字母开头").toString();
        }
        if (!typename.matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("分类名称必须为英文字母或英文数字组合").toString();
        }
        String remarks = content.getString("remarks");
        SQLFactory sqlFactory = null;
        if (content.getBooleanValue("isasync")) {
            Rows sys_optiontypeRows = dbConnect.runSqlQuery("select *from sys_optiontype where typename='" + typename + "'");
            if (sys_optiontypeRows.isEmpty()) {
                sqlFactory = new SQLFactory(this, "选项分类新增");
                sqlFactory.addParameter("optiontypeid", createTableID("sys_optiontype"));
                sqlFactory.addParameter("typename", typename);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("issubvaluemag", issubvaluemag);
            } else {
                optiontypeid = sys_optiontypeRows.get(0).getLong("optiontypeid");
                sqlFactory = new SQLFactory(this, "选项分类修改");
                sqlFactory.addParameter("optiontypeid", optiontypeid);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("issubvaluemag", issubvaluemag);
            }
        } else {
            if (optiontypeid <= 0 || dbConnect.runSqlQuery("select optiontypeid from sys_optiontype where optiontypeid=" + optiontypeid).isEmpty()) {
                sqlFactory = new SQLFactory(this, "选项分类新增");
                sqlFactory.addParameter("optiontypeid", createTableID("sys_optiontype"));
                sqlFactory.addParameter("typename", typename);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("issubvaluemag", issubvaluemag);
            } else {
                sqlFactory = new SQLFactory(this, "选项分类修改");
                sqlFactory.addParameter("optiontypeid", optiontypeid);
                sqlFactory.addParameter("remarks", remarks);
                sqlFactory.addParameter("issubvaluemag", issubvaluemag);
            }
        }
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }

    /**
     * 分类删除
     *
     * @return
     */
    @API(title = "选项分类删除")
    @CACHEING_CLEAN(cms = {@cm(clazz = customoptiontype.class, method = {"query_optiontypeList"})})
    public String delete_optiontype() throws YosException {
        long optiontypeid = content.getLong("optiontypeid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_optiontype where issystem=0 and optiontypeid=" + optiontypeid);
        list.add("delete from sys_optiontypemx where issystem=0 and optiontypeid=" + optiontypeid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    /**
     * 分类明细查询
     *
     * @return
     */
    @API(title = "分类明细查询")
    @CACHEING
    public String query_optiontypemxList() throws YosException {
        long optiontypeid = content.getLong("optiontypeid");
        SQLFactory sqlFactory = new SQLFactory(this, "选项分类明细查询");
        sqlFactory.addParameter("optiontypeid", optiontypeid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        for (Row row : rows) {
            row.put("subvalues", row.getJSONArray("subvalues"));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 选项分类明细新增、修改
     *
     * @return
     */
    @API(title = "选项分类明细新增、修改")
    @CACHEING_CLEAN(cms = {@cm(clazz = customoptiontype.class, method = {"query_optiontypemxList"})})
    public String insertormodify_optiontypemx() throws YosException {
        long optiontypeid = content.getLong("optiontypeid");//分类ID，必填
        long optiontypemxid = content.getLong("optiontypemxid");//分类明细ID。新增传0
        boolean isused = content.getBooleanValue("isused");
        String value = content.getString("value");
        JSONArray subvalues = new JSONArray();
        if (content.containsKey("subvalues") && !content.getString("subvalues").equals("")) {
            subvalues = content.getJSONArray("subvalues");
        }
        String remarks = content.getString("remarks");
        int sequence = content.getInteger("sequence");

        SQLFactory sqlFactory = null;
        if (optiontypemxid <= 0 || dbConnect.runSqlQuery("select optiontypemxid from sys_optiontypemx where siteid='" + siteid + "' and optiontypemxid=" + optiontypemxid).isEmpty()) {
            optiontypemxid = createTableID("sys_optiontypemx");
            sqlFactory = new SQLFactory(this, "选项分类明细新增");
            sqlFactory.addParameter("optiontypeid", optiontypeid);
            sqlFactory.addParameter("optiontypemxid", optiontypemxid);
            sqlFactory.addParameter("isused", isused);
            sqlFactory.addParameter("value", value);
            sqlFactory.addParameter("subvalues", subvalues.toString());
            sqlFactory.addParameter("remarks", remarks);
            sqlFactory.addParameter("sequence", sequence);
            sqlFactory.addParameter("siteid", siteid);
        } else {
            sqlFactory = new SQLFactory(this, "选项分类明细修改");
            sqlFactory.addParameter("optiontypeid", optiontypeid);
            sqlFactory.addParameter("optiontypemxid", optiontypemxid);
            sqlFactory.addParameter("isused", isused);
            sqlFactory.addParameter("value", value);
            sqlFactory.addParameter("subvalues", subvalues.toString());
            sqlFactory.addParameter("remarks", remarks);
            sqlFactory.addParameter("sequence", sequence);
            sqlFactory.addParameter("siteid", siteid);
        }
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }

    /**
     * 分类明细删除
     *
     * @return
     */
    @API(title = "分类明细删除")
    @CACHEING_CLEAN(cms = {@cm(clazz = customoptiontype.class, method = {"query_optiontypemxList"})})
    public String delete_optiontypemx() throws YosException {
        long optiontypemxid = content.getLong("optiontypemxid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_optiontypemx where issystem=0 and optiontypemxid=" + optiontypemxid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }
}
